/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSetFactory;
import com.ibm.wala.util.intset.SemiSparseMutableIntSet;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemiSparseMutableIntSetFactory
implements MutableIntSetFactory<SemiSparseMutableIntSet> {
    @Override
    public SemiSparseMutableIntSet make(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("set is null");
        }
        if (nArray.length == 0) {
            return this.make();
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int n = 0;
        while (n < nArray.length) {
            treeSet.add(nArray[n]);
            ++n;
        }
        SemiSparseMutableIntSet semiSparseMutableIntSet = new SemiSparseMutableIntSet();
        for (Integer n2 : treeSet) {
            semiSparseMutableIntSet.add(n2);
        }
        return semiSparseMutableIntSet;
    }

    @Override
    public SemiSparseMutableIntSet parse(String string) throws NumberFormatException {
        int[] nArray = SparseIntSet.parseIntArray(string);
        SemiSparseMutableIntSet semiSparseMutableIntSet = new SemiSparseMutableIntSet();
        int n = 0;
        while (n < nArray.length) {
            semiSparseMutableIntSet.add(nArray[n]);
            ++n;
        }
        return semiSparseMutableIntSet;
    }

    @Override
    public SemiSparseMutableIntSet makeCopy(IntSet intSet) {
        SemiSparseMutableIntSet semiSparseMutableIntSet = new SemiSparseMutableIntSet();
        semiSparseMutableIntSet.copySet(intSet);
        return semiSparseMutableIntSet;
    }

    @Override
    public SemiSparseMutableIntSet make() {
        return new SemiSparseMutableIntSet();
    }
}

