/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OffsetOrdinalSetMapping<T>
implements OrdinalSetMapping<T> {
    private final OrdinalSetMapping<T> delegate;
    private final int offset;

    private OffsetOrdinalSetMapping(OrdinalSetMapping<T> ordinalSetMapping, int n) {
        this.delegate = ordinalSetMapping;
        this.offset = n;
    }

    @Override
    public int getMaximumIndex() {
        return this.offset + this.delegate.getMaximumIndex();
    }

    @Override
    public int getSize() {
        return this.delegate.getSize();
    }

    public static <T> OffsetOrdinalSetMapping<T> make(OrdinalSetMapping<T> ordinalSetMapping, int n) {
        if (ordinalSetMapping == null) {
            throw new IllegalArgumentException("null delegate");
        }
        return new OffsetOrdinalSetMapping<T>(ordinalSetMapping, n);
    }

    public static <T> OffsetOrdinalSetMapping<T> make(int n) {
        MutableMapping mutableMapping = MutableMapping.make();
        return new OffsetOrdinalSetMapping(mutableMapping, n);
    }

    @Override
    public int add(T t) {
        return this.offset + this.delegate.add(t);
    }

    @Override
    public int getMappedIndex(T t) {
        if (this.delegate.getMappedIndex(t) == -1) {
            return -1;
        }
        return this.offset + this.delegate.getMappedIndex(t);
    }

    @Override
    public T getMappedObject(int n) throws NoSuchElementException {
        return this.delegate.getMappedObject(n - this.offset);
    }

    @Override
    public boolean hasMappedIndex(T t) {
        return this.delegate.hasMappedIndex(t);
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }
}

