/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.LongSet;
import com.ibm.wala.util.intset.MutableLongSet;
import com.ibm.wala.util.intset.MutableLongSetFactory;
import com.ibm.wala.util.intset.MutableSparseLongSet;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.TreeSet;

public class MutableSparseLongSetFactory
implements MutableLongSetFactory {
    public MutableLongSet make(long[] lArray) {
        if (lArray == null) {
            throw new IllegalArgumentException("set is null");
        }
        if (lArray.length == 0) {
            return new MutableSparseLongSet();
        }
        TreeSet<Long> treeSet = new TreeSet<Long>();
        int n = 0;
        while (n < lArray.length) {
            treeSet.add(lArray[n]);
            ++n;
        }
        long[] lArray2 = new long[treeSet.size()];
        int n2 = 0;
        for (Long l : treeSet) {
            lArray2[n2++] = l;
        }
        MutableSparseLongSet mutableSparseLongSet = new MutableSparseLongSet(lArray2);
        return mutableSparseLongSet;
    }

    public MutableLongSet parse(String string) throws NumberFormatException {
        int[] nArray = SparseIntSet.parseIntArray(string);
        long[] lArray = new long[nArray.length];
        int n = 0;
        while (n < lArray.length) {
            lArray[n] = nArray[n];
            ++n;
        }
        return new MutableSparseLongSet(lArray);
    }

    public MutableLongSet makeCopy(LongSet longSet) throws IllegalArgumentException {
        if (longSet == null) {
            throw new IllegalArgumentException("x == null");
        }
        return MutableSparseLongSet.make(longSet);
    }

    public MutableLongSet make() {
        return new MutableSparseLongSet();
    }
}

