/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.BitVectorBase;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.SparseIntSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableSparseIntSet
extends SparseIntSet
implements MutableIntSet {
    private static final float EXPANSION_FACTOR = 1.5f;
    private static final int INITIAL_NONEMPTY_SIZE = 2;
    private static final boolean DEBUG_LARGE = false;
    private static final int TRAP_SIZE = 1000;

    protected MutableSparseIntSet(IntSet intSet) {
        this.copySet(intSet);
    }

    protected MutableSparseIntSet(int[] nArray) {
        super(nArray);
    }

    private MutableSparseIntSet(int n) throws IllegalArgumentException {
        super(new int[n]);
        this.size = 0;
        if (n <= 0) {
            throw new IllegalArgumentException("initialCapacity must be positive");
        }
    }

    protected MutableSparseIntSet() {
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean remove(int n) {
        if (this.elements != null) {
            int n2 = 0;
            while (n2 < this.size) {
                if (this.elements[n2] >= n) break;
                ++n2;
            }
            if (n2 == this.size) {
                return false;
            }
            if (this.elements[n2] == n) {
                if (this.size == 1) {
                    this.elements = null;
                    this.size = 0;
                } else {
                    if (n2 < this.size) {
                        System.arraycopy(this.elements, n2 + 1, this.elements, n2, this.size - n2 - 1);
                    }
                    --this.size;
                }
                return true;
            }
        }
        return false;
    }

    public int getInitialNonEmptySize() {
        return 2;
    }

    public float getExpansionFactor() {
        return 1.5f;
    }

    @Override
    public boolean add(int n) {
        int n2;
        if (this.elements == null) {
            this.elements = new int[this.getInitialNonEmptySize()];
            this.size = 1;
            this.elements[0] = n;
            return true;
        }
        if (this.size == 0 || n > this.max()) {
            n2 = this.size;
        } else {
            if (n == this.max()) {
                return false;
            }
            n2 = 0;
            while (n2 < this.size) {
                if (this.elements[n2] >= n) break;
                ++n2;
            }
        }
        if (n2 < this.size && this.elements[n2] == n) {
            return false;
        }
        if (this.size < this.elements.length - 1) {
            if (this.size != n2) {
                System.arraycopy(this.elements, n2, this.elements, n2 + 1, this.size - n2);
            }
            ++this.size;
            this.elements[n2] = n;
            return true;
        }
        float f = (float)this.elements.length * this.getExpansionFactor() + 1.0f;
        int[] nArray = new int[(int)f];
        System.arraycopy(this.elements, 0, nArray, 0, n2);
        if (this.size != n2) {
            System.arraycopy(this.elements, n2, nArray, n2 + 1, this.size - n2);
        }
        nArray[n2] = n;
        ++this.size;
        this.elements = nArray;
        return true;
    }

    @Override
    public void copySet(IntSet intSet) throws IllegalArgumentException {
        if (intSet == null) {
            throw new IllegalArgumentException("that == null");
        }
        if (intSet instanceof SparseIntSet) {
            SparseIntSet sparseIntSet = (SparseIntSet)intSet;
            if (sparseIntSet.elements != null) {
                this.elements = new int[sparseIntSet.elements.length];
                int n = 0;
                while (n < sparseIntSet.size) {
                    this.elements[n] = sparseIntSet.elements[n];
                    ++n;
                }
                this.size = sparseIntSet.size;
            } else {
                this.elements = null;
                this.size = 0;
            }
        } else {
            this.elements = new int[intSet.size()];
            this.size = intSet.size();
            intSet.foreach(new IntSetAction(){
                private int index = 0;

                public void act(int n) {
                    MutableSparseIntSet.this.elements[this.index++] = n;
                }
            });
        }
    }

    @Override
    public void intersectWith(IntSet intSet) {
        if (intSet == null) {
            throw new IllegalArgumentException("null set");
        }
        if (intSet instanceof SparseIntSet) {
            this.intersectWith((SparseIntSet)intSet);
        } else {
            int n = 0;
            int n2 = 0;
            while (n2 < this.size) {
                if (intSet.contains(this.elements[n2])) {
                    this.elements[n++] = this.elements[n2];
                }
                ++n2;
            }
            this.size = n;
        }
    }

    public void intersectWith(SparseIntSet sparseIntSet) {
        if (sparseIntSet == null) {
            throw new IllegalArgumentException("null set");
        }
        SparseIntSet sparseIntSet2 = sparseIntSet;
        if (this.isEmpty()) {
            return;
        }
        if (sparseIntSet2.isEmpty()) {
            this.elements = null;
            this.size = 0;
            return;
        }
        if (this.equals(sparseIntSet2)) {
            return;
        }
        if (this.size == 1) {
            if (sparseIntSet2.contains(this.elements[0])) {
                return;
            }
            this.elements = null;
            this.size = 0;
            return;
        }
        if (sparseIntSet2.size == 1) {
            if (this.contains(sparseIntSet2.elements[0])) {
                if (this.size > this.getInitialNonEmptySize()) {
                    this.elements = new int[this.getInitialNonEmptySize()];
                }
                this.size = 1;
                this.elements[0] = sparseIntSet2.elements[0];
                return;
            }
            this.elements = null;
            this.size = 0;
            return;
        }
        int[] nArray = this.elements;
        int n = 0;
        int n2 = this.size;
        int[] nArray2 = sparseIntSet2.elements;
        int n3 = 0;
        int n4 = sparseIntSet2.size;
        int[] nArray3 = null;
        int n5 = 0;
        while (n < n2 && n3 < n4) {
            int n6 = nArray[n] - nArray2[n3];
            if (n6 > 0) {
                ++n3;
                continue;
            }
            if (n6 < 0) {
                ++n;
                continue;
            }
            if (nArray3 == null) {
                nArray3 = new int[n2];
            }
            nArray3[n5++] = nArray[n];
            ++n;
            ++n3;
        }
        this.size = n5;
        this.elements = nArray3;
    }

    @Override
    public boolean addAll(IntSet intSet) throws IllegalArgumentException {
        if (intSet == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (intSet instanceof SparseIntSet) {
            return this.addAll((SparseIntSet)intSet);
        }
        int n = this.size;
        intSet.foreach(new IntSetAction(){

            public void act(int n) {
                if (!MutableSparseIntSet.this.contains(n)) {
                    MutableSparseIntSet.this.add(n);
                }
            }
        });
        return this.size != n;
    }

    public boolean addAll(SparseIntSet sparseIntSet) {
        if (sparseIntSet == null) {
            throw new IllegalArgumentException("null that");
        }
        if (this.isEmpty()) {
            this.copySet(sparseIntSet);
            return !sparseIntSet.isEmpty();
        }
        if (sparseIntSet.isEmpty()) {
            return false;
        }
        if (this.equals(sparseIntSet)) {
            return false;
        }
        if (sparseIntSet.size == 1) {
            boolean bl = this.add(sparseIntSet.elements[0]);
            return bl;
        }
        int[] nArray = sparseIntSet.elements;
        int n = sparseIntSet.size();
        return this.addAll(nArray, n);
    }

    private boolean addAll(int[] nArray, int n) {
        int n2;
        int[] nArray2 = this.elements;
        int n3 = 0;
        int n4 = this.size();
        int n5 = 0;
        int[] nArray3 = null;
        int n6 = 0;
        while (n3 < n4 && n5 < n) {
            n2 = nArray2[n3] - nArray[n5];
            if (n2 > 0) {
                if (nArray3 == null) {
                    nArray3 = new int[n4 + n];
                    System.arraycopy(nArray2, 0, nArray3, 0, n6);
                }
                nArray3[n6++] = nArray[n5++];
                continue;
            }
            if (n2 < 0) {
                if (nArray3 != null) {
                    nArray3[n6] = nArray2[n3];
                }
                ++n6;
                ++n3;
                continue;
            }
            if (nArray3 != null) {
                nArray3[n6] = nArray2[n3];
            }
            ++n6;
            ++n3;
            ++n5;
        }
        if (n3 < n4) {
            n2 = n4 - n3;
            if (nArray3 != null) {
                System.arraycopy(nArray2, n3, nArray3, n6, n2);
            }
            n6 += n2;
        } else if (n5 < n) {
            n2 = n - n5;
            if (nArray3 == null) {
                nArray3 = new int[n4 + n];
                System.arraycopy(nArray2, 0, nArray3, 0, n6);
            }
            System.arraycopy(nArray, n5, nArray3, n6, n2);
            n6 += n2;
        }
        assert (n6 > 0);
        this.elements = nArray3 == null ? nArray2 : nArray3;
        this.size = n6;
        return n4 != this.size;
    }

    public void removeAll(BitVectorIntSet bitVectorIntSet) {
        if (bitVectorIntSet == null) {
            throw new IllegalArgumentException("null v");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.size) {
            if (!bitVectorIntSet.contains(this.elements[n2])) {
                this.elements[n++] = this.elements[n2];
            }
            ++n2;
        }
        this.size = n;
    }

    public <T extends BitVectorBase<T>> void removeAll(T t) {
        if (t == null) {
            throw new IllegalArgumentException("null v");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.size) {
            if (!t.get(this.elements[n2])) {
                this.elements[n++] = this.elements[n2];
            }
            ++n2;
        }
        this.size = n;
    }

    public void removeAll(MutableSparseIntSet mutableSparseIntSet) {
        if (mutableSparseIntSet == null) {
            throw new IllegalArgumentException("set is null");
        }
        IntIterator intIterator = mutableSparseIntSet.intIterator();
        while (intIterator.hasNext()) {
            this.remove(intIterator.next());
        }
    }

    @Override
    public boolean addAllInIntersection(IntSet intSet, IntSet intSet2) {
        if (intSet == null) {
            throw new IllegalArgumentException("other is null");
        }
        if (intSet2 == null) {
            throw new IllegalArgumentException("invalid filter");
        }
        if (intSet.size() < 5) {
            boolean bl = false;
            IntIterator intIterator = intSet.intIterator();
            while (intIterator.hasNext()) {
                int n = intIterator.next();
                if (!intSet2.contains(n)) continue;
                bl |= this.add(n);
            }
            return bl;
        }
        if (intSet2.size() < 5) {
            boolean bl = false;
            IntIterator intIterator = intSet2.intIterator();
            while (intIterator.hasNext()) {
                int n = intIterator.next();
                if (!intSet.contains(n)) continue;
                bl |= this.add(n);
            }
            return bl;
        }
        BitVectorIntSet bitVectorIntSet = new BitVectorIntSet(intSet);
        bitVectorIntSet.intersectWith(intSet2);
        return this.addAll(bitVectorIntSet);
    }

    public static MutableSparseIntSet diff(MutableSparseIntSet mutableSparseIntSet, MutableSparseIntSet mutableSparseIntSet2) {
        return new MutableSparseIntSet(MutableSparseIntSet.diffInternal(mutableSparseIntSet, mutableSparseIntSet2));
    }

    public static MutableSparseIntSet make(IntSet intSet) {
        return new MutableSparseIntSet(intSet);
    }

    public static MutableSparseIntSet makeEmpty() {
        return new MutableSparseIntSet();
    }

    public static MutableSparseIntSet createMutableSparseIntSet(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("illegal initialCapacity: " + n);
        }
        return new MutableSparseIntSet(n);
    }
}

