/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.intset.OrdinalSet;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableMapping<T>
implements OrdinalSetMapping<T> {
    private static final int INITIAL_CAPACITY = 20;
    private static final int MAX_SIZE = 0x1FFFFFFF;
    private Object[] array;
    private int nextIndex = 0;
    final HashMap<T, Integer> map = HashMapFactory.make();

    public static <T> MutableMapping<T> make() {
        return new MutableMapping<T>();
    }

    public MutableMapping(Object[] objectArray) {
        if (objectArray == null) {
            throw new IllegalArgumentException("array is null");
        }
        this.array = new Object[2 * objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            this.array[n] = objectArray[n];
            this.map.put(objectArray[n], n);
            ++n;
        }
        this.nextIndex = objectArray.length;
    }

    protected MutableMapping() {
        this.array = new Object[20];
        this.nextIndex = 0;
    }

    @Override
    public T getMappedObject(int n) {
        try {
            return (T)this.array[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("n out of range " + n);
        }
    }

    @Override
    public int getMappedIndex(T t) {
        Integer n = this.map.get(t);
        if (n == null) {
            return -1;
        }
        return n;
    }

    @Override
    public boolean hasMappedIndex(T t) {
        return this.map.get(t) != null;
    }

    @Override
    public int add(T t) {
        Integer n = this.map.get(t);
        if (n != null) {
            return n;
        }
        this.map.put(t, new Integer(this.nextIndex));
        if (this.nextIndex >= this.array.length) {
            Object[] objectArray = this.array;
            this.array = new Object[2 * this.array.length];
            System.arraycopy(objectArray, 0, this.array, 0, objectArray.length);
        }
        int n2 = this.nextIndex++;
        this.array[n2] = t;
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.nextIndex) {
            stringBuffer.append(n).append("  ").append(this.array[n]).append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    public OrdinalSet<T> makeSingleton(int n) {
        return new OrdinalSet(SparseIntSet.singleton(n), this);
    }

    public void deleteMappedObject(T t) {
        int n = this.getMappedIndex(t);
        if (n != -1) {
            this.array[n] = null;
            this.map.remove(t);
        }
    }

    public Collection<T> getObjects() {
        return Collections.unmodifiableCollection(this.map.keySet());
    }

    public void replace(T t, T t2) throws IllegalArgumentException {
        int n = this.getMappedIndex(t);
        if (n == -1) {
            throw new IllegalArgumentException("first element does not exist in map");
        }
        this.map.remove(t);
        this.map.put(t2, new Integer(n));
        this.array[n] = t2;
    }

    public void put(int n, T t) {
        if (n < 0 || n > 0x1FFFFFFF) {
            throw new IllegalArgumentException("invalid i: " + n);
        }
        Integer n2 = n;
        this.map.put(t, n2);
        if (n >= this.array.length) {
            Object[] objectArray = this.array;
            this.array = new Object[2 * n];
            System.arraycopy(objectArray, 0, this.array, 0, objectArray.length);
        }
        this.array[n] = t;
        this.nextIndex = Math.max(this.nextIndex, n + 1);
    }

    @Override
    public int getMaximumIndex() {
        return this.nextIndex - 1;
    }

    @Override
    public int getSize() {
        return this.map.size();
    }
}

