/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.LongIterator;
import com.ibm.wala.util.intset.LongSet;
import com.ibm.wala.util.intset.MutableLongSet;
import com.ibm.wala.util.intset.MutableLongSetFactory;
import com.ibm.wala.util.intset.MutableSparseLongSet;
import com.ibm.wala.util.intset.MutableSparseLongSetFactory;
import com.ibm.wala.util.intset.SparseLongSet;

public class LongSetUtil {
    public static final String INT_SET_FACTORY_CONFIG_PROPERTY_NAME = "com.ibm.wala.mutableLongSetFactory";
    private static MutableLongSetFactory defaultLongSetFactory;
    private static final boolean DEBUG = false;

    static {
        MutableSparseLongSetFactory mutableSparseLongSetFactory = new MutableSparseLongSetFactory();
        if (System.getProperty(INT_SET_FACTORY_CONFIG_PROPERTY_NAME) != null) {
            try {
                Class<?> clazz = Class.forName(System.getProperty(INT_SET_FACTORY_CONFIG_PROPERTY_NAME));
                MutableLongSetFactory mutableLongSetFactory = (MutableLongSetFactory)clazz.newInstance();
                LongSetUtil.setDefaultLongSetFactory(mutableLongSetFactory);
            }
            catch (Exception exception) {
                System.err.println("Cannot use int set factory " + System.getProperty(INT_SET_FACTORY_CONFIG_PROPERTY_NAME));
                LongSetUtil.setDefaultLongSetFactory(mutableSparseLongSetFactory);
            }
        } else {
            LongSetUtil.setDefaultLongSetFactory(mutableSparseLongSetFactory);
        }
        assert (defaultLongSetFactory != null);
    }

    public static MutableLongSet make() {
        return defaultLongSetFactory.make();
    }

    public static MutableLongSet makeMutableCopy(LongSet longSet) throws IllegalArgumentException, UnimplementedError {
        if (longSet == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (longSet instanceof SparseLongSet) {
            return MutableSparseLongSet.make(longSet);
        }
        Assertions.UNREACHABLE(longSet.getClass().toString());
        return null;
    }

    public static LongSet diff(LongSet longSet, LongSet longSet2) {
        if (longSet == null) {
            throw new IllegalArgumentException("null A");
        }
        if (longSet2 == null) {
            throw new IllegalArgumentException("null B");
        }
        return LongSetUtil.diff(longSet, longSet2, LongSetUtil.getDefaultLongSetFactory());
    }

    private static LongSet defaultSlowDiff(LongSet longSet, LongSet longSet2, MutableLongSetFactory mutableLongSetFactory) {
        MutableLongSet mutableLongSet = mutableLongSetFactory.makeCopy(longSet);
        LongIterator longIterator = longSet2.longIterator();
        while (longIterator.hasNext()) {
            long l = longIterator.next();
            mutableLongSet.remove(l);
        }
        return mutableLongSet;
    }

    public static LongSet diff(LongSet longSet, LongSet longSet2, MutableLongSetFactory mutableLongSetFactory) {
        if (longSet == null) {
            throw new IllegalArgumentException("null A");
        }
        if (longSet2 == null) {
            throw new IllegalArgumentException("null B");
        }
        if (longSet instanceof SparseLongSet && longSet2 instanceof SparseLongSet) {
            return SparseLongSet.diff((SparseLongSet)longSet, (SparseLongSet)longSet2);
        }
        return LongSetUtil.defaultSlowDiff(longSet, longSet2, mutableLongSetFactory);
    }

    public static MutableLongSet removeAll(MutableLongSet mutableLongSet, LongSet longSet) throws IllegalArgumentException {
        if (mutableLongSet == null) {
            throw new IllegalArgumentException("A == null");
        }
        if (longSet == null) {
            throw new IllegalArgumentException("B == null");
        }
        LongIterator longIterator = longSet.longIterator();
        while (longIterator.hasNext()) {
            long l = longIterator.next();
            mutableLongSet.remove(l);
        }
        return mutableLongSet;
    }

    public static int binarySearch(long[] lArray, long l, int n, int n2) throws IllegalArgumentException {
        if (lArray == null) {
            throw new IllegalArgumentException("null array");
        }
        if (lArray.length == 0) {
            return -1;
        }
        if (n <= n2 && (n < 0 || n2 < 0)) {
            throw new IllegalArgumentException("can't search negative indices");
        }
        if (n2 > lArray.length - 1) {
            n2 = lArray.length - 1;
        }
        if (n <= n2) {
            int n3 = (n + n2) / 2;
            long l2 = lArray[n3];
            if (l2 == l) {
                return n3;
            }
            if (l2 > l) {
                return LongSetUtil.binarySearch(lArray, l, n, n3 - 1);
            }
            return LongSetUtil.binarySearch(lArray, l, n3 + 1, n2);
        }
        return -1;
    }

    public static MutableLongSetFactory getDefaultLongSetFactory() {
        return defaultLongSetFactory;
    }

    public static void setDefaultLongSetFactory(MutableLongSetFactory mutableLongSetFactory) {
        if (mutableLongSetFactory == null) {
            throw new IllegalArgumentException("null defaultLongSetFactory");
        }
        defaultLongSetFactory = mutableLongSetFactory;
    }

    public static LongSet add(LongSet longSet, int n) throws IllegalArgumentException {
        if (longSet == null) {
            throw new IllegalArgumentException("s == null");
        }
        if (longSet instanceof SparseLongSet) {
            SparseLongSet sparseLongSet = (SparseLongSet)longSet;
            return SparseLongSet.add(sparseLongSet, n);
        }
        MutableSparseLongSet mutableSparseLongSet = MutableSparseLongSet.make(longSet);
        mutableSparseLongSet.add(n);
        return mutableSparseLongSet;
    }
}

