/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

public class IntegerUnionFind {
    private static final int MAX_VALUE = 0x1FFFFFFF;
    private static final int DEFAULT_SIZE = 100;
    int[] parent;

    public IntegerUnionFind() {
        this(100);
    }

    public IntegerUnionFind(int n) {
        if (n < 0 || n > 0x1FFFFFFF) {
            throw new IllegalArgumentException("illegal size: " + n);
        }
        this.parent = new int[n + 1];
    }

    public void union(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid x : " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("invalid y: " + n2);
        }
        if (n > 0x1FFFFFFF) {
            throw new IllegalArgumentException("x is too big: " + n);
        }
        if (n2 > 0x1FFFFFFF) {
            throw new IllegalArgumentException("y is too big: " + n2);
        }
        if (n >= this.size() || n2 >= this.size()) {
            this.grow(2 * Math.max(n, n2));
        }
        ++n;
        ++n2;
        if ((n = this.findInternal(n)) != (n2 = this.findInternal(n2))) {
            if (this.parent[n] < this.parent[n2]) {
                int n3 = n;
                this.parent[n3] = this.parent[n3] + (this.parent[n2] - 1);
                this.parent[n2] = n;
            } else {
                int n4 = n2;
                this.parent[n4] = this.parent[n4] + (this.parent[n] - 1);
                this.parent[n] = n2;
            }
        }
    }

    private void grow(int n) {
        int[] nArray = this.parent;
        this.parent = new int[n + 1];
        System.arraycopy(nArray, 0, this.parent, 0, nArray.length);
    }

    public int find(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("illegal x " + n);
        }
        if (n >= this.size()) {
            return n;
        }
        return this.findInternal(n + 1) - 1;
    }

    private int findInternal(int n) {
        int n2 = n;
        while (this.parent[n2] > 0) {
            n2 = this.parent[n2];
        }
        while (this.parent[n] > 0) {
            int n3 = n;
            n = this.parent[n];
            this.parent[n3] = n2;
        }
        return n2;
    }

    public int size() {
        return this.parent.length - 1;
    }
}

