/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.DebuggingMutableIntSet;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableIntSetFactory;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSetFactory;
import com.ibm.wala.util.intset.MutableSparseIntSetFactory;
import com.ibm.wala.util.intset.SparseIntSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebuggingMutableIntSetFactory
implements MutableIntSetFactory<DebuggingMutableIntSet> {
    private MutableIntSetFactory primary;
    private MutableIntSetFactory secondary;

    public DebuggingMutableIntSetFactory(MutableIntSetFactory mutableIntSetFactory, MutableIntSetFactory mutableIntSetFactory2) {
        this.primary = mutableIntSetFactory;
        this.secondary = mutableIntSetFactory2;
        if (mutableIntSetFactory == null) {
            throw new IllegalArgumentException("null p");
        }
        if (mutableIntSetFactory2 == null) {
            throw new IllegalArgumentException("null s");
        }
    }

    public DebuggingMutableIntSetFactory() {
        this(new MutableSparseIntSetFactory(), new MutableSharedBitVectorIntSetFactory());
    }

    @Override
    public DebuggingMutableIntSet make(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("null set");
        }
        return new DebuggingMutableIntSet((MutableIntSet)this.primary.make(nArray), (MutableIntSet)this.secondary.make(nArray));
    }

    @Override
    public DebuggingMutableIntSet parse(String string) {
        int[] nArray = SparseIntSet.parseIntArray(string);
        return this.make(nArray);
    }

    @Override
    public DebuggingMutableIntSet makeCopy(IntSet intSet) throws UnimplementedError {
        if (intSet == null) {
            throw new IllegalArgumentException("null x");
        }
        if (intSet instanceof DebuggingMutableIntSet) {
            DebuggingMutableIntSet debuggingMutableIntSet = (DebuggingMutableIntSet)intSet;
            Object t = this.primary.makeCopy(debuggingMutableIntSet.primaryImpl);
            Object t2 = this.secondary.makeCopy(debuggingMutableIntSet.secondaryImpl);
            assert (t.sameValue(debuggingMutableIntSet.primaryImpl));
            assert (t2.sameValue(debuggingMutableIntSet.secondaryImpl));
            assert (t.sameValue((IntSet)t2));
            return new DebuggingMutableIntSet((MutableIntSet)t, (MutableIntSet)t2);
        }
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public DebuggingMutableIntSet make() {
        return new DebuggingMutableIntSet((MutableIntSet)this.primary.make(), (MutableIntSet)this.secondary.make());
    }

    public void setPrimaryFactory(MutableIntSetFactory mutableIntSetFactory) {
        if (mutableIntSetFactory == null) {
            throw new IllegalArgumentException("null x");
        }
        if (mutableIntSetFactory == this) {
            throw new IllegalArgumentException("bad recursion");
        }
        this.primary = mutableIntSetFactory;
    }

    public void setSecondaryFactory(MutableIntSetFactory mutableIntSetFactory) {
        if (mutableIntSetFactory == null) {
            throw new IllegalArgumentException("null x");
        }
        if (mutableIntSetFactory == this) {
            throw new IllegalArgumentException("bad recursion");
        }
        this.secondary = mutableIntSetFactory;
    }
}

