/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.intset.BitVectorIntSet;
import java.util.Map;
import java.util.WeakHashMap;

public class BitVectorRepository {
    private static final boolean STATS = false;
    private static final int STATS_WINDOW = 100;
    private static int queries = 0;
    private static int hits = 0;
    private static final int SUBSET_DELTA = 5;
    private static final Map<Object, WeakHashMap<BitVectorIntSet, Object>> buckets = HashMapFactory.make();

    public static synchronized BitVectorIntSet findOrCreateSharedSubset(BitVectorIntSet bitVectorIntSet) {
        WeakHashMap<BitVectorIntSet, Object> weakHashMap;
        int n;
        if (bitVectorIntSet == null) {
            throw new IllegalArgumentException("value is null");
        }
        int n2 = n = bitVectorIntSet.size();
        while (n2 > n - 5) {
            weakHashMap = buckets.get(n2);
            if (weakHashMap != null) {
                for (BitVectorIntSet bitVectorIntSet2 : weakHashMap.keySet()) {
                    if (!bitVectorIntSet2.isSubset(bitVectorIntSet)) continue;
                    return bitVectorIntSet2;
                }
            }
            --n2;
        }
        WeakHashMap<Object, Object> weakHashMap2 = MapUtil.findOrCreateWeakHashMap(buckets, new Integer(n));
        weakHashMap = new BitVectorIntSet(bitVectorIntSet);
        weakHashMap2.put(weakHashMap, null);
        return weakHashMap;
    }

    private static void reportStats() {
        double d = 100.0 * (double)hits / (double)queries;
        System.err.println("BitVectorRepository: queries " + queries + " hits " + d);
        System.err.println("                     entries " + BitVectorRepository.countEntries());
    }

    private static int countEntries() {
        int n = 0;
        for (WeakHashMap<BitVectorIntSet, Object> weakHashMap : buckets.values()) {
            n += weakHashMap.size();
        }
        return n;
    }
}

