/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSetFactory;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitVectorIntSetFactory
implements MutableIntSetFactory<BitVectorIntSet> {
    @Override
    public BitVectorIntSet make(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("set is null");
        }
        if (nArray.length == 0) {
            return new BitVectorIntSet();
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int n = 0;
        while (n < nArray.length) {
            treeSet.add(new Integer(nArray[n]));
            ++n;
        }
        BitVectorIntSet bitVectorIntSet = new BitVectorIntSet();
        for (Integer n2 : treeSet) {
            bitVectorIntSet.add(n2);
        }
        return bitVectorIntSet;
    }

    @Override
    public BitVectorIntSet parse(String string) throws NumberFormatException {
        int[] nArray = SparseIntSet.parseIntArray(string);
        BitVectorIntSet bitVectorIntSet = new BitVectorIntSet();
        int n = 0;
        while (n < nArray.length) {
            bitVectorIntSet.add(nArray[n]);
            ++n;
        }
        return bitVectorIntSet;
    }

    @Override
    public BitVectorIntSet makeCopy(IntSet intSet) throws IllegalArgumentException {
        if (intSet == null) {
            throw new IllegalArgumentException("x == null");
        }
        return new BitVectorIntSet(intSet);
    }

    @Override
    public BitVectorIntSet make() {
        return new BitVectorIntSet();
    }
}

