/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.Bits;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BitVectorBase<T extends BitVectorBase>
implements Cloneable,
Serializable {
    protected static final boolean DEBUG = false;
    protected static final int LOG_BITS_PER_UNIT = 5;
    protected static final int BITS_PER_UNIT = 32;
    protected static final int MASK = -1;
    protected static final int LOW_MASK = 31;
    protected int[] bits;
    private static final int[][] masks = new int[][]{{-65536}, {-16777216, 65280}, {-268435456, 0xF00000, 61440, 240}, {-1073741824, 0xC000000, 0xC00000, 786432, 49152, 3072, 192, 12}, {Integer.MIN_VALUE, 0x20000000, 0x8000000, 0x2000000, 0x800000, 0x200000, 524288, 131072, 32768, 8192, 2048, 512, 128, 32, 8, 2}};

    public abstract void set(int var1);

    public abstract void clear(int var1);

    public abstract boolean get(int var1);

    public abstract int length();

    public abstract void and(T var1);

    public abstract void andNot(T var1);

    public abstract void or(T var1);

    public abstract void xor(T var1);

    public abstract boolean sameBits(T var1);

    public abstract boolean isSubset(T var1);

    public abstract boolean intersectionEmpty(T var1);

    public static int subscript(int n) {
        return n >> 5;
    }

    public final void clearAll() {
        int n = 0;
        while (n < this.bits.length) {
            this.bits[n] = 0;
            ++n;
        }
    }

    public int hashCode() {
        int n = 1234;
        int n2 = this.bits.length - 1;
        while (n2 >= 0) {
            n ^= this.bits[n2] * (n2 + 1);
            --n2;
        }
        return n;
    }

    public final int populationCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.bits.length) {
            n += Bits.populationCount(this.bits[n2]);
            ++n2;
        }
        return n;
    }

    public boolean isZero() {
        int n = this.bits.length;
        int n2 = n - 1;
        while (n2 >= 0) {
            if (this.bits[n2] != 0) {
                return false;
            }
            --n2;
        }
        return true;
    }

    public Object clone() {
        BitVectorBase bitVectorBase = null;
        try {
            bitVectorBase = (BitVectorBase)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        bitVectorBase.bits = new int[this.bits.length];
        System.arraycopy(this.bits, 0, bitVectorBase.bits, 0, bitVectorBase.bits.length);
        return bitVectorBase;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        stringBuffer.append('{');
        int n = this.length();
        int n2 = 0;
        while (n2 < n) {
            if (this.get(n2)) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                stringBuffer.append(n2);
            }
            ++n2;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public boolean contains(int n) {
        return this.get(n);
    }

    public int max() {
        int n = this.bits.length - 1;
        while (n >= 0 && this.bits[n] == 0) {
            --n;
        }
        if (n < 0) {
            return -1;
        }
        int n2 = n * 32;
        int n3 = this.bits[n];
        int n4 = 0;
        int n5 = 0;
        while (n5 < masks.length) {
            if ((n3 & masks[n5][n4]) != 0) {
                n4 <<= 1;
            } else {
                n4 <<= 1;
                ++n4;
            }
            ++n5;
        }
        return n2 + (31 - n4);
    }

    public int nextSetBit(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("illegal start: " + n);
        }
        int n2 = BitVectorBase.subscript(n);
        int n3 = 1 << (n & 0x1F);
        while (n2 < this.bits.length) {
            if (this.bits[n2] != 0) {
                do {
                    if ((this.bits[n2] & n3) != 0) {
                        return n;
                    }
                    ++n;
                } while ((n3 <<= 1) != 0);
            } else {
                n += 32 - (n & 0x1F);
            }
            ++n2;
            n3 = 1;
        }
        return -1;
    }

    public void copyBits(BitVectorBase bitVectorBase) {
        if (bitVectorBase == null) {
            throw new IllegalArgumentException("set is null");
        }
        int n = bitVectorBase.bits.length;
        this.bits = new int[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            this.bits[n2] = bitVectorBase.bits[n2];
            --n2;
        }
    }
}

