/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.heapTrace;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeapTracer {
    private static final boolean DEBUG = false;
    private static final String[] rootClasses = HeapTracer.generateRootClassesFromWorkspace();
    private final Collection<?> rootInstances;
    private final Stack<Object> scalarWorkList = new Stack();
    private final Stack<Object> arrayWorkList = new Stack();
    private static final int BYTES_IN_HEADER = 12;
    private final boolean traceStatics;
    private final HashMap<Class<?>, Integer> sizeMap = HashMapFactory.make();
    private static final Object DUMMY = new Object();
    private static final HashSet<Class<?>> internalClasses = HashSetFactory.make();
    private final Object OK = new Object();
    private final Object BAD = new Object();
    private final HashMap<Package, Object> packageStatus = HashMapFactory.make();
    private final HashMap<Class, Field[]> allReferenceFieldsCache = HashMapFactory.make();

    static {
        try {
            internalClasses.add(Class.forName("java.lang.String"));
            internalClasses.add(Class.forName("java.util.HashMap$Entry"));
            internalClasses.add(Class.forName("java.util.HashMap"));
            internalClasses.add(Class.forName("java.util.HashSet"));
            internalClasses.add(Class.forName("java.util.Vector"));
            internalClasses.add(Class.forName("com.ibm.wala.util.collections.SmallMap"));
            internalClasses.add(Class.forName("com.ibm.wala.util.collections.SimpleVector"));
            internalClasses.add(Class.forName("com.ibm.wala.util.intset.SimpleIntVector"));
            internalClasses.add(Class.forName("com.ibm.wala.util.intset.BasicNaturalRelation"));
            internalClasses.add(Class.forName("com.ibm.wala.util.intset.SparseIntSet"));
            internalClasses.add(Class.forName("com.ibm.wala.util.collections.SparseVector"));
            internalClasses.add(Class.forName("com.ibm.wala.util.intset.MutableSharedBitVectorIntSet"));
            internalClasses.add(Class.forName("com.ibm.wala.util.intset.MutableSparseIntSet"));
            internalClasses.add(Class.forName("com.ibm.wala.util.collections.TwoLevelVector"));
            internalClasses.add(Class.forName("com.ibm.wala.util.graph.impl.DelegatingNumberedNodeManager"));
            internalClasses.add(Class.forName("com.ibm.wala.util.graph.impl.SparseNumberedEdgeManager"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }

    HeapTracer(boolean bl) {
        this.rootInstances = Collections.emptySet();
        this.traceStatics = bl;
    }

    public HeapTracer(Collection<?> collection, boolean bl) {
        this.rootInstances = collection;
        this.traceStatics = bl;
    }

    public static void main(String[] stringArray) {
        try {
            Result result = new HeapTracer(true).perform();
            System.err.println(result.toString());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static String[] generateRootClassesFromWorkspace() {
        Object object;
        String string = System.getProperty("java.class.path");
        Object[] objectArray = HeapTracer.extractBinDirectories(string);
        HashSet hashSet = HashSetFactory.make();
        int n = 0;
        while (n < objectArray.length) {
            object = (String)objectArray[n];
            File file = new File((String)object);
            hashSet.addAll(HeapTracer.findClassNames((String)object, file));
            ++n;
        }
        String[] stringArray = new String[hashSet.size()];
        object = hashSet.iterator();
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = (String)object.next();
            ++n2;
        }
        return stringArray;
    }

    private static Collection<String> findClassNames(String string, File file) {
        HashSet<String> hashSet = HashSetFactory.make();
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                hashSet.addAll(HeapTracer.findClassNames(string, fileArray[n]));
                ++n;
            }
        } else if (file.getName().indexOf(".class") > 0) {
            String string2 = file.getAbsolutePath();
            string2 = string2.substring(string.length() + 1);
            string2 = string2.substring(0, string2.length() - 6);
            string2 = string2.replace('\\', '.');
            return Collections.singleton(string2);
        }
        return hashSet;
    }

    private static Object[] extractBinDirectories(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        HashSet hashSet = HashSetFactory.make();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf("bin") <= 0) continue;
            hashSet.add(string2);
        }
        return hashSet.toArray();
    }

    public Result perform() throws ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        Field[] fieldArray;
        Result result = new Result();
        IdentityHashMap<Object, Object> identityHashMap = new IdentityHashMap<Object, Object>();
        if (this.traceStatics) {
            int n = 0;
            while (n < rootClasses.length) {
                Object object = Class.forName(rootClasses[n]);
                fieldArray = ((Class)object).getDeclaredFields();
                int n2 = 0;
                while (n2 < fieldArray.length) {
                    if (HeapTracer.isStatic(fieldArray[n2])) {
                        this.traverse(fieldArray[n2], result, identityHashMap);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        for (Object object : this.rootInstances) {
            fieldArray = object.getClass();
            HashSet<Field> hashSet = HeapTracer.getAllInstanceFields((Class)fieldArray);
            for (Field field : hashSet) {
                this.traverse(field, object, result, identityHashMap);
            }
        }
        return result;
    }

    private static int computeSizeOf(Object object) {
        int n = 12;
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            int n2 = Array.getLength(object);
            n += n2 * HeapTracer.sizeOfSlot(clazz2);
        } else {
            if (clazz.isPrimitive()) {
                throw new Error();
            }
            HashSet<Field> hashSet = HeapTracer.getAllInstanceFields(clazz);
            for (Field field : hashSet) {
                n += HeapTracer.sizeOfSlot(field.getType());
            }
        }
        return n;
    }

    private int sizeOf(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            return HeapTracer.computeSizeOf(object);
        }
        Integer n = this.sizeMap.get(clazz);
        if (n == null) {
            n = new Integer(HeapTracer.computeSizeOf(object));
            this.sizeMap.put(clazz, n);
        }
        return n;
    }

    private static int sizeOfSlot(Class clazz) {
        if (!clazz.isPrimitive()) {
            return 4;
        }
        if (clazz.equals(Boolean.TYPE) || clazz.equals(Character.TYPE) || clazz.equals(Byte.TYPE)) {
            return 1;
        }
        if (clazz.equals(Short.TYPE)) {
            return 2;
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Float.TYPE)) {
            return 4;
        }
        if (clazz.equals(Long.TYPE) || clazz.equals(Double.TYPE)) {
            return 8;
        }
        throw new Error();
    }

    private void traverse(Field field, Result result, IdentityHashMap<Object, Object> identityHashMap) throws IllegalArgumentException, IllegalAccessException {
        field.setAccessible(true);
        Pair<Field, Object> pair = field.get(null);
        if (pair != null && identityHashMap.get(pair) == null) {
            identityHashMap.put(pair, DUMMY);
            Class<?> clazz = pair.getClass();
            if (clazz.isArray()) {
                result.registerReachedFrom(field, field, pair);
                this.arrayWorkList.push(Pair.make(field, pair));
            } else {
                result.registerReachedFrom(field, field, pair);
                if (internalClasses.contains(clazz)) {
                    pair = Pair.make(field, pair);
                }
                this.scalarWorkList.push(pair);
            }
        }
        this.drainWorkLists(field, result, identityHashMap);
    }

    private void traverse(Field field, Object object, Result result, IdentityHashMap<Object, Object> identityHashMap) throws IllegalArgumentException, IllegalAccessException {
        this.traverseFieldOfScalar(field, field, object, null, identityHashMap, result);
        this.drainWorkLists(field, result, identityHashMap);
    }

    private void drainWorkLists(Field field, Result result, IdentityHashMap<Object, Object> identityHashMap) throws IllegalAccessException {
        while (!this.scalarWorkList.isEmpty() || !this.arrayWorkList.isEmpty()) {
            Object object;
            if (!this.scalarWorkList.isEmpty()) {
                object = this.scalarWorkList.pop();
                if (object instanceof Pair) {
                    Pair pair = (Pair)object;
                    this.traverseScalar(field, pair.snd, pair.fst, result, identityHashMap);
                } else {
                    this.traverseScalar(field, object, null, result, identityHashMap);
                }
            }
            if (this.arrayWorkList.isEmpty()) continue;
            object = (Pair)this.arrayWorkList.pop();
            this.traverseArray(field, ((Pair)object).snd, ((Pair)object).fst, result, identityHashMap);
        }
    }

    private void traverseArray(Field field, Object object, Object object2, Result result, IdentityHashMap<Object, Object> identityHashMap) throws IllegalArgumentException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz.isPrimitive()) {
            return;
        }
        assert (object2 != null);
        int n = Array.getLength(object);
        int n2 = 0;
        while (n2 < n) {
            Pair<Object, Object> pair = Array.get(object, n2);
            if (pair != null && identityHashMap.get(pair) == null) {
                identityHashMap.put(pair, DUMMY);
                Class<?> clazz2 = pair.getClass();
                if (clazz2.isArray()) {
                    result.registerReachedFrom(field, object2, pair);
                    pair = Pair.make(object2, pair);
                    this.arrayWorkList.push(pair);
                } else {
                    result.registerReachedFrom(field, object2, pair);
                    pair = Pair.make(object2, pair);
                    this.scalarWorkList.push(pair);
                }
            }
            ++n2;
        }
    }

    private void traverseScalar(Field field, Object object, Object object2, Result result, IdentityHashMap<Object, Object> identityHashMap) throws IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        Field[] fieldArray = this.getAllReferenceInstanceFields(clazz);
        int n = 0;
        while (n < fieldArray.length) {
            this.traverseFieldOfScalar(field, fieldArray[n], object, object2, identityHashMap, result);
            ++n;
        }
    }

    private final boolean isInBadPackage(Class clazz) {
        Package package_ = clazz.getPackage();
        if (package_ == null) {
            return false;
        }
        Object object = this.packageStatus.get(package_);
        if (object == this.OK) {
            return false;
        }
        if (object == this.BAD) {
            return true;
        }
        if (package_.getName() != null && package_.getName().indexOf("sun.reflect") != -1) {
            this.packageStatus.put(package_, this.BAD);
            return true;
        }
        this.packageStatus.put(package_, this.OK);
        return false;
    }

    private void traverseFieldOfScalar(Field field, Field field2, Object object, Object object2, IdentityHashMap<Object, Object> identityHashMap, Result result) throws IllegalArgumentException, IllegalAccessException {
        if (this.isInBadPackage(field2.getType())) {
            return;
        }
        if (object2 == null) {
            object2 = field2;
        }
        field2.setAccessible(true);
        Pair<Object, Object> pair = field2.get(object);
        if (pair != null && identityHashMap.get(pair) == null) {
            try {
                identityHashMap.put(pair, DUMMY);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            Class<?> clazz = pair.getClass();
            if (clazz.isArray()) {
                result.registerReachedFrom(field, object2, pair);
                pair = Pair.make(object2, pair);
                this.arrayWorkList.push(pair);
            } else {
                result.registerReachedFrom(field, object2, pair);
                if (internalClasses.contains(clazz)) {
                    pair = Pair.make(object2, pair);
                }
                this.scalarWorkList.push(pair);
            }
        }
    }

    private static HashSet<Field> getAllInstanceFields(Class clazz) {
        HashSet<Field> hashSet = HashSetFactory.make();
        Class clazz2 = clazz;
        while (clazz2 != null) {
            Field[] fieldArray = clazz2.getDeclaredFields();
            int n = 0;
            while (n < fieldArray.length) {
                if (!HeapTracer.isStatic(fieldArray[n])) {
                    hashSet.add(fieldArray[n]);
                }
                ++n;
            }
            clazz2 = clazz2.getSuperclass();
        }
        return hashSet;
    }

    private Field[] getAllReferenceInstanceFields(Class clazz) {
        Field[] fieldArray;
        if (this.allReferenceFieldsCache.containsKey(clazz)) {
            return this.allReferenceFieldsCache.get(clazz);
        }
        HashSet hashSet = HashSetFactory.make();
        Class clazz2 = clazz;
        while (clazz2 != null) {
            fieldArray = clazz2.getDeclaredFields();
            int n = 0;
            while (n < fieldArray.length) {
                Class<?> clazz3;
                if (!HeapTracer.isStatic(fieldArray[n]) && !(clazz3 = fieldArray[n].getType()).isPrimitive()) {
                    hashSet.add(fieldArray[n]);
                }
                ++n;
            }
            clazz2 = clazz2.getSuperclass();
        }
        fieldArray = new Field[hashSet.size()];
        Object[] objectArray = hashSet.toArray();
        int n = 0;
        while (n < fieldArray.length) {
            fieldArray[n] = (Field)objectArray[n];
            ++n;
        }
        this.allReferenceFieldsCache.put(clazz, fieldArray);
        return fieldArray;
    }

    private static boolean isStatic(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    public static void analyzeLeaks() {
        HeapTracer.analyzeLeaks(true);
    }

    public static void analyzeLeaks(boolean bl) {
        try {
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            long l = Runtime.getRuntime().totalMemory();
            long l2 = Runtime.getRuntime().freeMemory();
            System.err.println("Total Memory:     " + l);
            System.err.println("Occupied Memory:  " + (l - l2));
            Result result = new HeapTracer(bl).perform();
            System.err.println("HeapTracer Analysis:");
            System.err.println(result.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    public static Result traceHeap(Collection collection, boolean bl) {
        try {
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            long l = Runtime.getRuntime().totalMemory();
            long l2 = Runtime.getRuntime().freeMemory();
            System.err.println("Total Memory:     " + l);
            System.err.println("Occupied Memory:  " + (l - l2));
            Result result = new HeapTracer(collection, bl).perform();
            System.err.println("HeapTracer Analysis:");
            System.err.println(result.toString());
            return result;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return null;
    }

    class Demographics {
        private final HashMap<Object, Integer> instanceCount = HashMapFactory.make();
        private final HashMap<Object, Integer> sizeCount = HashMapFactory.make();
        private int totalInstances = 0;
        private int totalSize = 0;

        Demographics() {
        }

        public void registerObject(Object object, Object object2) {
            Integer n = this.instanceCount.get(object);
            int n2 = n == null ? 1 : n + 1;
            this.instanceCount.put(object, new Integer(n2));
            ++this.totalInstances;
            n = this.sizeCount.get(object);
            int n3 = HeapTracer.this.sizeOf(object2);
            int n4 = n == null ? n3 : n + n3;
            this.sizeCount.put(object, new Integer(n4));
            this.totalSize += n3;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Totals: " + this.totalInstances + " " + this.totalSize + "\n");
            TreeSet<Object> treeSet = new TreeSet<Object>(new SizeComparator());
            treeSet.addAll(this.instanceCount.keySet());
            for (Object object : treeSet) {
                Integer n = this.instanceCount.get(object);
                Integer n2 = this.sizeCount.get(object);
                stringBuffer.append("  ").append(n).append("   ").append(n2).append("   ");
                stringBuffer.append(n2 / n).append("   ");
                stringBuffer.append(object);
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }

        public int getTotalSize() {
            return this.totalSize;
        }

        public int getTotalInstances() {
            return this.totalInstances;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SizeComparator
        implements Comparator<Object> {
            private SizeComparator() {
            }

            @Override
            public int compare(Object object, Object object2) {
                Integer n = (Integer)Demographics.this.sizeCount.get(object);
                Integer n2 = (Integer)Demographics.this.sizeCount.get(object2);
                return n2 - n;
            }
        }
    }

    public class Result {
        private final HashMap<Field, Demographics> roots = HashMapFactory.make();

        private Demographics findOrCreateDemographics(Field field) {
            Demographics demographics = this.roots.get(field);
            if (demographics == null) {
                demographics = new Demographics();
                this.roots.put(field, demographics);
            }
            return demographics;
        }

        public void registerReachedFrom(Field field, Object object, Object object2) {
            Demographics demographics = this.findOrCreateDemographics(field);
            demographics.registerObject(Pair.make(object, object2.getClass()), object2);
        }

        public int getTotalSize() {
            int n = 0;
            for (Demographics demographics : this.roots.values()) {
                n += demographics.getTotalSize();
            }
            return n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Assuming 12 header bytes per object\n");
            int n = 0;
            int n2 = 0;
            for (Demographics object2 : this.roots.values()) {
                n += object2.getTotalInstances();
                n2 += object2.getTotalSize();
            }
            stringBuffer.append("Total instances: " + n + "\n");
            stringBuffer.append("Total size(bytes): " + n2 + "\n");
            TreeSet<Field> treeSet = new TreeSet<Field>(new SizeComparator());
            treeSet.addAll(this.roots.keySet());
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Demographics demographics = this.roots.get(e);
                if (demographics.getTotalSize() <= 10000) continue;
                stringBuffer.append(" root: ").append(e).append("\n");
                stringBuffer.append(demographics);
            }
            return stringBuffer.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class SizeComparator
        implements Comparator<Field> {
            private SizeComparator() {
            }

            @Override
            public int compare(Field field, Field field2) {
                Demographics demographics = (Demographics)Result.this.roots.get(field);
                Demographics demographics2 = (Demographics)Result.this.roots.get(field2);
                return demographics2.getTotalSize() - demographics.getTotalSize();
            }
        }
    }
}

