/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.traverse.GraphDFSDiscoverTimeIterator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberedDFSDiscoverTimeIterator<T>
extends GraphDFSDiscoverTimeIterator<T>
implements Iterator<T> {
    private static final long serialVersionUID = -3919708273323217304L;
    private final Iterator<? extends T>[] pendingChildren;
    protected final NumberedGraph<T> G;

    public NumberedDFSDiscoverTimeIterator(NumberedGraph<T> numberedGraph, T t) {
        if (numberedGraph == null) {
            throw new IllegalArgumentException("G is null");
        }
        this.G = numberedGraph;
        this.pendingChildren = new Iterator[numberedGraph.getMaxNumber() + 1];
        this.init(numberedGraph, new NonNullSingletonIterator<T>(t));
    }

    public NumberedDFSDiscoverTimeIterator(NumberedGraph<T> numberedGraph, Iterator<? extends T> iterator) throws IllegalArgumentException {
        if (numberedGraph == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (iterator == null) {
            throw new IllegalArgumentException("nodes == null");
        }
        this.G = numberedGraph;
        this.pendingChildren = new Iterator[numberedGraph.getMaxNumber() + 1];
        this.init(numberedGraph, iterator);
    }

    public NumberedDFSDiscoverTimeIterator(NumberedGraph<T> numberedGraph) throws NullPointerException {
        this(numberedGraph, numberedGraph == null ? null : numberedGraph.iterator());
    }

    @Override
    protected Iterator<? extends T> getPendingChildren(T t) {
        return this.pendingChildren[this.G.getNumber(t)];
    }

    @Override
    protected void setPendingChildren(T t, Iterator<? extends T> iterator) {
        this.pendingChildren[this.G.getNumber(t)] = iterator;
    }
}

