/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.impl;

import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.EdgeManager;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NodeManager;
import com.ibm.wala.util.graph.impl.SlowNumberedNodeManager;
import com.ibm.wala.util.graph.impl.SparseNumberedEdgeManager;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlowSparseNumberedGraph<T>
extends AbstractNumberedGraph<T> {
    private final SlowNumberedNodeManager<T> nodeManager = new SlowNumberedNodeManager();
    private final SparseNumberedEdgeManager<T> edgeManager;

    protected SlowSparseNumberedGraph() {
        this(0);
    }

    public SlowSparseNumberedGraph(int n) {
        this.edgeManager = new SparseNumberedEdgeManager<T>(this.nodeManager, n, 1);
    }

    @Override
    public NodeManager<T> getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public EdgeManager<T> getEdgeManager() {
        return this.edgeManager;
    }

    public static <T> SlowSparseNumberedGraph<T> duplicate(Graph<T> graph) {
        SlowSparseNumberedGraph<T> slowSparseNumberedGraph = SlowSparseNumberedGraph.make();
        SlowSparseNumberedGraph.copyInto(graph, slowSparseNumberedGraph);
        return slowSparseNumberedGraph;
    }

    public static <T> void copyInto(Graph<T> graph, Graph<T> graph2) {
        if (graph == null) {
            throw new IllegalArgumentException("g is null");
        }
        Iterator iterator = graph.iterator();
        while (iterator.hasNext()) {
            graph2.addNode(iterator.next());
        }
        for (Object t : graph) {
            Iterator iterator2 = graph.getSuccNodes(t);
            while (iterator2.hasNext()) {
                graph2.addEdge(t, iterator2.next());
            }
        }
    }

    public static <T> SlowSparseNumberedGraph<T> make() {
        return new SlowSparseNumberedGraph<T>();
    }
}

