/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph;

import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.IteratorUtil;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.functions.Function;
import com.ibm.wala.util.graph.AbstractGraph;
import com.ibm.wala.util.graph.EdgeManager;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NodeManager;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.graph.traverse.DFS;
import com.ibm.wala.util.warnings.WalaException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphSlicer {
    public static <T> Set<T> slice(Graph<T> graph, Filter<T> filter) throws WalaException {
        if (graph == null) {
            throw new IllegalArgumentException("g is null");
        }
        HashSet hashSet = HashSetFactory.make();
        for (Object t : graph) {
            if (!filter.accepts(t)) continue;
            hashSet.add(t);
        }
        Set<T> set = DFS.getReachableNodes(GraphInverter.invert(graph), hashSet);
        return set;
    }

    public static <T> Graph<T> prune(final Graph<T> graph, final Filter<T> filter) {
        if (graph == null) {
            throw new IllegalArgumentException("g is null");
        }
        final NodeManager nodeManager = new NodeManager<T>(){
            int nodeCount = -1;

            @Override
            public Iterator<T> iterator() {
                return new FilterIterator(graph.iterator(), filter);
            }

            @Override
            public int getNumberOfNodes() {
                if (this.nodeCount == -1) {
                    this.nodeCount = IteratorUtil.count(this.iterator());
                }
                return this.nodeCount;
            }

            @Override
            public void addNode(T t) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeNode(T t) {
                Assertions.UNREACHABLE();
            }

            @Override
            public boolean containsNode(T t) {
                return filter.accepts(t) && graph.containsNode(t);
            }
        };
        final EdgeManager edgeManager = new EdgeManager<T>(){

            @Override
            public Iterator<T> getPredNodes(T t) {
                return new FilterIterator(graph.getPredNodes(t), filter);
            }

            @Override
            public int getPredNodeCount(T t) {
                return IteratorUtil.count(this.getPredNodes(t));
            }

            @Override
            public Iterator<T> getSuccNodes(T t) {
                return new FilterIterator(graph.getSuccNodes(t), filter);
            }

            @Override
            public int getSuccNodeCount(T t) {
                return IteratorUtil.count(this.getSuccNodes(t));
            }

            @Override
            public void addEdge(T t, T t2) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeEdge(T t, T t2) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeAllIncidentEdges(T t) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeIncomingEdges(T t) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeOutgoingEdges(T t) {
                Assertions.UNREACHABLE();
            }

            @Override
            public boolean hasEdge(T t, T t2) {
                return graph.hasEdge(t, t2) && filter.accepts(t) && filter.accepts(t2);
            }
        };
        AbstractGraph abstractGraph = new AbstractGraph<T>(){

            @Override
            protected NodeManager<T> getNodeManager() {
                return nodeManager;
            }

            @Override
            protected EdgeManager<T> getEdgeManager() {
                return edgeManager;
            }
        };
        return abstractGraph;
    }

    public static <E> AbstractGraph<E> project(final Graph<E> graph, final Filter<E> filter) {
        final NodeManager nodeManager = new NodeManager<E>(){
            private int count = -1;

            @Override
            public void addNode(E e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsNode(E e) {
                return graph.containsNode(e) && filter.accepts(e);
            }

            @Override
            public int getNumberOfNodes() {
                if (this.count == -1) {
                    this.count = IteratorUtil.count(this.iterator());
                }
                return this.count;
            }

            @Override
            public Iterator<E> iterator() {
                return new FilterIterator(graph.iterator(), filter);
            }

            @Override
            public void removeNode(E e) {
                throw new UnsupportedOperationException();
            }
        };
        final EdgeManager edgeManager = new EdgeManager<E>(){
            private Map<E, Collection<E>> succs = new HashMap();
            private Map<E, Collection<E>> preds = new HashMap();

            private Set<E> getConnected(E e, Function<E, Iterator<? extends E>> function) {
                LinkedHashSet linkedHashSet = new LinkedHashSet();
                HashSet hashSet = new HashSet();
                Set set = Iterator2Collection.toSet(function.apply(e));
                while (!set.isEmpty()) {
                    HashSet hashSet2 = new HashSet();
                    for (Object e2 : set) {
                        if (hashSet.contains(e2)) continue;
                        hashSet.add(e2);
                        if (nodeManager.containsNode(e2)) {
                            linkedHashSet.add(e2);
                            continue;
                        }
                        Iterator iterator = function.apply(e2);
                        while (iterator.hasNext()) {
                            Object e3 = iterator.next();
                            if (hashSet.contains(e3)) continue;
                            hashSet2.add(e3);
                        }
                    }
                    set = hashSet2;
                }
                return linkedHashSet;
            }

            private void setPredNodes(E e) {
                this.preds.put(e, this.getConnected(e, new Function<E, Iterator<? extends E>>(){

                    @Override
                    public Iterator<? extends E> apply(E e) {
                        return graph.getPredNodes(e);
                    }
                }));
            }

            private void setSuccNodes(E e) {
                this.succs.put(e, this.getConnected(e, new Function<E, Iterator<? extends E>>(){

                    @Override
                    public Iterator<? extends E> apply(E e) {
                        return graph.getSuccNodes(e);
                    }
                }));
            }

            @Override
            public int getPredNodeCount(E e) {
                if (!this.preds.containsKey(e)) {
                    this.setPredNodes(e);
                }
                return this.preds.get(e).size();
            }

            @Override
            public Iterator<E> getPredNodes(E e) {
                if (!this.preds.containsKey(e)) {
                    this.setPredNodes(e);
                }
                return this.preds.get(e).iterator();
            }

            @Override
            public int getSuccNodeCount(E e) {
                if (!this.succs.containsKey(e)) {
                    this.setSuccNodes(e);
                }
                return this.succs.get(e).size();
            }

            @Override
            public Iterator<E> getSuccNodes(E e) {
                if (!this.succs.containsKey(e)) {
                    this.setSuccNodes(e);
                }
                return this.succs.get(e).iterator();
            }

            @Override
            public boolean hasEdge(E e, E e2) {
                if (!this.preds.containsKey(e2)) {
                    this.setPredNodes(e2);
                }
                return this.preds.get(e2).contains(e);
            }

            @Override
            public void addEdge(E e, E e2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeAllIncidentEdges(E e) throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeEdge(E e, E e2) throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeIncomingEdges(E e) throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeOutgoingEdges(E e) throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }
        };
        return new AbstractGraph<E>(){

            @Override
            protected EdgeManager<E> getEdgeManager() {
                return edgeManager;
            }

            @Override
            protected NodeManager<E> getNodeManager() {
                return nodeManager;
            }
        };
    }
}

