/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph;

import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.traverse.BFSIterator;
import com.ibm.wala.util.graph.traverse.DFS;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphIntegrity {
    static final int DEBUG_LEVEL = 0;

    public static <T> void check(Graph<T> graph) throws UnsoundGraphException {
        if (graph == null) {
            throw new IllegalArgumentException("G is null");
        }
        GraphIntegrity.checkNodeCount(graph);
        GraphIntegrity.checkEdges(graph);
        GraphIntegrity.checkEdgeCounts(graph);
    }

    private static <T> void checkEdgeCounts(Graph<T> graph) throws UnsoundGraphException {
        for (Object t : graph) {
            int n = graph.getSuccNodeCount(t);
            int n2 = 0;
            Iterator iterator = graph.getSuccNodes(t);
            while (iterator.hasNext()) {
                iterator.next();
                ++n2;
            }
            if (n != n2) {
                throw new UnsoundGraphException("getSuccNodeCount " + n + " is wrong for node " + t);
            }
            int n3 = graph.getPredNodeCount(t);
            int n4 = 0;
            Iterator iterator2 = graph.getPredNodes(t);
            while (iterator2.hasNext()) {
                iterator2.next();
                ++n4;
            }
            if (n3 == n4) continue;
            throw new UnsoundGraphException("getPredNodeCount " + n + " is wrong for node " + t);
        }
    }

    private static <T> void checkEdges(Graph<T> graph) throws UnsoundGraphException {
        for (Object t : graph) {
            Object t2;
            Iterator iterator;
            Object t3;
            if (!graph.containsNode(t)) {
                throw new UnsoundGraphException(t + " is not contained in the the graph " + graph.containsNode(t));
            }
            Iterator iterator2 = graph.getPredNodes(t);
            block1: while (iterator2.hasNext()) {
                t3 = iterator2.next();
                if (!graph.containsNode(t3)) {
                    throw new UnsoundGraphException(t3 + " is a predecessor of " + t + " but is not contained in the graph");
                }
                iterator = graph.getSuccNodes(t3);
                while (iterator.hasNext()) {
                    t2 = iterator.next();
                    if (t2.equals(t)) continue block1;
                }
                graph.getPredNodes(t);
                graph.getSuccNodes(t3);
                throw new UnsoundGraphException(t3 + " is a predecessor of " + t + " but inverse doesn't hold");
            }
            iterator2 = graph.getSuccNodes(t);
            block3: while (iterator2.hasNext()) {
                t3 = iterator2.next();
                if (!graph.containsNode(t3)) {
                    throw new UnsoundGraphException(t3 + " is a successor of " + t + " but is not contained in the graph");
                }
                iterator = graph.getPredNodes(t3);
                while (iterator.hasNext()) {
                    t2 = iterator.next();
                    if (t2.equals(t)) continue block3;
                }
                throw new UnsoundGraphException(t3 + " is a successor of " + t + " but inverse doesn't hold");
            }
        }
    }

    private static <T> void checkNodeCount(Graph<T> graph) throws UnsoundGraphException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        try {
            n = graph.getNumberOfNodes();
            n2 = 0;
            for (Object t : graph) {
                ++n2;
            }
            n3 = 0;
            Stack stack = new BFSIterator<T>(graph);
            while (stack.hasNext()) {
                stack.next();
                ++n3;
            }
            n4 = 0;
            stack = DFS.iterateDiscoverTime(graph);
            while (stack.hasNext()) {
                stack.next();
                ++n4;
            }
            n5 = 0;
            stack = DFS.iterateFinishTime(graph);
            while (stack.hasNext()) {
                stack.next();
                ++n5;
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw new UnsoundGraphException(runtimeException.toString());
        }
        if (n != n2) {
            throw new UnsoundGraphException("n1: " + n + " n2: " + n2);
        }
        if (n != n3) {
            throw GraphIntegrity.setDiffException("n1: " + n + " n3: " + n3, graph.iterator(), new BFSIterator<T>(graph));
        }
        if (n != n4) {
            throw new UnsoundGraphException("n1: " + n + " n4: " + n3);
        }
        if (n != n5) {
            throw new UnsoundGraphException("n1: " + n + " n5: " + n3);
        }
    }

    private static <T> UnsoundGraphException setDiffException(String string, Iterator<? extends T> iterator, Iterator<T> iterator2) {
        HashSet hashSet;
        HashSet hashSet2 = HashSetFactory.make();
        while (iterator.hasNext()) {
            hashSet = iterator.next();
            boolean bl = hashSet2.add(hashSet);
            if (bl) continue;
            return new UnsoundGraphException("set1 already contained " + hashSet);
        }
        hashSet = HashSetFactory.make();
        while (iterator2.hasNext()) {
            T t = iterator2.next();
            boolean bl = hashSet.add(t);
            if (bl) continue;
            return new UnsoundGraphException("set2 already contained " + t);
        }
        GraphIntegrity.printCollection("set 1 ", hashSet2);
        GraphIntegrity.printCollection("set 2 ", hashSet);
        HashSet hashSet3 = (HashSet)hashSet2.clone();
        hashSet2.removeAll(hashSet);
        if (hashSet2.size() > 0) {
            Object t = hashSet2.iterator().next();
            string = String.valueOf(string) + ", first iterator contained " + t;
            return new UnsoundGraphException(string);
        }
        hashSet.removeAll(hashSet3);
        if (hashSet.size() > 0) {
            Object t = hashSet.iterator().next();
            string = String.valueOf(string) + ", 2nd iterator contained " + t;
            return new UnsoundGraphException(string);
        }
        string = String.valueOf(string) + "set2.size = 0";
        return new UnsoundGraphException(string);
    }

    public static void printCollection(String string, Collection collection) {
        if (collection == null) {
            throw new IllegalArgumentException("c is null");
        }
        System.err.println(string);
        if (collection.isEmpty()) {
            System.err.println("none\n");
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                System.err.println(iterator.next().toString());
            }
            System.err.println("\n");
        }
    }

    public static class UnsoundGraphException
    extends Exception {
        private static final long serialVersionUID = 1503478788521696930L;

        public UnsoundGraphException() {
        }

        public UnsoundGraphException(String string) {
            super(string);
        }
    }
}

