/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.config;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.callgraph.impl.SetOfClasses;
import com.ibm.wala.types.TypeReference;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileOfClasses
extends SetOfClasses
implements Serializable {
    private static final long serialVersionUID = -3256390509887654322L;
    private static final boolean DEBUG = false;
    private Pattern pattern = null;
    private String regex = null;
    private boolean needsCompile = false;

    private FileOfClasses(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public static FileOfClasses createFileOfClasses(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("null textFile");
        }
        return new FileOfClasses(file);
    }

    public FileOfClasses(InputStream inputStream) throws IOException {
        String string;
        if (inputStream == null) {
            throw new IllegalArgumentException("null input");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer stringBuffer = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer("(" + string + ")");
                continue;
            }
            stringBuffer.append("|(" + string + ")");
        }
        if (stringBuffer != null) {
            this.regex = stringBuffer.toString();
            this.needsCompile = true;
        }
        bufferedReader.close();
    }

    private void compile() {
        this.pattern = Pattern.compile(this.regex);
        this.needsCompile = false;
    }

    public boolean contains(TypeReference typeReference) {
        if (typeReference == null) {
            throw new IllegalArgumentException("klass is null");
        }
        if (typeReference.isPrimitiveType()) {
            return false;
        }
        String string = typeReference.getName().toString().substring(1);
        return this.contains(string);
    }

    public boolean contains(String string) {
        if (this.needsCompile) {
            this.compile();
        }
        if (this.pattern == null) {
            return false;
        }
        Matcher matcher = this.pattern.matcher(string);
        return matcher.matches();
    }

    public void add(IClass iClass) {
        if (iClass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        this.regex = this.regex == null ? iClass.getReference().getName().toString() : String.valueOf(this.regex) + '|' + iClass.getReference().getName().toString();
        this.needsCompile = true;
    }

    public String toString() {
        return this.regex;
    }
}

