/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.IVector;
import com.ibm.wala.util.collections.SparseVector;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.math.Logs;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwoLevelVector<T>
implements IVector<T> {
    private static final int PAGE_SIZE = 4096;
    private static final int LOG_PAGE_SIZE = Logs.log2(4096);
    private final Vector<SparseVector<T>> data = new Vector(0);
    private int maxPage = -1;

    @Override
    public T get(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid x: " + n);
        }
        int n2 = this.getPageNumber(n);
        if (n2 >= this.data.size()) {
            return null;
        }
        IVector iVector = this.data.get(n2);
        if (iVector == null) {
            return null;
        }
        int n3 = n - this.getFirstIndexOnPage(n2);
        return iVector.get(n3);
    }

    private int getFirstIndexOnPage(int n) {
        return n << LOG_PAGE_SIZE;
    }

    private int getPageNumber(int n) {
        return n >> LOG_PAGE_SIZE;
    }

    @Override
    public void set(int n, T t) {
        if (n < 0) {
            throw new IllegalArgumentException("illegal x: " + n);
        }
        int n2 = this.getPageNumber(n);
        IVector<T> iVector = this.findOrCreatePage(n2);
        int n3 = this.toLocalIndex(n, n2);
        iVector.set(n3, t);
    }

    private int toLocalIndex(int n, int n2) {
        return n - this.getFirstIndexOnPage(n2);
    }

    private IVector<T> findOrCreatePage(int n) {
        if (n >= this.data.size()) {
            SparseVector sparseVector = new SparseVector();
            this.data.setSize(n + 1);
            this.data.add(n, sparseVector);
            this.maxPage = Math.max(n, this.maxPage);
            return sparseVector;
        }
        SparseVector<T> sparseVector = this.data.get(n);
        if (sparseVector == null) {
            sparseVector = new SparseVector();
            this.data.set(n, sparseVector);
            this.maxPage = Math.max(n, this.maxPage);
        }
        return sparseVector;
    }

    @Override
    public void performVerboseAction() {
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            final Iterator<SparseVector<T>> outer;
            Iterator<T> inner;
            {
                for (IVector iVector : TwoLevelVector.this.data) {
                    Iterator iterator;
                    if (iVector == null || !(iterator = iVector.iterator()).hasNext()) continue;
                    this.inner = iterator;
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                return this.inner != null;
            }

            @Override
            public T next() {
                Object t = this.inner.next();
                if (!this.inner.hasNext()) {
                    this.inner = null;
                    while (this.outer.hasNext()) {
                        Iterator iterator;
                        IVector iVector = this.outer.next();
                        if (iVector == null || !(iterator = iVector.iterator()).hasNext()) continue;
                        this.inner = iterator;
                        break;
                    }
                }
                return t;
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    @Override
    public int getMaxIndex() {
        if (this.maxPage == -1) {
            return -1;
        }
        IVector iVector = this.data.get(this.maxPage);
        int n = iVector.getMaxIndex();
        return this.maxPage * 4096 + n;
    }
}

