/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.IVector;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.TunedMutableSparseIntSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseVector<T>
implements IVector<T> {
    private static final int DEF_INITIAL_SIZE = 5;
    private MutableSparseIntSet indices = MutableSparseIntSet.makeEmpty();
    private Object[] data = new Object[5];

    public SparseVector() {
        this.indices = MutableSparseIntSet.makeEmpty();
    }

    public SparseVector(int n, float f) {
        this.indices = new TunedMutableSparseIntSet(n, f);
    }

    @Override
    public T get(int n) {
        int n2 = this.indices.getIndex(n);
        if (n2 == -1) {
            return null;
        }
        return (T)this.data[n2];
    }

    @Override
    public void set(int n, T t) {
        int n2 = this.indices.getIndex(n);
        if (n2 == -1) {
            this.indices.add(n);
            n2 = this.indices.getIndex(n);
            this.ensureCapacity(this.indices.size() + 1);
            if (n2 < this.data.length - 1) {
                System.arraycopy(this.data, n2, this.data, n2 + 1, this.indices.size() - n2);
            }
        }
        this.data[n2] = t;
    }

    private void ensureCapacity(int n) {
        if (this.data.length < n + 1) {
            Object[] objectArray = this.data;
            this.data = new Object[1 + (int)((float)n * this.indices.getExpansionFactor())];
            System.arraycopy(objectArray, 0, this.data, 0, objectArray.length);
        }
    }

    @Override
    public void performVerboseAction() {
        System.err.println(this.getClass() + " stats: ");
        System.err.println("data.length " + this.data.length);
        System.err.println("indices.size() " + this.indices.size());
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < SparseVector.this.indices.size();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return SparseVector.this.data[this.i++];
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    @Override
    public int getMaxIndex() throws IllegalStateException {
        return this.indices.max();
    }

    public int size() {
        return this.indices.size();
    }

    public IntIterator iterateIndices() {
        return this.indices.intIterator();
    }

    public IntIterator safeIterateIndices() {
        return MutableSparseIntSet.make(this.indices).intIterator();
    }

    public void clear() {
        this.data = new Object[5];
        this.indices = MutableSparseIntSet.makeEmpty();
    }

    public void remove(int n) {
        int n2 = this.indices.getIndex(n);
        if (n2 == -1) {
            return;
        }
        System.arraycopy(this.data, n2 + 1, this.data, n2, this.size() - n2 - 1);
        this.indices.remove(n);
    }
}

