/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmallMap<K, V>
implements Map<K, V> {
    private static final boolean DEBUG_USAGE = false;
    private static final int DEBUG_MAX_SIZE = 20;
    private Object[] keysAndValues;

    @Override
    public int size() {
        if (this.keysAndValues == null) {
            return 0;
        }
        return this.keysAndValues.length / 2;
    }

    public K getKey(int n) throws IllegalStateException {
        if (this.keysAndValues == null) {
            throw new IllegalStateException("getKey on empty map");
        }
        try {
            return (K)this.keysAndValues[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid i: " + n);
        }
    }

    public Object getValue(int n) throws IllegalStateException {
        if (this.keysAndValues == null) {
            throw new IllegalStateException("getValue on empty map");
        }
        try {
            return this.keysAndValues[this.size() + n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("illegal i: " + n);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.keysAndValues == null;
    }

    @Override
    public boolean containsKey(Object object) {
        int n = 0;
        while (n < this.size()) {
            if (this.keysAndValues[n].equals(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        if (this.keysAndValues == null) {
            return false;
        }
        int n = this.size();
        while (n < this.keysAndValues.length) {
            Object object2 = this.keysAndValues[n];
            if (object2 == null ? object == null : object2.equals(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public V get(Object object) {
        if (object != null) {
            int n = 0;
            while (n < this.size()) {
                if (this.keysAndValues[n] != null && this.keysAndValues[n].equals(object)) {
                    return (V)this.keysAndValues[this.size() + n];
                }
                ++n;
            }
        }
        return null;
    }

    private void growByOne() {
        Object[] objectArray = this.keysAndValues;
        int n = objectArray == null ? 0 : objectArray.length;
        this.keysAndValues = new Object[n + 2];
        int n2 = 0;
        while (n2 < n / 2) {
            this.keysAndValues[n2] = objectArray[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < n / 2) {
            this.keysAndValues[n2 + 1 + n / 2] = objectArray[n / 2 + n2];
            ++n2;
        }
    }

    @Override
    public V put(Object object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException("null key");
        }
        int n = 0;
        while (n < this.size()) {
            if (this.keysAndValues[n] != null && this.keysAndValues[n].equals(object)) {
                Object object3 = this.keysAndValues[this.size() + n];
                this.keysAndValues[this.size() + n] = object2;
                return (V)object3;
            }
            ++n;
        }
        this.growByOne();
        this.keysAndValues[this.size() - 1] = object;
        this.keysAndValues[this.keysAndValues.length - 1] = object2;
        return null;
    }

    @Override
    public V remove(Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.keysAndValues = null;
    }

    @Override
    public Set<K> keySet() {
        HashSet hashSet = HashSetFactory.make(this.size());
        int n = 0;
        while (n < this.size()) {
            hashSet.add(this.keysAndValues[n]);
            ++n;
        }
        return hashSet;
    }

    @Override
    public Collection<V> values() {
        int n = this.size();
        if (n == 0) {
            return Collections.emptySet();
        }
        HashSet hashSet = HashSetFactory.make(n);
        int n2 = n;
        while (n2 < this.keysAndValues.length) {
            hashSet.add(this.keysAndValues[n2]);
            ++n2;
        }
        return hashSet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() throws UnimplementedError {
        Assertions.UNREACHABLE("must implement entrySet");
        return null;
    }
}

