/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComposedIterator<O, I>
implements Iterator<I> {
    private final Iterator<O> outer;
    private Iterator<? extends I> inner;

    public ComposedIterator(Iterator<O> iterator) {
        this.outer = iterator;
        this.advanceOuter();
    }

    private void advanceOuter() {
        while (this.outer.hasNext()) {
            this.inner = this.makeInner(this.outer.next());
            if (this.inner.hasNext()) break;
        }
        if (!this.inner.hasNext()) {
            this.inner = null;
        }
    }

    public abstract Iterator<? extends I> makeInner(O var1);

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return this.inner != null;
    }

    @Override
    public I next() {
        I i = this.inner.next();
        if (!this.inner.hasNext()) {
            this.advanceOuter();
        }
        return i;
    }
}

