/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.SmallMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BimodalMap<K, V>
implements Map<K, V> {
    private final int cutOff;
    private Map<K, V> backingStore;

    public BimodalMap(int n) {
        this.cutOff = n;
    }

    @Override
    public int size() {
        return this.backingStore == null ? 0 : this.backingStore.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingStore == null ? true : this.backingStore.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.backingStore == null ? false : this.backingStore.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.backingStore == null ? false : this.backingStore.containsValue(object);
    }

    @Override
    public V get(Object object) {
        return this.backingStore == null ? null : (V)this.backingStore.get(object);
    }

    @Override
    public V put(K k, V v) {
        if (this.backingStore == null) {
            this.backingStore = new SmallMap();
            this.backingStore.put(k, v);
            return null;
        }
        if (this.backingStore instanceof SmallMap) {
            V v2 = this.backingStore.put(k, v);
            if (this.backingStore.size() > this.cutOff) {
                this.transferBackingStore();
            }
            return v2;
        }
        return this.backingStore.put(k, v);
    }

    private void transferBackingStore() {
        assert (this.backingStore instanceof SmallMap);
        SmallMap smallMap = (SmallMap)this.backingStore;
        this.backingStore = HashMapFactory.make(2 * smallMap.size());
        for (Object k : smallMap.keySet()) {
            Object v = smallMap.get(k);
            this.backingStore.put(k, v);
        }
    }

    @Override
    public V remove(Object object) {
        return this.backingStore == null ? null : (V)this.backingStore.remove(object);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) throws UnsupportedOperationException {
        if (map == null) {
            throw new IllegalArgumentException("null t");
        }
        if (this.backingStore == null) {
            int n = map.size();
            this.backingStore = n > this.cutOff ? HashMapFactory.make() : new SmallMap();
            this.backingStore.putAll(map);
            return;
        }
        if (!(this.backingStore instanceof SmallMap)) {
            this.backingStore.putAll(map);
            return;
        }
        if (map.size() > this.cutOff) {
            Map<K, V> map2 = this.backingStore;
            this.backingStore = HashMapFactory.make(map);
            this.backingStore.putAll(map2);
            return;
        }
        this.backingStore.putAll(map);
        if (this.backingStore.size() <= this.cutOff) return;
        this.transferBackingStore();
    }

    @Override
    public void clear() {
        this.backingStore = null;
    }

    @Override
    public Set<K> keySet() {
        return this.backingStore == null ? Collections.emptySet() : this.backingStore.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.backingStore == null ? Collections.emptySet() : this.backingStore.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.backingStore == null ? Collections.emptySet() : this.backingStore.entrySet();
    }
}

