/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util;

import org.eclipse.core.runtime.IProgressMonitor;

public class ProgressMaster
implements IProgressMonitor {
    private final IProgressMonitor delegate;
    private volatile boolean timedOut = false;
    private int msPerWorkItem = -1;
    private Timeout currentNanny;

    private ProgressMaster(IProgressMonitor iProgressMonitor) {
        this.delegate = iProgressMonitor;
    }

    public static ProgressMaster make(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            throw new IllegalArgumentException("null monitor");
        }
        return new ProgressMaster(iProgressMonitor);
    }

    public synchronized void beginTask(String string, int n) {
        this.delegate.beginTask(string, n);
        this.startNanny();
    }

    private synchronized void startNanny() {
        this.killNanny();
        if (this.msPerWorkItem >= 1) {
            this.currentNanny = new Timeout(this.msPerWorkItem);
            this.currentNanny.start();
        }
    }

    public synchronized void reset() {
        this.killNanny();
        this.setCanceled(false);
        this.timedOut = false;
    }

    public boolean lastItemTimedOut() {
        return this.timedOut;
    }

    public synchronized void done() {
        this.killNanny();
        this.delegate.done();
    }

    private synchronized void killNanny() {
        if (this.currentNanny != null) {
            this.currentNanny.interrupt();
            try {
                this.currentNanny.join();
            }
            catch (InterruptedException interruptedException) {}
            this.currentNanny = null;
        }
    }

    public void internalWorked(double d) {
        this.delegate.internalWorked(d);
    }

    public boolean isCanceled() {
        return this.delegate.isCanceled() || this.timedOut;
    }

    public void setCanceled(boolean bl) {
        this.killNanny();
    }

    public void setTaskName(String string) {
        this.delegate.setTaskName(string);
    }

    public void subTask(String string) {
        this.delegate.subTask(string);
    }

    public synchronized void worked(int n) {
        this.killNanny();
        this.delegate.worked(n);
        this.startNanny();
    }

    public int getMillisPerWorkItem() {
        return this.msPerWorkItem;
    }

    public void setMillisPerWorkItem(int n) {
        this.msPerWorkItem = n;
    }

    private class Timeout
    extends Thread {
        private final int sleepMillis;

        public void run() {
            try {
                Thread.sleep(this.sleepMillis);
                if (this.isInterrupted()) {
                    return;
                }
                ProgressMaster.this.timedOut = true;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        Timeout(int n) {
            assert (n >= 1);
            this.sleepMillis = n;
        }
    }
}

