/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Predicate<T> {
    public static final Predicate FALSE = new Predicate(){

        public boolean test(Object object) {
            return false;
        }
    };
    public static final Predicate TRUE = FALSE.not();

    public static <T> Predicate<T> truePred() {
        return TRUE;
    }

    public static <T> Predicate<T> falsePred() {
        return FALSE;
    }

    public abstract boolean test(T var1);

    public Predicate<T> not() {
        final Predicate predicate = this;
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return !predicate.test(t);
            }
        };
    }

    public Predicate<T> and(final Predicate<T> predicate) {
        final Predicate predicate2 = this;
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return predicate2.test(t) && predicate.test(t);
            }
        };
    }

    public Predicate<T> or(final Predicate<T> predicate) {
        final Predicate predicate2 = this;
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return predicate2.test(t) || predicate.test(t);
            }
        };
    }

    public static <T> List<T> filter(Iterator<T> iterator, Predicate<T> predicate) throws IllegalArgumentException {
        if (iterator == null) {
            throw new IllegalArgumentException("src == null");
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!predicate.test(t)) continue;
            arrayList.add(t);
        }
        return arrayList;
    }
}

