/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types.generics;

import com.ibm.wala.types.generics.Signature;
import com.ibm.wala.types.generics.TypeSignature;
import java.util.ArrayList;
import java.util.Iterator;

public class TypeArgument
extends Signature {
    private final TypeSignature sig;
    private final WildcardIndicator w;
    private static final TypeArgument WILDCARD = new TypeArgument("*"){

        public boolean isWildcard() {
            return true;
        }

        public String toString() {
            return "*";
        }
    };

    private TypeArgument(String string) {
        super(string);
        this.sig = null;
        this.w = null;
    }

    private TypeArgument(TypeSignature typeSignature, WildcardIndicator wildcardIndicator) {
        super(typeSignature.rawString());
        this.sig = typeSignature;
        this.w = wildcardIndicator;
    }

    public boolean isWildcard() {
        return false;
    }

    public static TypeArgument[] make(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (string.length() == 0 || string.charAt(0) != '<') {
            throw new IllegalArgumentException(string);
        }
        if (string.charAt(string.length() - 1) != '>') {
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = TypeArgument.parseForTypeArguments(string);
        TypeArgument[] typeArgumentArray = new TypeArgument[stringArray.length];
        int n = 0;
        while (n < typeArgumentArray.length) {
            typeArgumentArray[n] = TypeArgument.makeTypeArgument(stringArray[n]);
            ++n;
        }
        return typeArgumentArray;
    }

    private static TypeArgument makeTypeArgument(String string) {
        switch (string.charAt(0)) {
            case '*': {
                return WILDCARD;
            }
            case '+': {
                TypeSignature typeSignature = TypeSignature.make(string.substring(1));
                return new TypeArgument(typeSignature, WildcardIndicator.PLUS);
            }
            case '-': {
                TypeSignature typeSignature = TypeSignature.make(string.substring(1));
                return new TypeArgument(typeSignature, WildcardIndicator.MINUS);
            }
        }
        TypeSignature typeSignature = TypeSignature.make(string);
        return new TypeArgument(typeSignature, null);
    }

    static String[] parseForTypeArguments(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        int n = 1;
        block7: while (true) {
            switch (string.charAt(n++)) {
                case 'L': {
                    int n2 = n - 1;
                    int n3 = 0;
                    while (string.charAt(n++) != ';' || n3 > 0) {
                        if (string.charAt(n - 1) == '<') {
                            ++n3;
                        }
                        if (string.charAt(n - 1) != '>') continue;
                        --n3;
                    }
                    arrayList.add(string.substring(n2, n));
                    continue block7;
                }
                case '[': {
                    int n2 = n - 1;
                    while (string.charAt(n) == '[') {
                        ++n;
                    }
                    if (string.charAt(n++) == 'L') {
                        while (string.charAt(n++) != ';') {
                        }
                        arrayList.add(string.substring(n2, n - n2 - 1));
                        continue block7;
                    }
                    arrayList.add(string.substring(n2, n - n2));
                    continue block7;
                }
                case '+': 
                case '-': 
                case 'T': {
                    int n2 = n - 1;
                    while (string.charAt(n++) != ';') {
                    }
                    arrayList.add(string.substring(n2, n));
                    continue block7;
                }
                case '*': {
                    arrayList.add("*");
                    continue block7;
                }
                case '>': {
                    int n2 = arrayList.size();
                    if (n2 == 0) {
                        return null;
                    }
                    Iterator iterator = arrayList.iterator();
                    String[] stringArray = new String[n2];
                    int n4 = 0;
                    while (n4 < n2) {
                        stringArray[n4] = (String)iterator.next();
                        ++n4;
                    }
                    return stringArray;
                }
            }
            if (!$assertionsDisabled) break;
        }
        throw new AssertionError((Object)("bad type argument list " + string));
    }

    public TypeSignature getFieldTypeSignature() {
        return this.sig;
    }

    public String toString() {
        if (this.w == null) {
            return this.sig.toString();
        }
        if (this.w.equals((Object)WildcardIndicator.PLUS)) {
            return "+" + this.sig.toString();
        }
        return "-" + this.sig.toString();
    }

    /* synthetic */ TypeArgument(String string, TypeArgument typeArgument) {
        this(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum WildcardIndicator {
        PLUS,
        MINUS;

    }
}

