/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types.generics;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.generics.Signature;
import com.ibm.wala.types.generics.TypeSignature;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class FormalTypeParameter
extends Signature {
    private final String id;
    private final TypeSignature classBound;
    private final TypeSignature[] interfaceBounds;

    private FormalTypeParameter(String string) throws IllegalArgumentException {
        super(string);
        this.id = this.parseForId(string);
        this.classBound = this.parseForClassBound(string);
        this.interfaceBounds = this.parseForInterfaceBounds(string);
    }

    private TypeSignature parseForClassBound(String string) {
        int n = string.indexOf(58);
        if (n == string.length() - 1) {
            return null;
        }
        int n2 = string.indexOf(58, n + 1);
        if (n2 == n + 1) {
            return null;
        }
        if (n2 == -1) {
            return TypeSignature.make(string.substring(n + 1));
        }
        return TypeSignature.make(string.substring(n + 1, n2));
    }

    private TypeSignature[] parseForInterfaceBounds(String string) {
        LinkedList<TypeSignature> linkedList = new LinkedList<TypeSignature>();
        int n = string.indexOf(58);
        if (n == string.length() - 1) {
            return null;
        }
        n = string.indexOf(58, n + 1);
        while (n != -1) {
            int n2 = string.indexOf(58, n + 1);
            if (n2 == -1) {
                linkedList.add(TypeSignature.make(string.substring(n + 1)));
            } else {
                linkedList.add(TypeSignature.make(string.substring(n + 1, n2)));
            }
            n = string.indexOf(58, n + 1);
        }
        TypeSignature[] typeSignatureArray = new TypeSignature[linkedList.size()];
        return linkedList.toArray(typeSignatureArray);
    }

    private String parseForId(String string) throws IllegalArgumentException {
        if (string.indexOf(58) == -1) {
            throw new IllegalArgumentException(string);
        }
        return string.substring(0, string.indexOf(58));
    }

    public static FormalTypeParameter make(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("string is null");
        }
        return new FormalTypeParameter(string);
    }

    public TypeSignature getClassBound() {
        return this.classBound;
    }

    public String getIdentifier() {
        return this.id;
    }

    static int formalTypeParameterEnds(String string, int n) {
        int n2 = n;
        while (string.charAt(n2) != ':') {
            ++n2;
        }
        do {
            assert (string.charAt(n2) == ':');
            switch (string.charAt(++n2)) {
                case 'L': {
                    int n3 = 0;
                    while (string.charAt(n2) != ';' || n3 > 0) {
                        if (string.charAt(n2) == '<') {
                            ++n3;
                        }
                        if (string.charAt(n2) == '>') {
                            --n3;
                        }
                        ++n2;
                    }
                    ++n2;
                    break;
                }
                case ':': {
                    break;
                }
                default: {
                    assert (false) : "bad type signature list " + string + " " + (n2 - 1);
                    {
                        break;
                    }
                }
            }
        } while (string.charAt(n2) == ':');
        return n2;
    }

    static String[] parseForFormalTypeParameters(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        int n = 1;
        while (string.charAt(n) != '>') {
            int n2 = FormalTypeParameter.formalTypeParameterEnds(string, n);
            arrayList.add(string.substring(n, n2));
            n = n2;
        }
        Iterator iterator = arrayList.iterator();
        String[] stringArray = new String[arrayList.size()];
        int n3 = 0;
        while (n3 < stringArray.length) {
            stringArray[n3] = (String)iterator.next();
            ++n3;
        }
        return stringArray;
    }

    public TypeSignature[] getInterfaceBounds() {
        return this.interfaceBounds;
    }

    public static FormalTypeParameter[] getTypeParameters(IClass iClass) throws InvalidClassFileException {
        if (iClass instanceof ShrikeClass) {
            ShrikeClass shrikeClass = (ShrikeClass)iClass;
            if (shrikeClass.getClassSignature() == null) {
                return null;
            }
            return shrikeClass.getClassSignature().getFormalTypeParameters();
        }
        return null;
    }

    public static FormalTypeParameter[] getTypeParameters(IMethod iMethod) throws InvalidClassFileException {
        if (iMethod instanceof ShrikeCTMethod) {
            ShrikeCTMethod shrikeCTMethod = (ShrikeCTMethod)iMethod;
            if (shrikeCTMethod.getMethodTypeSignature() == null) {
                return null;
            }
            return shrikeCTMethod.getMethodTypeSignature().getFormalTypeParameters();
        }
        return null;
    }
}

