/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types.generics;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.generics.TypeArgument;
import com.ibm.wala.types.generics.TypeSignature;
import java.util.StringTokenizer;

public class ClassTypeSignature
extends TypeSignature {
    ClassTypeSignature(String string) throws IllegalArgumentException {
        super(string);
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (string.charAt(0) != 'L') {
            throw new IllegalArgumentException(string);
        }
        if (string.charAt(string.length() - 1) != ';') {
            throw new IllegalArgumentException(string);
        }
    }

    public static ClassTypeSignature makeClassTypeSig(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("s is null");
        }
        return new ClassTypeSignature(string);
    }

    public boolean isTypeVariable() {
        return false;
    }

    public boolean isClassTypeSignature() {
        return true;
    }

    public boolean isArrayTypeSignature() {
        return false;
    }

    public TypeName getRawName() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.rawString(), ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            stringBuffer.append(string.replaceAll("<.*>", "").replace(";", ""));
            if (!stringTokenizer.hasMoreElements()) continue;
            stringBuffer.append('$');
        }
        return TypeName.string2TypeName(stringBuffer.toString());
    }

    public TypeArgument[] getTypeArguments() {
        int n = this.rawString().lastIndexOf(46);
        if (this.rawString().indexOf(60, n) == -1) {
            return null;
        }
        int n2 = this.rawString().indexOf(60, n);
        int n3 = this.endOfTypeArguments();
        return TypeArgument.make(this.rawString().substring(n2, n3));
    }

    private int endOfTypeArguments() {
        int n = this.rawString().lastIndexOf(46);
        int n2 = this.rawString().indexOf(60, n) + 1;
        assert (n2 > 0);
        int n3 = 1;
        while (n3 > 0) {
            if (this.rawString().charAt(n2) == '>') {
                --n3;
            }
            if (this.rawString().charAt(n2) == '<') {
                ++n3;
            }
            ++n2;
        }
        return n2;
    }

    public boolean isBaseType() {
        return false;
    }

    public static IClass lookupClass(IClassHierarchy iClassHierarchy, ClassTypeSignature classTypeSignature) {
        if (classTypeSignature == null) {
            throw new IllegalArgumentException("sig is null");
        }
        if (iClassHierarchy == null) {
            throw new IllegalArgumentException("cha is null");
        }
        TypeReference typeReference = TypeReference.findOrCreate(ClassLoaderReference.Application, classTypeSignature.getRawName());
        return iClassHierarchy.lookupClass(typeReference);
    }
}

