/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types.annotations;

import com.ibm.wala.classLoader.FieldImpl;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;

public class Annotations {
    public static final TypeName INTERNAL = TypeName.findOrCreateClassName("com/ibm/wala/annotations", "Internal");
    public static final TypeName NONNULL = TypeName.findOrCreateClassName("com/ibm/wala/annotations", "NonNull");

    public static boolean hasAnnotation(IMethod iMethod, TypeName typeName) {
        if (iMethod instanceof ShrikeCTMethod) {
            Collection<Annotation> collection = null;
            try {
                collection = ((ShrikeCTMethod)iMethod).getRuntimeInvisibleAnnotations();
            }
            catch (InvalidClassFileException invalidClassFileException) {
                invalidClassFileException.printStackTrace();
                Assertions.UNREACHABLE();
            }
            catch (AnnotationsReader.UnimplementedException unimplementedException) {
                unimplementedException.printStackTrace();
                Assertions.UNREACHABLE();
            }
            for (Annotation annotation : collection) {
                if (!annotation.getType().getName().equals(typeName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasAnnotation(IClass iClass, TypeName typeName) {
        if (iClass instanceof ShrikeClass) {
            Collection<Annotation> collection = null;
            try {
                collection = ((ShrikeClass)iClass).getRuntimeInvisibleAnnotations();
            }
            catch (InvalidClassFileException invalidClassFileException) {
                invalidClassFileException.printStackTrace();
                Assertions.UNREACHABLE();
            }
            catch (AnnotationsReader.UnimplementedException unimplementedException) {
                unimplementedException.printStackTrace();
                Assertions.UNREACHABLE();
            }
            for (Annotation annotation : collection) {
                if (!annotation.getType().getName().equals(typeName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasAnnotation(IField iField, TypeName typeName) {
        FieldImpl fieldImpl;
        Collection<Annotation> collection;
        if (iField instanceof FieldImpl && (collection = (fieldImpl = (FieldImpl)iField).getAnnotations()) != null) {
            for (Annotation annotation : collection) {
                if (!annotation.getType().getName().equals(typeName)) continue;
                return true;
            }
        }
        return false;
    }
}

