/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAIndirectionData;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShrikeIndirectionData
implements SSAIndirectionData<ShrikeLocalName> {
    private final Map<ShrikeLocalName, Integer>[] defs;
    private final Map<ShrikeLocalName, Integer>[] uses;

    public ShrikeIndirectionData(int n) {
        this.defs = new HashMap[n];
        this.uses = new HashMap[n];
    }

    @Override
    public int getDef(int n, ShrikeLocalName shrikeLocalName) {
        if (this.defs[n] == null || !this.defs[n].containsKey(shrikeLocalName)) {
            return -1;
        }
        return this.defs[n].get(shrikeLocalName);
    }

    @Override
    public int getUse(int n, ShrikeLocalName shrikeLocalName) {
        if (this.uses[n] == null || !this.uses[n].containsKey(shrikeLocalName)) {
            return -1;
        }
        return this.uses[n].get(shrikeLocalName);
    }

    @Override
    public void setDef(int n, ShrikeLocalName shrikeLocalName, int n2) {
        if (this.defs[n] == null) {
            this.defs[n] = new HashMap<ShrikeLocalName, Integer>(2);
        }
        this.defs[n].put(shrikeLocalName, n2);
    }

    @Override
    public void setUse(int n, ShrikeLocalName shrikeLocalName, int n2) {
        if (this.uses[n] == null) {
            this.uses[n] = new HashMap<ShrikeLocalName, Integer>(2);
        }
        this.uses[n].put(shrikeLocalName, n2);
    }

    @Override
    public Collection<ShrikeLocalName> getNames() {
        HashSet<ShrikeLocalName> hashSet = new HashSet<ShrikeLocalName>();
        int n = 0;
        while (n < this.uses.length) {
            if (this.uses[n] != null) {
                hashSet.addAll(this.uses[n].keySet());
            }
            if (this.defs[n] != null) {
                hashSet.addAll(this.defs[n].keySet());
            }
            ++n;
        }
        return hashSet;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.defs.length) {
            if (this.defs[n] != null) {
                stringBuffer.append(String.valueOf(n) + " <- " + this.defs[n] + "\n");
            }
            if (this.uses[n] != null) {
                stringBuffer.append(String.valueOf(n) + " -> " + this.uses[n] + "\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShrikeLocalName
    implements SSAIndirectionData.Name {
        private final int bytecodeLocalNumber;

        public ShrikeLocalName(int n) {
            this.bytecodeLocalNumber = n;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.bytecodeLocalNumber;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ShrikeLocalName shrikeLocalName = (ShrikeLocalName)object;
            return this.bytecodeLocalNumber == shrikeLocalName.bytecodeLocalNumber;
        }

        public String toString() {
            return "(local:" + this.bytecodeLocalNumber + ")";
        }
    }
}

