/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;

public abstract class SSAMonitorInstruction
extends SSAInstruction {
    private final int ref;
    private final boolean isEnter;

    protected SSAMonitorInstruction(int n, boolean bl) {
        this.ref = n;
        this.isEnter = bl;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory sSAInstructionFactory, int[] nArray, int[] nArray2) {
        assert (nArray2 == null || nArray2.length == 1);
        return sSAInstructionFactory.MonitorInstruction(nArray2 == null ? this.ref : nArray2[0], this.isEnter);
    }

    public String toString(SymbolTable symbolTable) {
        return "monitor" + (this.isEnter ? "enter " : "exit ") + this.getValueString(symbolTable, this.ref);
    }

    public void visit(SSAInstruction.IVisitor iVisitor) {
        if (iVisitor == null) {
            throw new IllegalArgumentException("v is null");
        }
        iVisitor.visitMonitor(this);
    }

    public int getNumberOfUses() {
        return 1;
    }

    public int getUse(int n) {
        assert (n == 0);
        return this.ref;
    }

    public int hashCode() {
        return this.ref * 6173 + 4423;
    }

    public boolean isPEI() {
        return true;
    }

    public boolean isFallThrough() {
        return true;
    }

    public int getRef() {
        return this.ref;
    }

    public boolean isMonitorEnter() {
        return this.isEnter;
    }
}

