/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.types.TypeReference;

public abstract class SSAInvokeInstruction
extends SSAAbstractInvokeInstruction {
    private final int result;
    private final int[] params;

    protected SSAInvokeInstruction(int n, int[] nArray, int n2, CallSiteReference callSiteReference) {
        super(n2, callSiteReference);
        this.result = n;
        this.params = nArray;
        SSAInvokeInstruction.assertParamsKosher(n, nArray, callSiteReference);
    }

    protected SSAInvokeInstruction(int[] nArray, int n, CallSiteReference callSiteReference) {
        this(-1, nArray, n, callSiteReference);
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory sSAInstructionFactory, int[] nArray, int[] nArray2) {
        return sSAInstructionFactory.InvokeInstruction(nArray == null || this.result == -1 ? this.result : nArray[0], nArray2 == null ? this.params : nArray2, nArray == null ? this.exception : nArray[this.result == -1 ? 0 : 1], this.site);
    }

    public static void assertParamsKosher(int n, int[] nArray, CallSiteReference callSiteReference) throws IllegalArgumentException {
        if (callSiteReference == null) {
            throw new IllegalArgumentException("site cannot be null");
        }
        if (callSiteReference.getDeclaredTarget().getReturnType().equals(TypeReference.Void) && n != -1) assert (n == -1) : "bogus call to " + callSiteReference;
        int n2 = 0;
        if (!callSiteReference.isStatic()) {
            ++n2;
        }
        if ((n2 += callSiteReference.getDeclaredTarget().getNumberOfParameters()) > 0) {
            if (nArray == null) assert (nArray != null) : "null params for " + callSiteReference;
            if (nArray.length != n2) assert (nArray.length == n2) : "wrong number of params for " + callSiteReference + " Expected " + n2 + " got " + nArray.length;
        }
    }

    public void visit(SSAInstruction.IVisitor iVisitor) {
        if (iVisitor == null) {
            throw new IllegalArgumentException("v is null");
        }
        iVisitor.visitInvoke(this);
    }

    public int getNumberOfUses() {
        if (this.params == null) {
            assert (this.site.getInvocationCode() == IInvokeInstruction.Dispatch.STATIC || this.site.getInvocationCode() == IInvokeInstruction.Dispatch.SPECIAL);
            assert (this.site.getDeclaredTarget().getNumberOfParameters() == 0);
            return 0;
        }
        return this.params.length;
    }

    public int getNumberOfParameters() {
        return this.getNumberOfUses();
    }

    public int getNumberOfReturnValues() {
        return this.result == -1 ? 0 : 1;
    }

    public int getReturnValue(int n) {
        assert (n == 0 && this.result != -1);
        return this.result;
    }

    public int getUse(int n) {
        if (this.params == null) assert (false) : "Invalid getUse: " + n + " , null params " + this;
        if (this.params.length <= n) assert (this.params.length > n) : "Invalid getUse: " + this + ", index " + n + ", params.length " + this.params.length;
        return this.params[n];
    }

    public int hashCode() {
        return this.site.hashCode() * 7529 + this.exception * 9823;
    }
}

