/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;

public abstract class SSAConversionInstruction
extends SSAInstruction {
    private final int result;
    private final int val;
    private final TypeReference fromType;
    private final TypeReference toType;

    protected SSAConversionInstruction(int n, int n2, TypeReference typeReference, TypeReference typeReference2) {
        this.result = n;
        this.val = n2;
        this.fromType = typeReference;
        this.toType = typeReference2;
    }

    public String toString(SymbolTable symbolTable) {
        return String.valueOf(this.getValueString(symbolTable, this.result)) + " = conversion(" + this.toType.getName() + ") " + this.getValueString(symbolTable, this.val);
    }

    public void visit(SSAInstruction.IVisitor iVisitor) throws NullPointerException {
        iVisitor.visitConversion(this);
    }

    public boolean hasDef() {
        return true;
    }

    public int getDef() {
        return this.result;
    }

    public int getDef(int n) {
        assert (n == 0);
        return this.result;
    }

    public int getNumberOfUses() {
        return 1;
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public TypeReference getToType() {
        return this.toType;
    }

    public TypeReference getFromType() {
        return this.fromType;
    }

    public int getUse(int n) {
        assert (n == 0);
        return this.val;
    }

    public int hashCode() {
        return 6311 * this.result ^ this.val;
    }

    public boolean isFallThrough() {
        return true;
    }
}

