/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ssa.AuxiliaryCache;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IRFactory;
import com.ibm.wala.ssa.SSAOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSACache {
    private static final boolean DISABLE = false;
    private final IRFactory<IMethod> factory;
    private final AuxiliaryCache irCache = new AuxiliaryCache();
    private final AuxiliaryCache duCache = new AuxiliaryCache();

    public SSACache(IRFactory<IMethod> iRFactory) {
        this.factory = iRFactory;
    }

    public synchronized IR findOrCreateIR(IMethod iMethod, Context context, SSAOptions sSAOptions) {
        IR iR;
        if (iMethod == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (iMethod.isAbstract() || iMethod.isNative()) {
            return null;
        }
        if (this.factory.contextIsIrrelevant(iMethod)) {
            context = Everywhere.EVERYWHERE;
        }
        if ((iR = (IR)this.irCache.find(iMethod, context, sSAOptions)) == null) {
            iR = this.factory.makeIR(iMethod, context, sSAOptions);
            this.irCache.cache(iMethod, context, sSAOptions, iR);
        }
        return iR;
    }

    public synchronized DefUse findOrCreateDU(IMethod iMethod, Context context, SSAOptions sSAOptions) {
        DefUse defUse;
        if (iMethod == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (iMethod.isAbstract() || iMethod.isNative()) {
            return null;
        }
        if (this.factory.contextIsIrrelevant(iMethod)) {
            context = Everywhere.EVERYWHERE;
        }
        if ((defUse = (DefUse)this.duCache.find(iMethod, context, sSAOptions)) == null) {
            IR iR = this.findOrCreateIR(iMethod, context, sSAOptions);
            defUse = new DefUse(iR);
            this.duCache.cache(iMethod, context, sSAOptions, defUse);
        }
        return defUse;
    }

    public synchronized DefUse findOrCreateDU(IR iR, Context context) {
        if (iR == null) {
            throw new IllegalArgumentException("ir is null");
        }
        DefUse defUse = (DefUse)this.duCache.find(iR.getMethod(), context, iR.getOptions());
        if (defUse == null) {
            defUse = new DefUse(iR);
            this.duCache.cache(iR.getMethod(), context, iR.getOptions(), defUse);
        }
        return defUse;
    }

    public void wipe() {
        this.irCache.wipe();
        this.duCache.wipe();
    }

    public void invalidateIR(IMethod iMethod, Context context) {
        this.irCache.invalidate(iMethod, context);
    }

    public void invalidateDU(IMethod iMethod, Context context) {
        this.duCache.invalidate(iMethod, context);
    }

    public void invalidate(IMethod iMethod, Context context) {
        this.invalidateIR(iMethod, context);
        this.invalidateDU(iMethod, context);
    }
}

