/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAArrayReferenceInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;

public abstract class SSAArrayStoreInstruction
extends SSAArrayReferenceInstruction {
    private final int value;

    protected SSAArrayStoreInstruction(int n, int n2, int n3, TypeReference typeReference) {
        super(n, n2, typeReference);
        this.value = n3;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory sSAInstructionFactory, int[] nArray, int[] nArray2) {
        if (nArray2 != null && nArray2.length < 3) {
            throw new IllegalArgumentException("uses.length < 3");
        }
        return sSAInstructionFactory.ArrayStoreInstruction(nArray2 == null ? this.getArrayRef() : nArray2[0], nArray2 == null ? this.getIndex() : nArray2[1], nArray2 == null ? this.value : nArray2[2], this.getElementType());
    }

    public String toString(SymbolTable symbolTable) {
        return "arraystore " + this.getValueString(symbolTable, this.getArrayRef()) + "[" + this.getValueString(symbolTable, this.getIndex()) + "] = " + this.getValueString(symbolTable, this.value);
    }

    public void visit(SSAInstruction.IVisitor iVisitor) {
        if (iVisitor == null) {
            throw new IllegalArgumentException("v is null");
        }
        iVisitor.visitArrayStore(this);
    }

    public int getNumberOfUses() {
        return 3;
    }

    public int getNumberOfDefs() {
        return 0;
    }

    public int getValue() {
        return this.value;
    }

    public int getUse(int n) {
        if (n == 2) {
            return this.value;
        }
        return super.getUse(n);
    }

    public int hashCode() {
        return 6311 * this.value ^ 2371 * this.getArrayRef() + this.getIndex();
    }
}

