/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.TypeReference;

public abstract class SSAArrayReferenceInstruction
extends SSAInstruction {
    private final int arrayref;
    private final int index;
    private final TypeReference elementType;

    SSAArrayReferenceInstruction(int n, int n2, TypeReference typeReference) {
        this.arrayref = n;
        this.index = n2;
        this.elementType = typeReference;
        if (typeReference == null) {
            throw new IllegalArgumentException("null elementType");
        }
    }

    public int getNumberOfUses() {
        return 2;
    }

    public int getUse(int n) {
        assert (n <= 1);
        return n == 0 ? this.arrayref : this.index;
    }

    public int getArrayRef() {
        return this.arrayref;
    }

    public int getIndex() {
        return this.index;
    }

    public TypeReference getElementType() {
        return this.elementType;
    }

    public boolean typeIsPrimitive() {
        return this.elementType.isPrimitiveType();
    }

    public boolean isPEI() {
        return true;
    }

    public boolean isFallThrough() {
        return true;
    }
}

