/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;

public abstract class SSAAbstractInvokeInstruction
extends SSAInstruction {
    protected final int exception;
    protected final CallSiteReference site;

    protected SSAAbstractInvokeInstruction(int n, CallSiteReference callSiteReference) {
        this.exception = n;
        this.site = callSiteReference;
    }

    public CallSiteReference getCallSite() {
        return this.site;
    }

    public boolean isStatic() {
        return this.getCallSite().isStatic();
    }

    public boolean isDispatch() {
        return this.getCallSite().isDispatch();
    }

    public boolean isSpecial() {
        return this.getCallSite().isSpecial();
    }

    public int getReceiver() {
        assert (this.site.getInvocationCode() != IInvokeInstruction.Dispatch.STATIC) : this.toString();
        return this.getUse(0);
    }

    public int getProgramCounter() {
        return this.site.getProgramCounter();
    }

    public int getNumberOfDefs() {
        return this.getNumberOfReturnValues() + 1;
    }

    public int getDef(int n) {
        if (this.getNumberOfReturnValues() == 0) {
            assert (n == 0);
            return this.exception;
        }
        if (n == 0) {
            return this.getReturnValue(0);
        }
        if (n == 1) {
            return this.exception;
        }
        return this.getReturnValue(n - 1);
    }

    public int getException() {
        return this.exception;
    }

    public boolean hasDef() {
        return this.getNumberOfReturnValues() > 0;
    }

    public int getDef() {
        return this.getReturnValue(0);
    }

    public abstract int getNumberOfParameters();

    public abstract int getNumberOfReturnValues();

    public abstract int getReturnValue(int var1);

    public TypeReference getDeclaredResultType() {
        return this.site.getDeclaredTarget().getReturnType();
    }

    public MethodReference getDeclaredTarget() {
        return this.site.getDeclaredTarget();
    }

    public IInvokeInstruction.IDispatch getInvocationCode() {
        return this.site.getInvocationCode();
    }

    public boolean isPEI() {
        return true;
    }

    public boolean isFallThrough() {
        return true;
    }

    public String toString(SymbolTable symbolTable) {
        String string = this.site.getInvocationString();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hasDef()) {
            stringBuffer.append(this.getValueString(symbolTable, this.getDef())).append(" = ");
        }
        stringBuffer.append("invoke").append(string);
        stringBuffer.append(" ");
        stringBuffer.append(this.site.getDeclaredTarget().toString());
        if (this.getNumberOfParameters() > 0) {
            stringBuffer.append(" ").append(this.getValueString(symbolTable, this.getUse(0)));
            int n = 1;
            while (n < this.getNumberOfParameters()) {
                stringBuffer.append(",").append(this.getValueString(symbolTable, this.getUse(n)));
                ++n;
            }
        }
        stringBuffer.append(" @");
        stringBuffer.append(this.site.getProgramCounter());
        if (this.exception == -1) {
            stringBuffer.append(" exception: NOT MODELED");
        } else {
            stringBuffer.append(" exception:").append(this.getValueString(symbolTable, this.exception));
        }
        return stringBuffer.toString();
    }
}

