/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefUse {
    static final boolean DEBUG = false;
    private final SSAInstruction[] defs;
    private final MutableIntSet[] uses;
    protected final ArrayList<SSAInstruction> allInstructions = new ArrayList();
    private final IR ir;

    public DefUse(IR iR) {
        if (iR == null) {
            throw new IllegalArgumentException("ir is null");
        }
        this.ir = iR;
        this.initAllInstructions();
        this.defs = new SSAInstruction[this.getMaxValueNumber() + 1];
        this.uses = new MutableIntSet[this.getMaxValueNumber() + 1];
        Iterator<SSAInstruction> iterator = this.allInstructions.iterator();
        int n = 0;
        while (n < this.allInstructions.size()) {
            SSAInstruction sSAInstruction = iterator.next();
            if (sSAInstruction != null) {
                int n2 = 0;
                while (n2 < this.getNumberOfDefs(sSAInstruction)) {
                    this.defs[this.getDef((SSAInstruction)sSAInstruction, (int)n2)] = sSAInstruction;
                    ++n2;
                }
                n2 = 0;
                while (n2 < this.getNumberOfUses(sSAInstruction)) {
                    int n3 = this.getUse(sSAInstruction, n2);
                    try {
                        if (n3 != -1) {
                            if (this.uses[n3] == null) {
                                this.uses[n3] = IntSetUtil.make();
                            }
                            this.uses[n3].add(n);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new InternalError("unexpected value number " + n3);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    protected int getMaxValueNumber() {
        return this.ir.getSymbolTable().getMaxValueNumber();
    }

    protected void initAllInstructions() {
        Iterator<SSAInstruction> iterator = this.ir.iterateAllInstructions();
        while (iterator.hasNext()) {
            this.allInstructions.add(iterator.next());
        }
    }

    protected int getDef(SSAInstruction sSAInstruction, int n) {
        return sSAInstruction.getDef(n);
    }

    protected int getUse(SSAInstruction sSAInstruction, int n) {
        return sSAInstruction.getUse(n);
    }

    protected int getNumberOfDefs(SSAInstruction sSAInstruction) {
        return sSAInstruction.getNumberOfDefs();
    }

    protected int getNumberOfUses(SSAInstruction sSAInstruction) {
        return sSAInstruction.getNumberOfUses();
    }

    public SSAInstruction getDef(int n) {
        return n < this.defs.length ? this.defs[n] : null;
    }

    public Iterator<SSAInstruction> getUses(int n) {
        if (this.uses[n] == null) {
            return EmptyIterator.instance();
        }
        return new UseIterator(this.uses[n]);
    }

    public int getNumberOfUses(int n) {
        return this.uses[n] == null ? 0 : this.uses[n].size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UseIterator
    implements Iterator<SSAInstruction> {
        final IntIterator it;

        UseIterator(IntSet intSet) {
            this.it = intSet.intIterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public SSAInstruction next() {
            return DefUse.this.allInstructions.get(this.it.next());
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }
    }
}

