/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.ref.CacheReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

class AuxiliaryCache {
    private HashMap<Pair<IMethod, Context>, Map<SSAOptions, Object>> dictionary = HashMapFactory.make();
    private static final int RESET_THRESHOLD = 2000;
    private int nItems = 0;

    AuxiliaryCache() {
    }

    public synchronized void wipe() {
        this.dictionary = HashMapFactory.make();
        this.nItems = 0;
    }

    private void reset() {
        HashMap<Pair<IMethod, Context>, Map<SSAOptions, Object>> hashMap = this.dictionary;
        this.dictionary = HashMapFactory.make();
        this.nItems = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            Map map = (Map)entry.getValue();
            HashSet hashSet = HashSetFactory.make();
            for (Map.Entry entry2 : map.entrySet()) {
                Object k = entry2.getKey();
                Object v = entry2.getValue();
                if (CacheReference.get(v) != null) continue;
                hashSet.add(k);
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                map.remove(iterator.next());
            }
            if (map.size() <= 0) continue;
            this.dictionary.put((Pair)entry.getKey(), map);
        }
    }

    public synchronized Object find(IMethod iMethod, Context context, SSAOptions sSAOptions) {
        Pair<IMethod, Context> pair = Pair.make(iMethod, context);
        Map<SSAOptions, Object> map = MapUtil.findOrCreateMap(this.dictionary, pair);
        Object object = map.get(sSAOptions);
        if (object == null || CacheReference.get(object) == null) {
            return null;
        }
        return CacheReference.get(object);
    }

    public synchronized void cache(IMethod iMethod, Context context, SSAOptions sSAOptions, Object object) {
        ++this.nItems;
        if (this.nItems > 2000) {
            this.reset();
        }
        Pair<IMethod, Context> pair = Pair.make(iMethod, context);
        Map<SSAOptions, Object> map = MapUtil.findOrCreateMap(this.dictionary, pair);
        Object object2 = CacheReference.make(object);
        map.put(sSAOptions, object2);
    }

    public void invalidate(IMethod iMethod, Context context) {
        this.dictionary.remove(Pair.make(iMethod, context));
    }
}

