/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer;

import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.slicer.ExceptionalReturnCaller;
import com.ibm.wala.ipa.slicer.HeapStatement;
import com.ibm.wala.ipa.slicer.ISDG;
import com.ibm.wala.ipa.slicer.MethodEntryStatement;
import com.ibm.wala.ipa.slicer.MethodExitStatement;
import com.ibm.wala.ipa.slicer.NormalReturnCaller;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.PDG;
import com.ibm.wala.ipa.slicer.ParamCaller;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.intset.IntSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SDGSupergraph
implements ISupergraph<Statement, PDG> {
    private final ISDG sdg;
    private final boolean backward;

    public SDGSupergraph(ISDG iSDG, boolean bl) {
        this.sdg = iSDG;
        this.backward = bl;
    }

    @Override
    public Graph<PDG> getProcedureGraph() {
        Assertions.UNREACHABLE();
        return null;
    }

    public Object[] getEntry(Statement statement) {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public byte classifyEdge(Statement statement, Statement statement2) {
        Assertions.UNREACHABLE();
        return 0;
    }

    @Override
    public Iterator<? extends Statement> getCallSites(Statement statement, PDG pDG) {
        switch (statement.getKind()) {
            case EXC_RET_CALLER: {
                ExceptionalReturnCaller exceptionalReturnCaller = (ExceptionalReturnCaller)statement;
                SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = exceptionalReturnCaller.getInstruction();
                PDG pDG2 = this.getProcOf(statement);
                return pDG2.getCallStatements(sSAAbstractInvokeInstruction).iterator();
            }
            case NORMAL_RET_CALLER: {
                NormalReturnCaller normalReturnCaller = (NormalReturnCaller)statement;
                SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = normalReturnCaller.getInstruction();
                PDG pDG3 = this.getProcOf(statement);
                return pDG3.getCallStatements(sSAAbstractInvokeInstruction).iterator();
            }
            case HEAP_RET_CALLER: {
                HeapStatement.HeapReturnCaller heapReturnCaller = (HeapStatement.HeapReturnCaller)statement;
                SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = heapReturnCaller.getCall();
                PDG pDG4 = this.getProcOf(statement);
                return pDG4.getCallStatements(sSAAbstractInvokeInstruction).iterator();
            }
        }
        Assertions.UNREACHABLE(statement.getKind().toString());
        return null;
    }

    @Override
    public Iterator<? extends Statement> getCalledNodes(Statement statement) {
        switch (statement.getKind()) {
            case NORMAL: {
                Filter filter = new Filter(){

                    public boolean accepts(Object object) {
                        Statement statement = (Statement)object;
                        return SDGSupergraph.this.isEntry(statement);
                    }
                };
                return new FilterIterator(this.getSuccNodes(statement), filter);
            }
            case PARAM_CALLER: 
            case HEAP_PARAM_CALLER: {
                return this.getSuccNodes(statement);
            }
        }
        Assertions.UNREACHABLE(statement.getKind().toString());
        return null;
    }

    public Statement[] getEntriesForProcedure(PDG pDG) {
        Statement[] statementArray = pDG.getParamCalleeStatements();
        Statement[] statementArray2 = new Statement[statementArray.length + 1];
        statementArray2[0] = new MethodEntryStatement(pDG.getCallGraphNode());
        System.arraycopy(statementArray, 0, statementArray2, 1, statementArray.length);
        return statementArray2;
    }

    public Statement[] getExitsForProcedure(PDG pDG) {
        Statement[] statementArray = pDG.getReturnStatements();
        Statement[] statementArray2 = new Statement[statementArray.length + 1];
        statementArray2[0] = new MethodExitStatement(pDG.getCallGraphNode());
        System.arraycopy(statementArray, 0, statementArray2, 1, statementArray.length);
        return statementArray2;
    }

    @Override
    public Statement getLocalBlock(PDG pDG, int n) {
        return pDG.getNode(n);
    }

    @Override
    public int getLocalBlockNumber(Statement statement) {
        PDG pDG = this.getProcOf(statement);
        return pDG.getNumber(statement);
    }

    @Override
    public Iterator<Statement> getNormalSuccessors(Statement statement) {
        if (!this.backward) {
            return EmptyIterator.instance();
        }
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public int getNumberOfBlocks(PDG pDG) {
        Assertions.UNREACHABLE();
        return 0;
    }

    @Override
    public PDG getProcOf(Statement statement) {
        CGNode cGNode = statement.getNode();
        PDG pDG = this.sdg.getPDG(cGNode);
        if (pDG == null) {
            Assertions.UNREACHABLE("panic: " + statement + " " + cGNode);
        }
        return pDG;
    }

    @Override
    public Iterator<? extends Statement> getReturnSites(Statement statement, PDG pDG) {
        switch (statement.getKind()) {
            case PARAM_CALLER: {
                ParamCaller paramCaller = (ParamCaller)statement;
                SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = paramCaller.getInstruction();
                PDG pDG2 = this.getProcOf(statement);
                return pDG2.getCallerReturnStatements(sSAAbstractInvokeInstruction).iterator();
            }
            case HEAP_PARAM_CALLER: {
                HeapStatement.HeapParamCaller heapParamCaller = (HeapStatement.HeapParamCaller)statement;
                SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = heapParamCaller.getCall();
                PDG pDG3 = this.getProcOf(statement);
                return pDG3.getCallerReturnStatements(sSAAbstractInvokeInstruction).iterator();
            }
            case NORMAL: {
                NormalStatement normalStatement = (NormalStatement)statement;
                SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = (SSAAbstractInvokeInstruction)normalStatement.getInstruction();
                PDG pDG4 = this.getProcOf(statement);
                return pDG4.getCallerReturnStatements(sSAAbstractInvokeInstruction).iterator();
            }
        }
        Assertions.UNREACHABLE(statement.getKind().toString());
        return null;
    }

    @Override
    public boolean isCall(Statement statement) {
        switch (statement.getKind()) {
            case PHI: 
            case PI: 
            case CATCH: 
            case PARAM_CALLEE: 
            case NORMAL_RET_CALLER: 
            case NORMAL_RET_CALLEE: 
            case EXC_RET_CALLER: 
            case EXC_RET_CALLEE: 
            case HEAP_PARAM_CALLEE: 
            case HEAP_RET_CALLER: 
            case HEAP_RET_CALLEE: 
            case METHOD_ENTRY: 
            case METHOD_EXIT: {
                return false;
            }
            case PARAM_CALLER: 
            case HEAP_PARAM_CALLER: {
                return true;
            }
            case NORMAL: {
                if (this.sdg.getCOptions().equals((Object)Slicer.ControlDependenceOptions.NONE)) {
                    return false;
                }
                NormalStatement normalStatement = (NormalStatement)statement;
                return normalStatement.getInstruction() instanceof SSAAbstractInvokeInstruction;
            }
        }
        Assertions.UNREACHABLE((Object)((Object)statement.getKind()) + " " + statement.toString());
        return false;
    }

    @Override
    public boolean isEntry(Statement statement) {
        switch (statement.getKind()) {
            case PARAM_CALLEE: 
            case HEAP_PARAM_CALLEE: 
            case METHOD_ENTRY: {
                return true;
            }
            case NORMAL: 
            case PHI: 
            case PI: 
            case CATCH: 
            case PARAM_CALLER: 
            case NORMAL_RET_CALLER: 
            case NORMAL_RET_CALLEE: 
            case EXC_RET_CALLER: 
            case EXC_RET_CALLEE: 
            case HEAP_PARAM_CALLER: 
            case HEAP_RET_CALLER: 
            case HEAP_RET_CALLEE: {
                return false;
            }
        }
        Assertions.UNREACHABLE(statement.toString());
        return false;
    }

    @Override
    public boolean isExit(Statement statement) {
        switch (statement.getKind()) {
            case NORMAL: 
            case PHI: 
            case PI: 
            case CATCH: 
            case PARAM_CALLER: 
            case PARAM_CALLEE: 
            case NORMAL_RET_CALLER: 
            case EXC_RET_CALLER: 
            case HEAP_PARAM_CALLER: 
            case HEAP_PARAM_CALLEE: 
            case HEAP_RET_CALLER: 
            case METHOD_ENTRY: {
                return false;
            }
            case NORMAL_RET_CALLEE: 
            case EXC_RET_CALLEE: 
            case HEAP_RET_CALLEE: 
            case METHOD_EXIT: {
                return true;
            }
        }
        Assertions.UNREACHABLE(statement.toString());
        return false;
    }

    @Override
    public boolean isReturn(Statement statement) {
        switch (statement.getKind()) {
            case NORMAL_RET_CALLER: 
            case EXC_RET_CALLER: 
            case HEAP_RET_CALLER: {
                return true;
            }
            case NORMAL: 
            case PHI: 
            case PI: 
            case CATCH: 
            case PARAM_CALLER: 
            case PARAM_CALLEE: 
            case NORMAL_RET_CALLEE: 
            case EXC_RET_CALLEE: 
            case HEAP_PARAM_CALLER: 
            case HEAP_PARAM_CALLEE: 
            case HEAP_RET_CALLEE: 
            case METHOD_ENTRY: {
                return false;
            }
        }
        Assertions.UNREACHABLE(statement.getKind().toString());
        return false;
    }

    @Override
    public void removeNodeAndEdges(Statement statement) {
        Assertions.UNREACHABLE();
    }

    @Override
    public void addNode(Statement statement) {
        Assertions.UNREACHABLE();
    }

    @Override
    public boolean containsNode(Statement statement) {
        return this.sdg.containsNode(statement);
    }

    @Override
    public int getNumberOfNodes() {
        Assertions.UNREACHABLE();
        return 0;
    }

    @Override
    public Iterator<Statement> iterator() {
        return this.sdg.iterator();
    }

    @Override
    public void removeNode(Statement statement) {
        Assertions.UNREACHABLE();
    }

    @Override
    public void addEdge(Statement statement, Statement statement2) {
        Assertions.UNREACHABLE();
    }

    @Override
    public int getPredNodeCount(Statement statement) {
        Assertions.UNREACHABLE();
        return 0;
    }

    @Override
    public Iterator<Statement> getPredNodes(Statement statement) {
        return this.sdg.getPredNodes(statement);
    }

    @Override
    public int getSuccNodeCount(Statement statement) {
        Assertions.UNREACHABLE();
        return 0;
    }

    @Override
    public Iterator<Statement> getSuccNodes(Statement statement) {
        return this.sdg.getSuccNodes(statement);
    }

    @Override
    public boolean hasEdge(Statement statement, Statement statement2) {
        return this.sdg.hasEdge(statement, statement2);
    }

    @Override
    public void removeAllIncidentEdges(Statement statement) {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeEdge(Statement statement, Statement statement2) {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeIncomingEdges(Statement statement) {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeOutgoingEdges(Statement statement) {
        Assertions.UNREACHABLE();
    }

    @Override
    public int getMaxNumber() {
        return this.sdg.getMaxNumber();
    }

    @Override
    public Statement getNode(int n) {
        return (Statement)this.sdg.getNode(n);
    }

    @Override
    public int getNumber(Statement statement) {
        return this.sdg.getNumber(statement);
    }

    @Override
    public Iterator<Statement> iterateNodes(IntSet intSet) {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getPredNodeNumbers(Statement statement) {
        return this.sdg.getPredNodeNumbers(statement);
    }

    @Override
    public IntSet getSuccNodeNumbers(Statement statement) {
        return this.sdg.getSuccNodeNumbers(statement);
    }
}

