/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.cdg.ControlDependenceGraph;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.impl.SetOfClasses;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cfg.ExceptionPrunedCFG;
import com.ibm.wala.ipa.modref.DelegatingExtendedHeapModel;
import com.ibm.wala.ipa.modref.ExtendedHeapModel;
import com.ibm.wala.ipa.modref.ModRef;
import com.ibm.wala.ipa.slicer.ExceptionalReturnCallee;
import com.ibm.wala.ipa.slicer.ExceptionalReturnCaller;
import com.ibm.wala.ipa.slicer.GetCaughtExceptionStatement;
import com.ibm.wala.ipa.slicer.HeapExclusions;
import com.ibm.wala.ipa.slicer.HeapReachingDefs;
import com.ibm.wala.ipa.slicer.HeapStatement;
import com.ibm.wala.ipa.slicer.MethodEntryStatement;
import com.ibm.wala.ipa.slicer.MethodExitStatement;
import com.ibm.wala.ipa.slicer.NormalReturnCallee;
import com.ibm.wala.ipa.slicer.NormalReturnCaller;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.ParamCallee;
import com.ibm.wala.ipa.slicer.ParamCaller;
import com.ibm.wala.ipa.slicer.PhiStatement;
import com.ibm.wala.ipa.slicer.PiStatement;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ipa.slicer.ValueNumberCarrier;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayReferenceInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAFieldAccessInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.Iterator2Set;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.dominators.Dominators;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.OrdinalSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDG
implements NumberedGraph<Statement> {
    private final SlowSparseNumberedGraph<Statement> delegate = SlowSparseNumberedGraph.make();
    private static final boolean VERBOSE = false;
    private final CGNode node;
    private Statement[] paramCalleeStatements;
    private Statement[] returnStatements;
    private final Map<CallSiteReference, Statement> callSite2Statement = HashMapFactory.make();
    private final Map<CallSiteReference, Set<Statement>> callerParamStatements = HashMapFactory.make();
    private final Map<CallSiteReference, Set<Statement>> callerReturnStatements = HashMapFactory.make();
    private final HeapExclusions exclusions;
    private final Collection<PointerKey> locationsHandled = HashSetFactory.make();
    private final PointerAnalysis pa;
    private final ExtendedHeapModel heapModel;
    private final Map<CGNode, OrdinalSet<PointerKey>> mod;
    private final Slicer.DataDependenceOptions dOptions;
    private final Slicer.ControlDependenceOptions cOptions;
    private final CallGraph cg;
    private final ModRef modRef;
    private final Map<CGNode, OrdinalSet<PointerKey>> ref;
    private final boolean ignoreAllocHeapDefs;
    private boolean isPopulated = false;

    public PDG(CGNode cGNode, PointerAnalysis pointerAnalysis, Map<CGNode, OrdinalSet<PointerKey>> map, Map<CGNode, OrdinalSet<PointerKey>> map2, Slicer.DataDependenceOptions dataDependenceOptions, Slicer.ControlDependenceOptions controlDependenceOptions, HeapExclusions heapExclusions, CallGraph callGraph, ModRef modRef) {
        this(cGNode, pointerAnalysis, map, map2, dataDependenceOptions, controlDependenceOptions, heapExclusions, callGraph, modRef, false);
    }

    public PDG(CGNode cGNode, PointerAnalysis pointerAnalysis, Map<CGNode, OrdinalSet<PointerKey>> map, Map<CGNode, OrdinalSet<PointerKey>> map2, Slicer.DataDependenceOptions dataDependenceOptions, Slicer.ControlDependenceOptions controlDependenceOptions, HeapExclusions heapExclusions, CallGraph callGraph, ModRef modRef, boolean bl) {
        if (cGNode == null) {
            throw new IllegalArgumentException("node is null");
        }
        this.cg = callGraph;
        this.node = cGNode;
        this.heapModel = pointerAnalysis == null ? null : new DelegatingExtendedHeapModel(pointerAnalysis.getHeapModel());
        this.pa = pointerAnalysis;
        this.dOptions = dataDependenceOptions;
        this.cOptions = controlDependenceOptions;
        this.mod = map;
        this.exclusions = heapExclusions;
        this.modRef = modRef;
        this.ref = map2;
        this.ignoreAllocHeapDefs = bl;
    }

    private void populate() {
        if (!this.isPopulated) {
            IR iR = this.node.getIR();
            this.isPopulated = true;
            Map<SSAInstruction, Integer> map = PDG.computeInstructionIndices(iR);
            this.createNodes(this.ref, this.cOptions, iR);
            this.createScalarEdges(this.cOptions, iR, map);
        }
    }

    private void createScalarEdges(Slicer.ControlDependenceOptions controlDependenceOptions, IR iR, Map<SSAInstruction, Integer> map) {
        this.createScalarDataDependenceEdges(iR, map);
        this.createControlDependenceEdges(controlDependenceOptions, iR, map);
    }

    public Set<Statement> getCallerParamStatements(SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction) throws IllegalArgumentException {
        if (sSAAbstractInvokeInstruction == null) {
            throw new IllegalArgumentException("call == null");
        }
        this.populate();
        return this.callerParamStatements.get(sSAAbstractInvokeInstruction.getCallSite());
    }

    public Set<Statement> getCallStatements(SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction) throws IllegalArgumentException {
        Set<Statement> set = this.getCallerParamStatements(sSAAbstractInvokeInstruction);
        HashSet<Statement> hashSet = HashSetFactory.make(set.size() + 1);
        hashSet.addAll(set);
        hashSet.add(this.callSite2Statement.get(sSAAbstractInvokeInstruction.getCallSite()));
        return hashSet;
    }

    public Set<Statement> getCallerReturnStatements(SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction) throws IllegalArgumentException {
        if (sSAAbstractInvokeInstruction == null) {
            throw new IllegalArgumentException("call == null");
        }
        this.populate();
        return this.callerReturnStatements.get(sSAAbstractInvokeInstruction.getCallSite());
    }

    /*
     * WARNING - void declaration
     */
    private void createControlDependenceEdges(Slicer.ControlDependenceOptions controlDependenceOptions, IR iR, Map<SSAInstruction, Integer> map) {
        Object object;
        Object object2;
        Iterator<SSAPhiInstruction> iterator2;
        Object object322;
        if (controlDependenceOptions.equals((Object)Slicer.ControlDependenceOptions.NONE)) {
            return;
        }
        if (iR == null) {
            return;
        }
        ControlFlowGraph<SSAInstruction, ISSABasicBlock> controlFlowGraph = iR.getControlFlowGraph();
        if (controlDependenceOptions.equals((Object)Slicer.ControlDependenceOptions.NO_EXCEPTIONAL_EDGES)) {
            if ((controlFlowGraph = ExceptionPrunedCFG.make(controlFlowGraph)).getNumberOfNodes() == 0) {
                return;
            }
        } else {
            Assertions.productionAssertion(controlDependenceOptions.equals((Object)Slicer.ControlDependenceOptions.FULL));
        }
        ControlDependenceGraph<SSAInstruction, ISSABasicBlock> controlDependenceGraph = new ControlDependenceGraph<SSAInstruction, ISSABasicBlock>(controlFlowGraph);
        for (Object object322 : controlDependenceGraph) {
            void object5;
            Object object3;
            if (object322.isExitBlock()) continue;
            Object var8_9 = null;
            if (object322.isEntryBlock()) {
                MethodEntryStatement methodEntryStatement = new MethodEntryStatement(this.node);
            } else {
                object3 = iR.getInstructions()[object322.getLastInstructionIndex()];
                if (object3 != null) {
                    Statement statement = this.ssaInstruction2Statement((SSAInstruction)object3, iR, map);
                }
            }
            if (object5 == null) continue;
            object3 = controlDependenceGraph.getSuccNodes((ISSABasicBlock)object322);
            while (object3.hasNext()) {
                iterator2 = (ISSABasicBlock)object3.next();
                object2 = iterator2.iterator();
                while (object2.hasNext()) {
                    object = (SSAInstruction)object2.next();
                    if (object == null) continue;
                    Statement statement = this.ssaInstruction2Statement((SSAInstruction)object, iR, map);
                    assert (object5 != null);
                    this.delegate.addEdge((Statement)object5, statement);
                }
            }
        }
        object322 = new MethodEntryStatement(this.node);
        Dominators<ISSABasicBlock> dominators = Dominators.make(controlFlowGraph, controlFlowGraph.entry());
        for (ISSABasicBlock iSSABasicBlock : Iterator2Iterable.make(dominators.dominators(controlFlowGraph.exit()))) {
            for (Iterator<SSAPhiInstruction> iterator2 : iSSABasicBlock) {
                object = this.ssaInstruction2Statement((SSAInstruction)((Object)iterator2), iR, map);
                this.delegate.addEdge((Statement)object322, (Statement)object);
            }
        }
        if (!this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
            for (ISSABasicBlock iSSABasicBlock : controlDependenceGraph) {
                iterator2 = iSSABasicBlock.iteratePhis();
                while (iterator2.hasNext()) {
                    object2 = iterator2.next();
                    object = this.ssaInstruction2Statement((SSAInstruction)object2, iR, map);
                    int n = 0;
                    Iterator<ISSABasicBlock> iterator3 = controlFlowGraph.getPredNodes(iSSABasicBlock);
                    while (iterator3.hasNext()) {
                        Object object4;
                        Object object5;
                        ISSABasicBlock iSSABasicBlock2 = iterator3.next();
                        int n2 = ((SSAPhiInstruction)object2).getUse(n);
                        if (n2 == -1) continue;
                        if (controlFlowGraph.getSuccNodeCount(iSSABasicBlock2) > 1) {
                            object5 = iR.getInstructions()[iSSABasicBlock2.getLastInstructionIndex()];
                            assert (object5 != null);
                            object4 = this.ssaInstruction2Statement((SSAInstruction)object5, iR, map);
                            this.delegate.addEdge((Statement)object4, (Statement)object);
                        } else {
                            object5 = controlDependenceGraph.getPredNodes(iSSABasicBlock2);
                            while (object5.hasNext()) {
                                object4 = (ISSABasicBlock)object5.next();
                                SSAInstruction sSAInstruction = iR.getInstructions()[object4.getLastInstructionIndex()];
                                assert (sSAInstruction != null) : "unexpected null final instruction for CDG predecessor " + object4 + " in node " + this.node;
                                Statement statement = this.ssaInstruction2Statement(sSAInstruction, iR, map);
                                this.delegate.addEdge(statement, (Statement)object);
                            }
                        }
                        ++n;
                    }
                }
            }
        }
    }

    private void createScalarDataDependenceEdges(IR iR, Map<SSAInstruction, Integer> map) {
        Object object;
        if (this.dOptions.equals((Object)Slicer.DataDependenceOptions.NONE)) {
            return;
        }
        if (iR == null) {
            return;
        }
        DefUse defUse = new DefUse(iR);
        SSAInstruction[] sSAInstructionArray = iR.getInstructions();
        if (!this.dOptions.isIgnoreExceptions()) {
            for (Object object3 : iR.getControlFlowGraph()) {
                SSACFG.ExceptionHandlerBasicBlock object22;
                if (!object3.isCatchBlock() || (object22 = (SSACFG.ExceptionHandlerBasicBlock)object3).getCatchInstruction() == null) continue;
                Statement statement = this.ssaInstruction2Statement(object22.getCatchInstruction(), iR, map);
                for (ISSABasicBlock iSSABasicBlock : iR.getControlFlowGraph().getExceptionalPredecessors(object22)) {
                    object = sSAInstructionArray[iSSABasicBlock.getLastInstructionIndex()];
                    if (object instanceof SSAAbstractInvokeInstruction) {
                        this.delegate.addEdge(new ExceptionalReturnCaller(this.node, iSSABasicBlock.getLastInstructionIndex()), statement);
                        continue;
                    }
                    if (!(object instanceof SSAAbstractThrowInstruction)) continue;
                    this.delegate.addEdge(this.ssaInstruction2Statement((SSAInstruction)object, iR, map), statement);
                }
            }
        }
        block10: for (Object object5 : this) {
            switch (((Statement)object5).getKind()) {
                case NORMAL: 
                case PHI: 
                case PI: 
                case CATCH: {
                    SSAInstruction sSAInstruction = this.statement2SSAInstruction(sSAInstructionArray, (Statement)object5);
                    if (sSAInstruction instanceof SSAAbstractInvokeInstruction || this.dOptions.isTerminateAtCast() && sSAInstruction instanceof SSACheckCastInstruction || this.dOptions.isTerminateAtCast() && sSAInstruction instanceof SSAInstanceofInstruction) continue block10;
                    int n = 0;
                    while (n < sSAInstruction.getNumberOfDefs()) {
                        int n2 = sSAInstruction.getDef(n);
                        Iterator<SSAInstruction> iterator = defUse.getUses(n2);
                        while (iterator.hasNext()) {
                            SSAArrayReferenceInstruction sSAArrayReferenceInstruction;
                            int n3;
                            object = iterator.next();
                            if (this.dOptions.isIgnoreBasePtrs() && (object instanceof SSANewInstruction || this.hasBasePointer((SSAInstruction)object) && (n2 == (n3 = this.getBasePointer((SSAInstruction)object)) || object instanceof SSAArrayReferenceInstruction && n2 == (sSAArrayReferenceInstruction = (SSAArrayReferenceInstruction)object).getIndex()))) continue;
                            Statement statement = this.ssaInstruction2Statement((SSAInstruction)object, iR, map);
                            this.delegate.addEdge((Statement)object5, statement);
                        }
                        ++n;
                    }
                    continue block10;
                }
                case PARAM_CALLEE: 
                case NORMAL_RET_CALLER: 
                case EXC_RET_CALLER: {
                    if (this.dOptions.isIgnoreExceptions()) assert (!((Statement)object5).getKind().equals((Object)Statement.Kind.EXC_RET_CALLER));
                    ValueNumberCarrier valueNumberCarrier = (ValueNumberCarrier)object5;
                    Iterator<SSAInstruction> iterator = defUse.getUses(valueNumberCarrier.getValueNumber());
                    while (iterator.hasNext()) {
                        SSAInstruction sSAInstruction = iterator.next();
                        if (this.dOptions.isIgnoreBasePtrs()) {
                            if (sSAInstruction instanceof SSANewInstruction) continue;
                            if (this.hasBasePointer(sSAInstruction)) {
                                int n = this.getBasePointer(sSAInstruction);
                                if (valueNumberCarrier.getValueNumber() == n) continue;
                                if (sSAInstruction instanceof SSAArrayReferenceInstruction) {
                                    object = (SSAArrayReferenceInstruction)sSAInstruction;
                                    if (valueNumberCarrier.getValueNumber() == ((SSAArrayReferenceInstruction)object).getIndex()) continue;
                                }
                            }
                        }
                        Statement statement = this.ssaInstruction2Statement(sSAInstruction, iR, map);
                        this.delegate.addEdge((Statement)object5, statement);
                    }
                    continue block10;
                }
                case NORMAL_RET_CALLEE: {
                    for (NormalStatement normalStatement : this.computeReturnStatements(iR)) {
                        this.delegate.addEdge(normalStatement, (Statement)object5);
                    }
                    continue block10;
                }
                case EXC_RET_CALLEE: {
                    if (this.dOptions.isIgnoreExceptions()) {
                        Assertions.UNREACHABLE();
                    }
                    IntIterator intIterator = this.getPEIs(iR).intIterator();
                    while (intIterator.hasNext()) {
                        int n = intIterator.next();
                        SSAInstruction sSAInstruction = iR.getInstructions()[n];
                        if (this.dOptions.isTerminateAtCast() && sSAInstruction instanceof SSACheckCastInstruction) continue;
                        if (sSAInstruction instanceof SSAAbstractInvokeInstruction) {
                            ExceptionalReturnCaller exceptionalReturnCaller = new ExceptionalReturnCaller(this.node, n);
                            this.delegate.addEdge(exceptionalReturnCaller, (Statement)object5);
                            continue;
                        }
                        this.delegate.addEdge(new NormalStatement(this.node, n), (Statement)object5);
                    }
                    continue block10;
                }
                case PARAM_CALLER: {
                    ParamCaller paramCaller = (ParamCaller)object5;
                    int n = paramCaller.getValueNumber();
                    if (n <= -1) continue block10;
                    if (iR.getSymbolTable().isParameter(n)) {
                        ParamCallee paramCallee = new ParamCallee(this.node, n);
                        this.delegate.addEdge(paramCallee, paramCaller);
                        break;
                    }
                    SSAInstruction sSAInstruction = defUse.getDef(n);
                    if (this.dOptions.isTerminateAtCast() && sSAInstruction instanceof SSACheckCastInstruction || sSAInstruction == null) continue block10;
                    if (sSAInstruction instanceof SSAAbstractInvokeInstruction) {
                        SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = (SSAAbstractInvokeInstruction)sSAInstruction;
                        if (n == sSAAbstractInvokeInstruction.getException()) {
                            object = new ExceptionalReturnCaller(this.node, map.get(sSAInstruction));
                            this.delegate.addEdge((Statement)object, paramCaller);
                            break;
                        }
                        object = new NormalReturnCaller(this.node, map.get(sSAInstruction));
                        this.delegate.addEdge((Statement)object, paramCaller);
                        break;
                    }
                    Statement statement = this.ssaInstruction2Statement(sSAInstruction, iR, map);
                    this.delegate.addEdge(statement, paramCaller);
                    break;
                }
                case HEAP_PARAM_CALLER: 
                case HEAP_PARAM_CALLEE: 
                case HEAP_RET_CALLER: 
                case HEAP_RET_CALLEE: 
                case METHOD_ENTRY: 
                case METHOD_EXIT: {
                    break;
                }
                default: {
                    Assertions.UNREACHABLE(((Statement)object5).toString());
                }
            }
        }
    }

    private void createHeapDataDependenceEdges(final PointerKey pointerKey) {
        if (this.locationsHandled.contains(pointerKey)) {
            return;
        }
        this.locationsHandled.add(pointerKey);
        if (this.dOptions.isIgnoreHeap() || this.exclusions != null && this.exclusions.excludes(pointerKey)) {
            return;
        }
        TypeReference typeReference = HeapExclusions.getType(pointerKey);
        if (typeReference == null) {
            return;
        }
        IR iR = this.node.getIR();
        if (iR == null) {
            return;
        }
        Filter filter = new Filter(){

            public boolean accepts(Object object) {
                if (object instanceof HeapStatement) {
                    HeapStatement heapStatement = (HeapStatement)object;
                    return heapStatement.getLocation().equals(pointerKey);
                }
                return true;
            }
        };
        Iterator2Set<Statement> iterator2Set = Iterator2Collection.toSet(new FilterIterator(this.iterator(), filter));
        Map<Statement, OrdinalSet<Statement>> map = new HeapReachingDefs(this.modRef).computeReachingDefs(this.node, iR, this.pa, this.mod, iterator2Set, new HeapExclusions(SetComplement.complement(new SingletonSet(typeReference))), this.cg);
        block6: for (Statement statement : map.keySet()) {
            switch (statement.getKind()) {
                case NORMAL: 
                case PHI: 
                case PI: 
                case CATCH: {
                    OrdinalSet<Statement> ordinalSet = map.get(statement);
                    if (ordinalSet == null) continue block6;
                    for (Statement statement2 : ordinalSet) {
                        this.delegate.addEdge(statement2, statement);
                    }
                    continue block6;
                }
                case PARAM_CALLER: 
                case PARAM_CALLEE: 
                case NORMAL_RET_CALLER: 
                case NORMAL_RET_CALLEE: 
                case EXC_RET_CALLER: 
                case EXC_RET_CALLEE: {
                    break;
                }
                case HEAP_PARAM_CALLER: 
                case HEAP_RET_CALLER: 
                case HEAP_RET_CALLEE: {
                    OrdinalSet<Statement> ordinalSet = map.get(statement);
                    if (ordinalSet == null) continue block6;
                    for (Statement statement2 : ordinalSet) {
                        this.delegate.addEdge(statement2, statement);
                    }
                    continue block6;
                }
                case HEAP_PARAM_CALLEE: 
                case METHOD_ENTRY: 
                case METHOD_EXIT: {
                    break;
                }
                default: {
                    Assertions.UNREACHABLE(statement.toString());
                }
            }
        }
    }

    private boolean hasBasePointer(SSAInstruction sSAInstruction) {
        if (sSAInstruction instanceof SSAFieldAccessInstruction) {
            SSAFieldAccessInstruction sSAFieldAccessInstruction = (SSAFieldAccessInstruction)sSAInstruction;
            return !sSAFieldAccessInstruction.isStatic();
        }
        if (sSAInstruction instanceof SSAArrayReferenceInstruction) {
            return true;
        }
        return sSAInstruction instanceof SSAArrayLengthInstruction;
    }

    private int getBasePointer(SSAInstruction sSAInstruction) {
        if (sSAInstruction instanceof SSAFieldAccessInstruction) {
            SSAFieldAccessInstruction sSAFieldAccessInstruction = (SSAFieldAccessInstruction)sSAInstruction;
            return sSAFieldAccessInstruction.getRef();
        }
        if (sSAInstruction instanceof SSAArrayReferenceInstruction) {
            SSAArrayReferenceInstruction sSAArrayReferenceInstruction = (SSAArrayReferenceInstruction)sSAInstruction;
            return sSAArrayReferenceInstruction.getArrayRef();
        }
        if (sSAInstruction instanceof SSAArrayLengthInstruction) {
            SSAArrayLengthInstruction sSAArrayLengthInstruction = (SSAArrayLengthInstruction)sSAInstruction;
            return sSAArrayLengthInstruction.getArrayRef();
        }
        Assertions.UNREACHABLE("BOOM");
        return -1;
    }

    private Collection<NormalStatement> computeReturnStatements(final IR iR) {
        Filter filter = new Filter(){

            public boolean accepts(Object object) {
                if (object instanceof NormalStatement) {
                    NormalStatement normalStatement = (NormalStatement)object;
                    SSAInstruction sSAInstruction = iR.getInstructions()[normalStatement.getInstructionIndex()];
                    return sSAInstruction instanceof SSAReturnInstruction;
                }
                return false;
            }
        };
        return Iterator2Collection.toSet(new FilterIterator(this.iterator(), filter));
    }

    private IntSet getPEIs(IR iR) {
        BitVectorIntSet bitVectorIntSet = new BitVectorIntSet();
        int n = 0;
        while (n < iR.getInstructions().length) {
            if (iR.getInstructions()[n] != null && iR.getInstructions()[n].isPEI()) {
                bitVectorIntSet.add(n);
            }
            ++n;
        }
        return bitVectorIntSet;
    }

    private Statement ssaInstruction2Statement(SSAInstruction sSAInstruction, IR iR, Map<SSAInstruction, Integer> map) {
        return PDG.ssaInstruction2Statement(this.node, sSAInstruction, map, iR);
    }

    public static synchronized Statement ssaInstruction2Statement(CGNode cGNode, SSAInstruction sSAInstruction, Map<SSAInstruction, Integer> map, IR iR) {
        if (cGNode == null) {
            throw new IllegalArgumentException("null node");
        }
        if (sSAInstruction == null) {
            throw new IllegalArgumentException("null s");
        }
        if (sSAInstruction instanceof SSAPhiInstruction) {
            SSAPhiInstruction sSAPhiInstruction = (SSAPhiInstruction)sSAInstruction;
            return new PhiStatement(cGNode, sSAPhiInstruction);
        }
        if (sSAInstruction instanceof SSAPiInstruction) {
            SSAPiInstruction sSAPiInstruction = (SSAPiInstruction)sSAInstruction;
            return new PiStatement(cGNode, sSAPiInstruction);
        }
        if (sSAInstruction instanceof SSAGetCaughtExceptionInstruction) {
            return new GetCaughtExceptionStatement(cGNode, (SSAGetCaughtExceptionInstruction)sSAInstruction);
        }
        Integer n = map.get(sSAInstruction);
        if (n == null) {
            Assertions.UNREACHABLE(String.valueOf(sSAInstruction.toString()) + "\nnot found in map of\n" + iR);
        }
        return new NormalStatement(cGNode, n);
    }

    public static Map<SSAInstruction, Integer> computeInstructionIndices(IR iR) {
        HashMap<SSAInstruction, Integer> hashMap = HashMapFactory.make();
        if (iR != null) {
            SSAInstruction[] sSAInstructionArray = iR.getInstructions();
            int n = 0;
            while (n < sSAInstructionArray.length) {
                SSAInstruction sSAInstruction = sSAInstructionArray[n];
                if (sSAInstruction != null) {
                    hashMap.put(sSAInstruction, new Integer(n));
                }
                ++n;
            }
        }
        return hashMap;
    }

    private SSAInstruction statement2SSAInstruction(SSAInstruction[] sSAInstructionArray, Statement statement) {
        SSAInstruction sSAInstruction = null;
        switch (statement.getKind()) {
            case NORMAL: {
                NormalStatement normalStatement = (NormalStatement)statement;
                sSAInstruction = sSAInstructionArray[normalStatement.getInstructionIndex()];
                break;
            }
            case PHI: {
                PhiStatement phiStatement = (PhiStatement)statement;
                sSAInstruction = phiStatement.getPhi();
                break;
            }
            case PI: {
                PiStatement piStatement = (PiStatement)statement;
                sSAInstruction = piStatement.getPi();
                break;
            }
            case CATCH: {
                GetCaughtExceptionStatement getCaughtExceptionStatement = (GetCaughtExceptionStatement)statement;
                sSAInstruction = getCaughtExceptionStatement.getInstruction();
                break;
            }
            default: {
                Assertions.UNREACHABLE(statement.toString());
            }
        }
        return sSAInstruction;
    }

    private void createNodes(Map<CGNode, OrdinalSet<PointerKey>> map, Slicer.ControlDependenceOptions controlDependenceOptions, IR iR) {
        if (iR != null) {
            this.createNormalStatements(iR, map);
            this.createSpecialStatements(iR);
        }
        this.createCalleeParams();
        this.createReturnStatements();
        this.delegate.addNode(new MethodEntryStatement(this.node));
        this.delegate.addNode(new MethodExitStatement(this.node));
    }

    private void createReturnStatements() {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        if (!this.node.getMethod().getReturnType().equals(TypeReference.Void)) {
            NormalReturnCallee object2 = new NormalReturnCallee(this.node);
            this.delegate.addNode(object2);
            arrayList.add(object2);
        }
        if (!this.dOptions.isIgnoreExceptions()) {
            ExceptionalReturnCallee exceptionalReturnCallee = new ExceptionalReturnCallee(this.node);
            this.delegate.addNode(exceptionalReturnCallee);
            arrayList.add(exceptionalReturnCallee);
        }
        if (!this.dOptions.isIgnoreHeap()) {
            for (PointerKey pointerKey : this.mod.get(this.node)) {
                HeapStatement.HeapReturnCallee heapReturnCallee = new HeapStatement.HeapReturnCallee(this.node, pointerKey);
                this.delegate.addNode(heapReturnCallee);
                arrayList.add(heapReturnCallee);
            }
        }
        this.returnStatements = new Statement[arrayList.size()];
        arrayList.toArray(this.returnStatements);
    }

    private void createCalleeParams() {
        if (this.paramCalleeStatements == null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 1;
            while (n <= this.node.getMethod().getNumberOfParameters()) {
                ParamCallee paramCallee = new ParamCallee(this.node, n);
                this.delegate.addNode(paramCallee);
                arrayList.add(paramCallee);
                ++n;
            }
            if (!this.dOptions.isIgnoreHeap()) {
                for (PointerKey pointerKey : this.ref.get(this.node)) {
                    HeapStatement.HeapParamCallee heapParamCallee = new HeapStatement.HeapParamCallee(this.node, pointerKey);
                    this.delegate.addNode(heapParamCallee);
                    arrayList.add(heapParamCallee);
                }
            }
            this.paramCalleeStatements = new Statement[arrayList.size()];
            arrayList.toArray(this.paramCalleeStatements);
        }
    }

    private void createSpecialStatements(IR iR) {
        Iterator<SSAInstruction> iterator = iR.iterateAllInstructions();
        while (iterator.hasNext()) {
            SSAInstruction sSAInstruction = iterator.next();
            if (sSAInstruction instanceof SSAPhiInstruction) {
                this.delegate.addNode(new PhiStatement(this.node, (SSAPhiInstruction)sSAInstruction));
                continue;
            }
            if (sSAInstruction instanceof SSAGetCaughtExceptionInstruction) {
                this.delegate.addNode(new GetCaughtExceptionStatement(this.node, (SSAGetCaughtExceptionInstruction)sSAInstruction));
                continue;
            }
            if (!(sSAInstruction instanceof SSAPiInstruction)) continue;
            this.delegate.addNode(new PiStatement(this.node, (SSAPiInstruction)sSAInstruction));
        }
    }

    private void createNormalStatements(IR iR, Map<CGNode, OrdinalSet<PointerKey>> map) {
        SSAInstruction[] sSAInstructionArray = iR.getInstructions();
        int n = 0;
        while (n < sSAInstructionArray.length) {
            SSAInstruction sSAInstruction = sSAInstructionArray[n];
            if (!(sSAInstruction instanceof SSAGetCaughtExceptionInstruction) && sSAInstruction != null) {
                NormalStatement normalStatement = new NormalStatement(this.node, n);
                this.delegate.addNode(normalStatement);
                if (sSAInstruction instanceof SSAAbstractInvokeInstruction) {
                    this.callSite2Statement.put(((SSAAbstractInvokeInstruction)sSAInstruction).getCallSite(), normalStatement);
                    this.addParamPassingStatements(n, map, iR);
                }
            }
            ++n;
        }
    }

    private void addParamPassingStatements(int n, Map<CGNode, OrdinalSet<PointerKey>> map, IR iR) {
        SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = (SSAAbstractInvokeInstruction)iR.getInstructions()[n];
        Set<Statement> set = MapUtil.findOrCreateSet(this.callerParamStatements, sSAAbstractInvokeInstruction.getCallSite());
        Set<Statement> set2 = MapUtil.findOrCreateSet(this.callerReturnStatements, sSAAbstractInvokeInstruction.getCallSite());
        int n2 = 0;
        while (n2 < sSAAbstractInvokeInstruction.getNumberOfUses()) {
            ParamCaller ordinalSet3 = new ParamCaller(this.node, n, sSAAbstractInvokeInstruction.getUse(n2));
            this.delegate.addNode(ordinalSet3);
            set.add(ordinalSet3);
            ++n2;
        }
        if (!sSAAbstractInvokeInstruction.getDeclaredResultType().equals(TypeReference.Void)) {
            NormalReturnCaller normalReturnCaller = new NormalReturnCaller(this.node, n);
            this.delegate.addNode(normalReturnCaller);
            set2.add(normalReturnCaller);
        }
        if (!this.dOptions.isIgnoreExceptions()) {
            ExceptionalReturnCaller exceptionalReturnCaller = new ExceptionalReturnCaller(this.node, n);
            this.delegate.addNode(exceptionalReturnCaller);
            set2.add(exceptionalReturnCaller);
        }
        if (!this.dOptions.isIgnoreHeap()) {
            OrdinalSet<PointerKey> ordinalSet2 = this.unionHeapLocations(this.cg, this.node, sSAAbstractInvokeInstruction, map);
            for (PointerKey pointerKey : ordinalSet2) {
                HeapStatement.HeapParamCaller heapParamCaller = new HeapStatement.HeapParamCaller(this.node, n, pointerKey);
                this.delegate.addNode(heapParamCaller);
                set.add(heapParamCaller);
            }
            OrdinalSet<PointerKey> ordinalSet = this.unionHeapLocations(this.cg, this.node, sSAAbstractInvokeInstruction, this.mod);
            for (PointerKey pointerKey : ordinalSet) {
                HeapStatement.HeapReturnCaller heapReturnCaller = new HeapStatement.HeapReturnCaller(this.node, n, pointerKey);
                this.delegate.addNode(heapReturnCaller);
                set2.add(heapReturnCaller);
            }
        }
    }

    private OrdinalSet<PointerKey> unionHeapLocations(CallGraph callGraph, CGNode cGNode, SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction, Map<CGNode, OrdinalSet<PointerKey>> map) {
        BitVectorIntSet bitVectorIntSet = new BitVectorIntSet();
        for (CGNode cGNode2 : callGraph.getPossibleTargets(cGNode, sSAAbstractInvokeInstruction.getCallSite())) {
            bitVectorIntSet.addAll(map.get(cGNode2).getBackingSet());
        }
        return new OrdinalSet<PointerKey>(bitVectorIntSet, map.get(cGNode).getMapping());
    }

    public String toString() {
        this.populate();
        StringBuffer stringBuffer = new StringBuffer("PDG for " + this.node + ":\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    public Statement[] getParamCalleeStatements() {
        if (this.paramCalleeStatements == null) {
            this.createCalleeParams();
        }
        Statement[] statementArray = new Statement[this.paramCalleeStatements.length];
        System.arraycopy(this.paramCalleeStatements, 0, statementArray, 0, statementArray.length);
        return statementArray;
    }

    public Statement[] getReturnStatements() {
        this.populate();
        Statement[] statementArray = new Statement[this.returnStatements.length];
        System.arraycopy(this.returnStatements, 0, statementArray, 0, statementArray.length);
        return statementArray;
    }

    public CGNode getCallGraphNode() {
        return this.node;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass().equals(object.getClass())) {
            return this.node.equals(((PDG)object).node);
        }
        return false;
    }

    public int hashCode() {
        return 103 * this.node.hashCode();
    }

    @Override
    public int getPredNodeCount(Statement statement) throws UnimplementedError {
        this.populate();
        Assertions.UNREACHABLE();
        return this.delegate.getPredNodeCount(statement);
    }

    @Override
    public Iterator<Statement> getPredNodes(Statement statement) {
        this.populate();
        if (!this.dOptions.isIgnoreHeap()) {
            this.computeIncomingHeapDependencies(statement);
        }
        return this.delegate.getPredNodes(statement);
    }

    private void computeIncomingHeapDependencies(Statement statement) {
        switch (statement.getKind()) {
            case NORMAL: {
                NormalStatement normalStatement = (NormalStatement)statement;
                if (this.ignoreAllocHeapDefs && normalStatement.getInstruction() instanceof SSANewInstruction) break;
                Set<PointerKey> set = this.modRef.getRef(this.node, this.heapModel, this.pa, normalStatement.getInstruction(), this.exclusions);
                for (PointerKey pointerKey : set) {
                    this.createHeapDataDependenceEdges(pointerKey);
                }
                break;
            }
            case HEAP_PARAM_CALLER: 
            case HEAP_PARAM_CALLEE: 
            case HEAP_RET_CALLER: 
            case HEAP_RET_CALLEE: {
                HeapStatement heapStatement = (HeapStatement)statement;
                this.createHeapDataDependenceEdges(heapStatement.getLocation());
            }
        }
    }

    private void computeOutgoingHeapDependencies(Statement statement) {
        switch (statement.getKind()) {
            case NORMAL: {
                NormalStatement normalStatement = (NormalStatement)statement;
                if (this.ignoreAllocHeapDefs && normalStatement.getInstruction() instanceof SSANewInstruction) break;
                Set<PointerKey> set = this.modRef.getMod(this.node, this.heapModel, this.pa, normalStatement.getInstruction(), this.exclusions);
                for (PointerKey pointerKey : set) {
                    this.createHeapDataDependenceEdges(pointerKey);
                }
                break;
            }
            case HEAP_PARAM_CALLER: 
            case HEAP_PARAM_CALLEE: 
            case HEAP_RET_CALLER: 
            case HEAP_RET_CALLEE: {
                HeapStatement heapStatement = (HeapStatement)statement;
                this.createHeapDataDependenceEdges(heapStatement.getLocation());
            }
        }
    }

    @Override
    public int getSuccNodeCount(Statement statement) throws UnimplementedError {
        this.populate();
        Assertions.UNREACHABLE();
        return this.delegate.getSuccNodeCount(statement);
    }

    @Override
    public Iterator<Statement> getSuccNodes(Statement statement) {
        this.populate();
        if (!this.dOptions.isIgnoreHeap()) {
            this.computeOutgoingHeapDependencies(statement);
        }
        return this.delegate.getSuccNodes(statement);
    }

    @Override
    public boolean hasEdge(Statement statement, Statement statement2) throws UnimplementedError {
        this.populate();
        return this.delegate.hasEdge(statement, statement2);
    }

    @Override
    public void removeNodeAndEdges(Statement statement) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    @Override
    public void addNode(Statement statement) {
        Assertions.UNREACHABLE();
    }

    @Override
    public boolean containsNode(Statement statement) {
        this.populate();
        return this.delegate.containsNode(statement);
    }

    @Override
    public int getNumberOfNodes() {
        this.populate();
        return this.delegate.getNumberOfNodes();
    }

    @Override
    public Iterator<Statement> iterator() {
        this.populate();
        return this.delegate.iterator();
    }

    @Override
    public void removeNode(Statement statement) {
        Assertions.UNREACHABLE();
    }

    @Override
    public void addEdge(Statement statement, Statement statement2) {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeAllIncidentEdges(Statement statement) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeEdge(Statement statement, Statement statement2) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeIncomingEdges(Statement statement) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeOutgoingEdges(Statement statement) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    @Override
    public int getMaxNumber() {
        this.populate();
        return this.delegate.getMaxNumber();
    }

    @Override
    public Statement getNode(int n) {
        this.populate();
        return (Statement)this.delegate.getNode(n);
    }

    @Override
    public int getNumber(Statement statement) {
        this.populate();
        return this.delegate.getNumber(statement);
    }

    @Override
    public Iterator<Statement> iterateNodes(IntSet intSet) {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getPredNodeNumbers(Statement statement) {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getSuccNodeNumbers(Statement statement) {
        Assertions.UNREACHABLE();
        return null;
    }

    private static class SetComplement
    extends SetOfClasses
    implements Serializable {
        private static final long serialVersionUID = -3256390509887654323L;
        private final SetOfClasses set;

        SetComplement(SetOfClasses setOfClasses) {
            this.set = setOfClasses;
        }

        static SetComplement complement(SetOfClasses setOfClasses) {
            return new SetComplement(setOfClasses);
        }

        public void add(IClass iClass) {
            Assertions.UNREACHABLE();
        }

        public boolean contains(String string) {
            Assertions.UNREACHABLE();
            return false;
        }

        public boolean contains(TypeReference typeReference) {
            return !this.set.contains(typeReference);
        }
    }

    private static class SingletonSet
    extends SetOfClasses
    implements Serializable {
        private static final long serialVersionUID = -3256390509887654324L;
        private final TypeReference t;

        SingletonSet(TypeReference typeReference) {
            this.t = typeReference;
        }

        public void add(IClass iClass) {
            Assertions.UNREACHABLE();
        }

        public boolean contains(String string) {
            Assertions.UNREACHABLE();
            return false;
        }

        public boolean contains(TypeReference typeReference) {
            return this.t.equals(typeReference);
        }
    }
}

