/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.modref;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.dataflow.graph.BitVectorSolver;
import com.ibm.wala.dataflow.graph.IKilldallFramework;
import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.modref.DelegatingExtendedHeapModel;
import com.ibm.wala.ipa.modref.ExtendedHeapModel;
import com.ibm.wala.ipa.modref.GenReach;
import com.ibm.wala.ipa.slicer.HeapExclusions;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModRef {
    public static ModRef make() {
        return new ModRef();
    }

    protected ModRef() {
    }

    public Map<CGNode, OrdinalSet<PointerKey>> computeMod(CallGraph callGraph, PointerAnalysis pointerAnalysis, HeapExclusions heapExclusions) {
        if (callGraph == null) {
            throw new IllegalArgumentException("cg is null");
        }
        Map<CGNode, Collection<PointerKey>> map = this.scanForMod(callGraph, pointerAnalysis, heapExclusions);
        return this.transitiveClosure(callGraph, map);
    }

    public Map<CGNode, OrdinalSet<PointerKey>> computeRef(CallGraph callGraph, PointerAnalysis pointerAnalysis, HeapExclusions heapExclusions) {
        if (callGraph == null) {
            throw new IllegalArgumentException("cg is null");
        }
        Map<CGNode, Collection<PointerKey>> map = this.scanForRef(callGraph, pointerAnalysis, heapExclusions);
        return this.transitiveClosure(callGraph, map);
    }

    public Map<CGNode, OrdinalSet<PointerKey>> computeMod(CallGraph callGraph, PointerAnalysis pointerAnalysis) {
        return this.computeMod(callGraph, pointerAnalysis, null);
    }

    public Map<CGNode, OrdinalSet<PointerKey>> computeRef(CallGraph callGraph, PointerAnalysis pointerAnalysis) {
        return this.computeRef(callGraph, pointerAnalysis, null);
    }

    private Map<CGNode, OrdinalSet<PointerKey>> transitiveClosure(CallGraph callGraph, Map<CGNode, Collection<PointerKey>> map) {
        try {
            GenReach<CGNode, PointerKey> genReach = new GenReach<CGNode, PointerKey>(GraphInverter.invert(callGraph), map);
            BitVectorSolver<CGNode> bitVectorSolver = new BitVectorSolver<CGNode>((IKilldallFramework<CGNode, BitVectorVariable>)genReach);
            bitVectorSolver.solve(null);
            HashMap<CGNode, OrdinalSet<PointerKey>> hashMap = HashMapFactory.make();
            for (CGNode cGNode : callGraph) {
                BitVectorVariable bitVectorVariable = (BitVectorVariable)bitVectorSolver.getOut(cGNode);
                hashMap.put(cGNode, new OrdinalSet(bitVectorVariable.getValue(), genReach.getLatticeValues()));
            }
            return hashMap;
        }
        catch (CancelException cancelException) {
            throw new CancelRuntimeException(cancelException);
        }
    }

    private Map<CGNode, Collection<PointerKey>> scanForMod(CallGraph callGraph, PointerAnalysis pointerAnalysis, HeapExclusions heapExclusions) {
        HashMap<CGNode, Collection<PointerKey>> hashMap = HashMapFactory.make();
        for (CGNode cGNode : callGraph) {
            hashMap.put(cGNode, this.scanNodeForMod(cGNode, pointerAnalysis, heapExclusions));
        }
        return hashMap;
    }

    private Map<CGNode, Collection<PointerKey>> scanForRef(CallGraph callGraph, PointerAnalysis pointerAnalysis, HeapExclusions heapExclusions) {
        HashMap<CGNode, Collection<PointerKey>> hashMap = HashMapFactory.make();
        for (CGNode cGNode : callGraph) {
            hashMap.put(cGNode, this.scanNodeForRef(cGNode, pointerAnalysis, heapExclusions));
        }
        return hashMap;
    }

    private Collection<PointerKey> scanNodeForMod(CGNode cGNode, PointerAnalysis pointerAnalysis, HeapExclusions heapExclusions) {
        Set<PointerKey> set = HashSetFactory.make();
        DelegatingExtendedHeapModel delegatingExtendedHeapModel = new DelegatingExtendedHeapModel(pointerAnalysis.getHeapModel());
        ModVisitor modVisitor = this.makeModVisitor(cGNode, set, pointerAnalysis, delegatingExtendedHeapModel);
        IR iR = cGNode.getIR();
        if (iR != null) {
            Iterator<SSAInstruction> iterator = iR.iterateNormalInstructions();
            while (iterator.hasNext()) {
                iterator.next().visit(modVisitor);
            }
        }
        if (heapExclusions != null) {
            set = heapExclusions.filter(set);
        }
        return set;
    }

    private Collection<PointerKey> scanNodeForRef(CGNode cGNode, PointerAnalysis pointerAnalysis, HeapExclusions heapExclusions) {
        Set<PointerKey> set = HashSetFactory.make();
        DelegatingExtendedHeapModel delegatingExtendedHeapModel = new DelegatingExtendedHeapModel(pointerAnalysis.getHeapModel());
        RefVisitor refVisitor = this.makeRefVisitor(cGNode, set, pointerAnalysis, delegatingExtendedHeapModel);
        IR iR = cGNode.getIR();
        if (iR != null) {
            Iterator<SSAInstruction> iterator = iR.iterateNormalInstructions();
            while (iterator.hasNext()) {
                iterator.next().visit(refVisitor);
            }
        }
        if (heapExclusions != null) {
            set = heapExclusions.filter(set);
        }
        return set;
    }

    protected ModVisitor makeModVisitor(CGNode cGNode, Collection<PointerKey> collection, PointerAnalysis pointerAnalysis, ExtendedHeapModel extendedHeapModel) {
        return this.makeModVisitor(cGNode, collection, pointerAnalysis, extendedHeapModel, false);
    }

    protected ModVisitor makeModVisitor(CGNode cGNode, Collection<PointerKey> collection, PointerAnalysis pointerAnalysis, ExtendedHeapModel extendedHeapModel, boolean bl) {
        return new ModVisitor(cGNode, collection, extendedHeapModel, pointerAnalysis, bl);
    }

    public Set<PointerKey> getMod(CGNode cGNode, ExtendedHeapModel extendedHeapModel, PointerAnalysis pointerAnalysis, SSAInstruction sSAInstruction, HeapExclusions heapExclusions) {
        return this.getMod(cGNode, extendedHeapModel, pointerAnalysis, sSAInstruction, heapExclusions, false);
    }

    public Set<PointerKey> getMod(CGNode cGNode, ExtendedHeapModel extendedHeapModel, PointerAnalysis pointerAnalysis, SSAInstruction sSAInstruction, HeapExclusions heapExclusions, boolean bl) {
        if (sSAInstruction == null) {
            throw new IllegalArgumentException("s is null");
        }
        HashSet<PointerKey> hashSet = HashSetFactory.make(2);
        ModVisitor modVisitor = this.makeModVisitor(cGNode, hashSet, pointerAnalysis, extendedHeapModel, bl);
        sSAInstruction.visit(modVisitor);
        return heapExclusions == null ? hashSet : heapExclusions.filter(hashSet);
    }

    protected RefVisitor makeRefVisitor(CGNode cGNode, Collection<PointerKey> collection, PointerAnalysis pointerAnalysis, ExtendedHeapModel extendedHeapModel) {
        return new RefVisitor(cGNode, collection, pointerAnalysis, extendedHeapModel);
    }

    public Set<PointerKey> getRef(CGNode cGNode, ExtendedHeapModel extendedHeapModel, PointerAnalysis pointerAnalysis, SSAInstruction sSAInstruction, HeapExclusions heapExclusions) {
        if (sSAInstruction == null) {
            throw new IllegalArgumentException("s is null");
        }
        HashSet<PointerKey> hashSet = HashSetFactory.make(2);
        RefVisitor refVisitor = this.makeRefVisitor(cGNode, hashSet, pointerAnalysis, extendedHeapModel);
        sSAInstruction.visit(refVisitor);
        return heapExclusions == null ? hashSet : heapExclusions.filter(hashSet);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ModVisitor
    extends SSAInstruction.Visitor {
        private final CGNode n;
        private final Collection<PointerKey> result;
        private final ExtendedHeapModel h;
        private final PointerAnalysis pa;
        private final boolean ignoreAllocHeapDefs;

        protected ModVisitor(CGNode cGNode, Collection<PointerKey> collection, ExtendedHeapModel extendedHeapModel, PointerAnalysis pointerAnalysis, boolean bl) {
            this.n = cGNode;
            this.result = collection;
            this.h = extendedHeapModel;
            this.pa = pointerAnalysis;
            this.ignoreAllocHeapDefs = bl;
        }

        @Override
        public void visitNew(SSANewInstruction sSANewInstruction) {
            block15: {
                InstanceKey instanceKey;
                block13: {
                    PointerKey pointerKey;
                    block14: {
                        if (!sSANewInstruction.getConcreteType().isArrayType()) break block13;
                        int n = sSANewInstruction.getConcreteType().getDimensionality();
                        if (n <= 1) break block14;
                        InstanceKey instanceKey2 = this.h.getInstanceKeyForAllocation(this.n, sSANewInstruction.getNewSite());
                        if (instanceKey2 != null) {
                            PointerKey pointerKey2 = this.h.getPointerKeyForArrayContents(instanceKey2);
                            assert (pointerKey2 != null);
                            this.result.add(pointerKey2);
                            pointerKey2 = this.h.getPointerKeyForArrayLength(instanceKey2);
                            assert (pointerKey2 != null);
                            this.result.add(pointerKey2);
                        }
                        int n2 = 0;
                        while (n2 < n - 1) {
                            InstanceKey instanceKey3 = this.h.getInstanceKeyForMultiNewArray(this.n, sSANewInstruction.getNewSite(), n2);
                            if (instanceKey3 != null) {
                                PointerKey pointerKey3 = this.h.getPointerKeyForArrayContents(instanceKey3);
                                assert (pointerKey3 != null);
                                this.result.add(pointerKey3);
                                pointerKey3 = this.h.getPointerKeyForArrayLength(instanceKey3);
                                assert (pointerKey3 != null);
                                this.result.add(pointerKey3);
                            }
                            ++n2;
                        }
                        break block15;
                    }
                    InstanceKey instanceKey4 = this.h.getInstanceKeyForAllocation(this.n, sSANewInstruction.getNewSite());
                    if (instanceKey4 == null) break block15;
                    if (!this.ignoreAllocHeapDefs) {
                        pointerKey = this.h.getPointerKeyForArrayContents(instanceKey4);
                        assert (pointerKey != null);
                        this.result.add(pointerKey);
                    }
                    pointerKey = this.h.getPointerKeyForArrayLength(instanceKey4);
                    assert (pointerKey != null);
                    this.result.add(pointerKey);
                    break block15;
                }
                if (!this.ignoreAllocHeapDefs && (instanceKey = this.h.getInstanceKeyForAllocation(this.n, sSANewInstruction.getNewSite())) != null) {
                    IClass iClass = instanceKey.getConcreteType();
                    for (IField iField : iClass.getAllInstanceFields()) {
                        PointerKey pointerKey = this.h.getPointerKeyForInstanceField(instanceKey, iField);
                        assert (pointerKey != null);
                        this.result.add(pointerKey);
                    }
                }
            }
        }

        @Override
        public void visitArrayStore(SSAArrayStoreInstruction sSAArrayStoreInstruction) {
            PointerKey pointerKey = this.h.getPointerKeyForLocal(this.n, sSAArrayStoreInstruction.getArrayRef());
            for (InstanceKey instanceKey : this.pa.getPointsToSet(pointerKey)) {
                this.result.add(this.h.getPointerKeyForArrayContents(instanceKey));
            }
        }

        @Override
        public void visitPut(SSAPutInstruction sSAPutInstruction) {
            IField iField = this.pa.getClassHierarchy().resolveField(sSAPutInstruction.getDeclaredField());
            if (iField != null) {
                if (sSAPutInstruction.isStatic()) {
                    this.result.add(this.h.getPointerKeyForStaticField(iField));
                } else {
                    PointerKey pointerKey = this.h.getPointerKeyForLocal(this.n, sSAPutInstruction.getRef());
                    if (pointerKey != null) {
                        for (InstanceKey instanceKey : this.pa.getPointsToSet(pointerKey)) {
                            this.result.add(this.h.getPointerKeyForInstanceField(instanceKey, iField));
                        }
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RefVisitor
    extends SSAInstruction.Visitor {
        private final CGNode n;
        private final Collection<PointerKey> result;
        private final PointerAnalysis pa;
        private final ExtendedHeapModel h;

        protected RefVisitor(CGNode cGNode, Collection<PointerKey> collection, PointerAnalysis pointerAnalysis, ExtendedHeapModel extendedHeapModel) {
            this.n = cGNode;
            this.result = collection;
            this.pa = pointerAnalysis;
            this.h = extendedHeapModel;
        }

        @Override
        public void visitArrayLength(SSAArrayLengthInstruction sSAArrayLengthInstruction) {
            PointerKey pointerKey = this.h.getPointerKeyForLocal(this.n, sSAArrayLengthInstruction.getArrayRef());
            for (InstanceKey instanceKey : this.pa.getPointsToSet(pointerKey)) {
                this.result.add(this.h.getPointerKeyForArrayLength(instanceKey));
            }
        }

        @Override
        public void visitArrayLoad(SSAArrayLoadInstruction sSAArrayLoadInstruction) {
            PointerKey pointerKey = this.h.getPointerKeyForLocal(this.n, sSAArrayLoadInstruction.getArrayRef());
            for (InstanceKey instanceKey : this.pa.getPointsToSet(pointerKey)) {
                this.result.add(this.h.getPointerKeyForArrayContents(instanceKey));
            }
        }

        @Override
        public void visitGet(SSAGetInstruction sSAGetInstruction) {
            IField iField = this.pa.getClassHierarchy().resolveField(sSAGetInstruction.getDeclaredField());
            if (iField != null) {
                if (sSAGetInstruction.isStatic()) {
                    this.result.add(this.h.getPointerKeyForStaticField(iField));
                } else {
                    PointerKey pointerKey = this.h.getPointerKeyForLocal(this.n, sSAGetInstruction.getRef());
                    for (InstanceKey instanceKey : this.pa.getPointsToSet(pointerKey)) {
                        this.result.add(this.h.getPointerKeyForInstanceField(instanceKey, iField));
                    }
                }
            }
        }
    }
}

