/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.cha;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.ClassLoaderFactoryImpl;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.CancelCHAConstructionException;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.ClassHierarchyWarning;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.MapIterator;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.functions.Function;
import com.ibm.wala.util.ref.CacheReference;
import com.ibm.wala.util.ref.ReferenceCleanser;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassHierarchy
implements IClassHierarchy {
    private static final boolean DEBUG = false;
    private final Set<Language> languages = HashSetFactory.make();
    private final Map<TypeReference, Node> map = new ConcurrentHashMap<TypeReference, Node>();
    private TypeReference rootTypeRef;
    private Node root;
    private final ClassLoaderFactory factory;
    private final IClassLoader[] loaders;
    private final HashMap<IClass, Object> targetCache = HashMapFactory.make();
    private final AnalysisScope scope;
    private final Map<IClass, Set<IClass>> implementors = HashMapFactory.make();
    private Collection<IClass> subclassesOfError;
    private Collection<TypeReference> subTypeRefsOfError;
    private Collection<IClass> runtimeExceptionClasses;
    private Collection<TypeReference> runtimeExceptionTypeRefs;
    private int nextNumber = 1;

    private Set<IClass> computeSuperclasses(IClass iClass) {
        HashSet<IClass> hashSet = HashSetFactory.make(3);
        for (iClass = iClass.getSuperclass(); iClass != null; iClass = iClass.getSuperclass()) {
            hashSet.add(iClass);
            if (iClass == null || !iClass.getReference().getName().equals(this.rootTypeRef.getName()) || iClass.getReference().getClassLoader().equals(this.rootTypeRef.getClassLoader())) continue;
            throw new IllegalStateException("class " + iClass + " is invalid, unexpected classloader");
        }
        return hashSet;
    }

    private ClassHierarchy(AnalysisScope analysisScope, ClassLoaderFactory classLoaderFactory, Language language, IProgressMonitor iProgressMonitor) throws ClassHierarchyException, IllegalArgumentException {
        this(analysisScope, classLoaderFactory, Collections.singleton(language), iProgressMonitor);
    }

    private ClassHierarchy(AnalysisScope analysisScope, ClassLoaderFactory classLoaderFactory, IProgressMonitor iProgressMonitor) throws ClassHierarchyException, IllegalArgumentException {
        this(analysisScope, classLoaderFactory, analysisScope.getLanguages(), iProgressMonitor);
    }

    private ClassHierarchy(AnalysisScope analysisScope, ClassLoaderFactory classLoaderFactory, Collection<Language> collection, IProgressMonitor iProgressMonitor) throws ClassHierarchyException, IllegalArgumentException {
        Warnings.clear();
        if (classLoaderFactory == null) {
            throw new IllegalArgumentException();
        }
        if (analysisScope.getLanguages().size() == 0) {
            throw new IllegalArgumentException("AnalysisScope must contain at least 1 language");
        }
        this.scope = analysisScope;
        this.factory = classLoaderFactory;
        HashSet hashSet = HashSetFactory.make();
        for (Language language : collection) {
            this.languages.add(language);
            this.languages.addAll(language.getDerivedLanguages());
            hashSet.add(language.getName());
        }
        for (Language language : this.languages) {
            if (language.getRootType() == null || language.getRootType() == this.rootTypeRef) continue;
            if (this.rootTypeRef != null) {
                throw new IllegalArgumentException("AnalysisScope must have only 1 root type: " + language.getRootType() + ", " + this.rootTypeRef);
            }
            this.rootTypeRef = language.getRootType();
        }
        try {
            try {
                int n = 0;
                for (ClassLoaderReference classLoaderReference : analysisScope.getLoaders()) {
                    if (!hashSet.contains(classLoaderReference.getLanguage())) continue;
                    ++n;
                }
                this.loaders = new IClassLoader[n];
                boolean bl = false;
                if (iProgressMonitor != null) {
                    iProgressMonitor.beginTask("Build Class Hierarchy", n);
                }
                for (ClassLoaderReference classLoaderReference : analysisScope.getLoaders()) {
                    if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                        throw new CancelCHAConstructionException();
                    }
                    if (!hashSet.contains(classLoaderReference.getLanguage())) continue;
                    IClassLoader iClassLoader = classLoaderFactory.getLoader(classLoaderReference, this, analysisScope);
                    this.loaders[++var7_11] = iClassLoader;
                    if (iProgressMonitor == null) continue;
                    iProgressMonitor.worked(1);
                }
                IClassLoader[] iClassLoaderArray = this.loaders;
                int n2 = this.loaders.length;
                int n3 = 0;
                while (n3 < n2) {
                    IClassLoader iClassLoader = iClassLoaderArray[n3];
                    this.addAllClasses(iClassLoader, iProgressMonitor);
                    if (iProgressMonitor != null) {
                        iProgressMonitor.worked(1);
                    }
                    ++n3;
                }
            }
            catch (IOException iOException) {
                throw new ClassHierarchyException("factory.getLoader failed " + iOException);
            }
        }
        finally {
            if (iProgressMonitor != null) {
                iProgressMonitor.done();
            }
        }
        if (this.root == null) {
            throw new ClassHierarchyException("failed to load root " + this.rootTypeRef + " of class hierarchy");
        }
        this.numberTree();
        ReferenceCleanser.registerClassHierarchy(this);
    }

    private void addAllClasses(IClassLoader iClassLoader, IProgressMonitor iProgressMonitor) throws CancelCHAConstructionException {
        HashSet<IClass> hashSet = HashSetFactory.make();
        Iterator<IClass> iterator = iClassLoader.iterateAllClasses();
        while (iterator.hasNext()) {
            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                throw new CancelCHAConstructionException();
            }
            IClass iClass = iterator.next();
            boolean bl = this.addClass(iClass);
            if (bl) continue;
            hashSet.add(iClass);
        }
        iClassLoader.removeAll(hashSet);
    }

    @Override
    public boolean addClass(IClass iClass) {
        Collection<IClass> collection;
        Set<IClass> set;
        if (iClass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        if (iClass.getReference().getName().equals(this.rootTypeRef.getName()) && !iClass.getReference().getClassLoader().equals(this.rootTypeRef.getClassLoader())) {
            throw new IllegalArgumentException("class " + iClass + " is invalid, unexpected classloader");
        }
        try {
            set = this.computeSuperclasses(iClass);
            collection = iClass.getAllImplementedInterfaces();
        }
        catch (Exception exception) {
            if (iClass instanceof ShrikeClass) {
                // empty if block
            }
            Warnings.add(ClassExclusion.create(iClass.getReference(), exception.getMessage()));
            return false;
        }
        Node node = this.findOrCreateNode(iClass);
        if (iClass.getReference().equals(this.rootTypeRef)) {
            assert (this.root == null);
            this.root = node;
        }
        HashSet<IClass> hashSet = HashSetFactory.make(set);
        while (node != null) {
            IClass iClass2 = node.getJavaClass();
            IClass iClass3 = null;
            iClass3 = iClass2.getSuperclass();
            if (iClass3 != null) {
                hashSet.remove(iClass3);
                Node node2 = this.findOrCreateNode(iClass3);
                node2.addChild(node);
                if (node2.getJavaClass().getReference().equals(this.rootTypeRef)) {
                    node = null;
                    continue;
                }
                node = node2;
                continue;
            }
            node = null;
        }
        if (collection != null) {
            for (IClass iClass3 : collection) {
                try {
                    this.computeSuperclasses(iClass3);
                }
                catch (IllegalStateException illegalStateException) {
                    Warnings.add(ClassExclusion.create(iClass3.getReference(), illegalStateException.getMessage()));
                    continue;
                }
                if (!iClass3.isInterface()) assert (false) : "not an interface: " + iClass3;
                this.recordImplements(iClass, iClass3);
            }
        }
        return true;
    }

    private void recordImplements(IClass iClass, IClass iClass2) {
        Set<IClass> set = MapUtil.findOrCreateSet(this.implementors, iClass2);
        set.add(iClass);
    }

    @Override
    public Collection<IMethod> getPossibleTargets(MethodReference methodReference) {
        IClassLoader iClassLoader;
        if (methodReference == null) {
            throw new IllegalArgumentException("ref is null");
        }
        try {
            iClassLoader = this.factory.getLoader(methodReference.getDeclaringClass().getClassLoader(), this, this.scope);
        }
        catch (IOException iOException) {
            throw new UnimplementedError("factory.getLoader failed " + iOException);
        }
        IClass iClass = iClassLoader.lookupClass(methodReference.getDeclaringClass().getName());
        if (iClass == null) {
            return Collections.emptySet();
        }
        HashSet<IMethod> hashSet = HashSetFactory.make();
        hashSet.addAll(this.findOrCreateTargetSet(iClass, methodReference));
        return hashSet;
    }

    private Set<IMethod> findOrCreateTargetSet(IClass iClass, MethodReference methodReference) {
        Set<IMethod> set;
        HashMap<MethodReference, Set<IMethod>> hashMap = (HashMap<MethodReference, Set<IMethod>>)CacheReference.get(this.targetCache.get(iClass));
        if (hashMap == null) {
            hashMap = HashMapFactory.make(3);
            this.targetCache.put(iClass, CacheReference.make(hashMap));
        }
        if ((set = (Set<IMethod>)hashMap.get(methodReference)) == null) {
            set = this.getPossibleTargets(iClass, methodReference);
            hashMap.put(methodReference, set);
        }
        return set;
    }

    @Override
    public Set<IMethod> getPossibleTargets(IClass iClass, MethodReference methodReference) {
        if (methodReference.getName().equals(MethodReference.initAtom)) {
            IMethod iMethod = this.resolveMethod(methodReference);
            assert (iMethod != null);
            return Collections.singleton(iMethod);
        }
        if (iClass.isInterface()) {
            HashSet<IMethod> hashSet = HashSetFactory.make(3);
            Set<IClass> set = this.implementors.get(iClass);
            if (set == null) {
                return Collections.emptySet();
            }
            for (IClass iClass2 : set) {
                if (iClass2.isInterface() || iClass2.isAbstract()) continue;
                hashSet.addAll(this.computeTargetsNotInterface(methodReference, iClass2));
            }
            return hashSet;
        }
        return this.computeTargetsNotInterface(methodReference, iClass);
    }

    private Set<IMethod> computeTargetsNotInterface(MethodReference methodReference, IClass iClass) {
        Node node = this.findNode(iClass);
        HashSet<IMethod> hashSet = HashSetFactory.make(3);
        if (node == null) {
            return hashSet;
        }
        Selector selector = methodReference.getSelector();
        IMethod iMethod = this.resolveMethod(iClass, selector);
        if (iMethod != null) {
            hashSet.add(iMethod);
        }
        hashSet.addAll(this.computeOverriders(node, selector));
        return hashSet;
    }

    @Override
    public IMethod resolveMethod(MethodReference methodReference) {
        if (methodReference == null) {
            throw new IllegalArgumentException("m is null");
        }
        IClass iClass = this.lookupClass(methodReference.getDeclaringClass());
        if (iClass == null) {
            return null;
        }
        Selector selector = methodReference.getSelector();
        return this.resolveMethod(iClass, selector);
    }

    @Override
    public IField resolveField(FieldReference fieldReference) {
        if (fieldReference == null) {
            throw new IllegalArgumentException("f is null");
        }
        IClass iClass = this.lookupClass(fieldReference.getDeclaringClass());
        if (iClass == null) {
            return null;
        }
        return this.resolveField(iClass, fieldReference);
    }

    @Override
    public IField resolveField(IClass iClass, FieldReference fieldReference) {
        if (iClass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        if (fieldReference == null) {
            throw new IllegalArgumentException("f is null");
        }
        return iClass.getField(fieldReference.getName());
    }

    @Override
    public IMethod resolveMethod(IClass iClass, Selector selector) {
        if (iClass == null) {
            throw new IllegalArgumentException("receiverClass is null");
        }
        IMethod iMethod = this.findMethod(iClass, selector);
        if (iMethod != null) {
            return iMethod;
        }
        IClass iClass2 = null;
        iClass2 = iClass.getSuperclass();
        if (iClass2 == null) {
            return null;
        }
        return this.resolveMethod(iClass2, selector);
    }

    private IMethod findMethod(IClass iClass, Selector selector) {
        return iClass.getMethod(selector);
    }

    private Set<IMethod> computeOverriders(Node node, Selector selector) {
        HashSet<IMethod> hashSet = HashSetFactory.make(3);
        Iterator<Node> iterator = node.getChildren();
        while (iterator.hasNext()) {
            Node node2 = iterator.next();
            IMethod iMethod = this.findMethod(node2.getJavaClass(), selector);
            if (iMethod != null) {
                hashSet.add(iMethod);
            }
            hashSet.addAll(this.computeOverriders(node2, selector));
        }
        return hashSet;
    }

    private Node findNode(IClass iClass) {
        return this.map.get(iClass.getReference());
    }

    private Node findOrCreateNode(IClass iClass) {
        Node node = this.map.get(iClass.getReference());
        if (node == null) {
            node = new Node(iClass);
            this.map.put(iClass.getReference(), node);
        }
        return node;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        this.recursiveStringify(this.root, stringBuffer);
        return stringBuffer.toString();
    }

    private void recursiveStringify(Node node, StringBuffer stringBuffer) {
        stringBuffer.append(node.toString()).append("\n");
        Iterator<Node> iterator = node.getChildren();
        while (iterator.hasNext()) {
            Node node2 = iterator.next();
            this.recursiveStringify(node2, stringBuffer);
        }
    }

    private void numberTree() {
        assert (this.root != null);
        this.visitForNumbering(this.root);
    }

    private void visitForNumbering(Node node) {
        node.left = this.nextNumber++;
        for (Node node2 : node.children) {
            this.visitForNumbering(node2);
        }
        node.right = this.nextNumber++;
    }

    @Override
    public ClassLoaderFactory getFactory() {
        return this.factory;
    }

    @Override
    public IClass getLeastCommonSuperclass(IClass iClass, IClass iClass2) {
        Set<IClass> set;
        assert (iClass.getClassLoader().getLanguage().equals(iClass2.getClassLoader().getLanguage()));
        Language language = iClass.getClassLoader().getLanguage();
        if (iClass == null) {
            // empty if block
        }
        TypeReference typeReference = iClass.getReference();
        if (iClass.equals(iClass2)) {
            return iClass;
        }
        if (typeReference.equals(TypeReference.Null)) {
            return iClass2;
        }
        if (iClass2.getReference().equals(TypeReference.Null)) {
            return iClass;
        }
        if (iClass2.getReference().equals(language.getRootType())) {
            return iClass2;
        }
        Node node = this.map.get(iClass2.getReference());
        if (node == null) assert (node != null) : "null n for " + iClass2;
        try {
            set = this.getSuperclasses(iClass2);
        }
        catch (ClassHierarchyException classHierarchyException) {
            classHierarchyException.printStackTrace();
            Assertions.UNREACHABLE();
            set = null;
        }
        while (iClass != null) {
            if (set.contains(iClass)) {
                return iClass;
            }
            iClass = iClass.getSuperclass();
        }
        Assertions.UNREACHABLE("getLeastCommonSuperclass " + typeReference + " " + iClass2);
        return null;
    }

    private Set<IClass> getSuperclasses(IClass iClass) throws ClassHierarchyException {
        HashSet<IClass> hashSet = HashSetFactory.make(3);
        while (iClass.getSuperclass() != null) {
            hashSet.add(iClass.getSuperclass());
            iClass = iClass.getSuperclass();
        }
        return hashSet;
    }

    @Override
    public TypeReference getLeastCommonSuperclass(TypeReference typeReference, TypeReference typeReference2) {
        if (typeReference == null) {
            throw new IllegalArgumentException("a is null");
        }
        if (typeReference.equals(typeReference2)) {
            return typeReference;
        }
        IClass iClass = this.lookupClass(typeReference);
        IClass iClass2 = this.lookupClass(typeReference2);
        if (iClass == null || iClass2 == null) {
            if (iClass != null) {
                return iClass.getClassLoader().getLanguage().getRootType();
            }
            if (iClass2 != null) {
                return iClass2.getClassLoader().getLanguage().getRootType();
            }
            return this.getRootClass().getReference();
        }
        return this.getLeastCommonSuperclass(iClass, iClass2).getReference();
    }

    @Override
    public IClass lookupClass(TypeReference typeReference) {
        Object object;
        IClass iClass;
        if (typeReference == null) {
            throw new IllegalArgumentException("a is null");
        }
        ClassLoaderReference classLoaderReference = typeReference.getClassLoader();
        ClassLoaderReference classLoaderReference2 = classLoaderReference.getParent();
        if (classLoaderReference2 != null && (iClass = this.lookupClass((TypeReference)(object = TypeReference.findOrCreate(classLoaderReference2, typeReference.getName())))) != null) {
            return iClass;
        }
        if (typeReference.isArrayType()) {
            object = typeReference.getInnermostElementType();
            if (((TypeReference)object).isPrimitiveType()) {
                return this.getRootClass().getClassLoader().lookupClass(typeReference.getName());
            }
            iClass = this.lookupClass((TypeReference)object);
            if (iClass == null) {
                return null;
            }
            return iClass.getClassLoader().lookupClass(typeReference.getName());
        }
        object = this.map.get(typeReference);
        if (object != null) {
            return ((Node)object).klass;
        }
        return null;
    }

    private boolean slowIsSubclass(IClass iClass, IClass iClass2) {
        if (iClass == iClass2) {
            return true;
        }
        IClass iClass3 = iClass.getSuperclass();
        if (iClass3 == null) {
            return false;
        }
        return this.slowIsSubclass(iClass3, iClass2);
    }

    @Override
    public boolean isSubclassOf(IClass iClass, IClass iClass2) {
        if (iClass == null) {
            throw new IllegalArgumentException("c is null");
        }
        assert (iClass2 != null) : "null T";
        if (iClass.isArrayClass()) {
            if (iClass2.getReference() == TypeReference.JavaLangObject) {
                return true;
            }
            if (iClass2.getReference().isArrayType()) {
                TypeReference typeReference = iClass2.getReference().getArrayElementType();
                if (typeReference.isPrimitiveType()) {
                    return typeReference.equals(iClass.getReference().getArrayElementType());
                }
                IClass iClass3 = this.lookupClass(typeReference);
                if (iClass3 == null) {
                    Warnings.add(ClassHierarchyWarning.create("could not find " + typeReference));
                    return false;
                }
                IClass iClass4 = ((ArrayClass)iClass).getElementClass();
                if (iClass4 == null) {
                    return false;
                }
                if (iClass3.isInterface()) {
                    return this.implementsInterface(iClass4, iClass3);
                }
                return this.isSubclassOf(iClass4, iClass3);
            }
            return false;
        }
        if (iClass2.getReference().isArrayType()) {
            return false;
        }
        if (iClass.getReference().equals(iClass2.getReference())) {
            return true;
        }
        Node node = this.map.get(iClass.getReference());
        if (node == null) {
            return false;
        }
        Node node2 = this.map.get(iClass2.getReference());
        if (node2 == null) {
            return false;
        }
        if (node.left == -1) {
            return this.slowIsSubclass(iClass, iClass2);
        }
        if (node2.left == -1) {
            return this.slowIsSubclass(iClass, iClass2);
        }
        return node2.left <= node.left && node.left <= node2.right;
    }

    @Override
    public boolean implementsInterface(IClass iClass, IClass iClass2) {
        if (iClass2 == null) {
            throw new IllegalArgumentException("Cannot ask implementsInterface with i == null");
        }
        if (iClass == null) {
            throw new IllegalArgumentException("Cannot ask implementsInterface with c == null");
        }
        if (!iClass2.isInterface()) {
            return false;
        }
        if (iClass.equals(iClass2)) {
            return true;
        }
        if (iClass.isArrayClass()) {
            return iClass2.equals(this.lookupClass(TypeReference.JavaLangCloneable)) || iClass2.equals(this.lookupClass(TypeReference.JavaIoSerializable));
        }
        Set<IClass> set = this.implementors.get(iClass2);
        return set != null && set.contains(iClass);
    }

    @Override
    public Collection<IClass> computeSubClasses(TypeReference typeReference) {
        IClass iClass = this.lookupClass(typeReference);
        if (iClass == null) {
            throw new IllegalArgumentException("could not find class for TypeReference " + typeReference);
        }
        if (iClass.getReference().equals(TypeReference.JavaLangError)) {
            if (this.subclassesOfError == null) {
                this.subclassesOfError = this.computeSubClassesInternal(iClass);
            }
            return this.subclassesOfError;
        }
        if (iClass.getReference().equals(TypeReference.JavaLangRuntimeException)) {
            if (this.runtimeExceptionClasses == null) {
                this.runtimeExceptionClasses = this.computeSubClassesInternal(iClass);
            }
            return this.runtimeExceptionClasses;
        }
        return this.computeSubClassesInternal(iClass);
    }

    @Override
    public Collection<TypeReference> getJavaLangErrorTypes() {
        if (this.subTypeRefsOfError == null) {
            this.computeSubClasses(TypeReference.JavaLangError);
            this.subTypeRefsOfError = HashSetFactory.make(this.subclassesOfError.size());
            for (IClass iClass : this.subclassesOfError) {
                this.subTypeRefsOfError.add(iClass.getReference());
            }
        }
        return Collections.unmodifiableCollection(this.subTypeRefsOfError);
    }

    @Override
    public Collection<TypeReference> getJavaLangRuntimeExceptionTypes() {
        if (this.runtimeExceptionTypeRefs == null) {
            this.computeSubClasses(TypeReference.JavaLangRuntimeException);
            this.runtimeExceptionTypeRefs = HashSetFactory.make(this.runtimeExceptionClasses.size());
            for (IClass iClass : this.runtimeExceptionClasses) {
                this.runtimeExceptionTypeRefs.add(iClass.getReference());
            }
        }
        return Collections.unmodifiableCollection(this.runtimeExceptionTypeRefs);
    }

    private Set<IClass> computeSubClassesInternal(IClass iClass) {
        if (iClass.isArrayClass()) {
            return Collections.singleton(iClass);
        }
        Node node = this.findNode(iClass);
        assert (node != null) : "null node for class " + iClass;
        HashSet<IClass> hashSet = HashSetFactory.make(3);
        hashSet.add(iClass);
        Iterator<Node> iterator = node.getChildren();
        while (iterator.hasNext()) {
            Node node2 = iterator.next();
            hashSet.addAll(this.computeSubClasses(node2.klass.getReference()));
        }
        return hashSet;
    }

    @Override
    public boolean isInterface(TypeReference typeReference) {
        IClass iClass = this.lookupClass(typeReference);
        assert (iClass != null) : "Null lookup for " + typeReference;
        return iClass.isInterface();
    }

    @Override
    public Set<IClass> getImplementors(TypeReference typeReference) {
        IClass iClass = this.lookupClass(typeReference);
        Set<IClass> set = this.implementors.get(iClass);
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public Iterator<IClass> iterator() {
        Function<Node, IClass> function = new Function<Node, IClass>(){

            @Override
            public IClass apply(Node node) {
                return node.klass;
            }
        };
        return new MapIterator<Node, IClass>(this.map.values().iterator(), function);
    }

    @Override
    public int getNumberOfClasses() {
        return this.map.keySet().size();
    }

    @Override
    public IClassLoader[] getLoaders() {
        return this.loaders;
    }

    @Override
    public IClassLoader getLoader(ClassLoaderReference classLoaderReference) {
        int n = 0;
        while (n < this.loaders.length) {
            if (this.loaders[n].getReference().equals(classLoaderReference)) {
                return this.loaders[n];
            }
            ++n;
        }
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public AnalysisScope getScope() {
        return this.scope;
    }

    @Override
    public int getNumberOfImmediateSubclasses(IClass iClass) {
        if (iClass.isArrayClass()) {
            IClass iClass2 = this.getInnermostTypeOfArrayClass(iClass);
            return iClass2 == null ? 0 : this.getNumberOfImmediateSubclasses(iClass2);
        }
        Node node = this.findNode(iClass);
        return node.children.size();
    }

    @Override
    public Collection<IClass> getImmediateSubclasses(IClass iClass) {
        if (iClass.isArrayClass()) {
            return this.getImmediateArraySubclasses(iClass);
        }
        Function<Node, IClass> function = new Function<Node, IClass>(){

            @Override
            public IClass apply(Node node) {
                return node.klass;
            }
        };
        return Iterator2Collection.toSet(new MapIterator<Node, IClass>(this.findNode(iClass).children.iterator(), function));
    }

    private Collection<IClass> getImmediateArraySubclasses(IClass iClass) {
        IClass iClass2 = this.getInnermostTypeOfArrayClass(iClass);
        if (iClass2 == null) {
            return Collections.emptySet();
        }
        Collection<IClass> collection = this.getImmediateSubclasses(iClass2);
        int n = iClass.getReference().getDimensionality();
        HashSet<IClass> hashSet = HashSetFactory.make();
        for (IClass iClass3 : collection) {
            TypeReference typeReference = iClass3.getReference();
            int n2 = 0;
            while (n2 < n) {
                typeReference = typeReference.getArrayTypeForElementType();
                ++n2;
            }
            hashSet.add(this.lookupClass(typeReference));
        }
        return hashSet;
    }

    private IClass getInnermostTypeOfArrayClass(IClass iClass) {
        TypeReference typeReference = iClass.getReference();
        while (typeReference.isArrayType()) {
            typeReference = typeReference.getArrayElementType();
        }
        return typeReference.isPrimitiveType() ? null : this.lookupClass(typeReference);
    }

    public static ClassHierarchy make(AnalysisScope analysisScope) throws ClassHierarchyException {
        if (analysisScope == null) {
            throw new IllegalArgumentException("null scope");
        }
        return ClassHierarchy.make(analysisScope, new ClassLoaderFactoryImpl(analysisScope.getExclusions()));
    }

    public static ClassHierarchy make(AnalysisScope analysisScope, IProgressMonitor iProgressMonitor) throws ClassHierarchyException {
        if (analysisScope == null) {
            throw new IllegalArgumentException("null scope");
        }
        return ClassHierarchy.make(analysisScope, (ClassLoaderFactory)new ClassLoaderFactoryImpl(analysisScope.getExclusions()), iProgressMonitor);
    }

    public static ClassHierarchy make(AnalysisScope analysisScope, ClassLoaderFactory classLoaderFactory) throws ClassHierarchyException {
        if (analysisScope == null) {
            throw new IllegalArgumentException("null scope");
        }
        if (classLoaderFactory == null) {
            throw new IllegalArgumentException("null factory");
        }
        return new ClassHierarchy(analysisScope, classLoaderFactory, (IProgressMonitor)new NullProgressMonitor());
    }

    public static ClassHierarchy make(AnalysisScope analysisScope, ClassLoaderFactory classLoaderFactory, IProgressMonitor iProgressMonitor) throws ClassHierarchyException {
        return new ClassHierarchy(analysisScope, classLoaderFactory, iProgressMonitor);
    }

    public static ClassHierarchy make(AnalysisScope analysisScope, ClassLoaderFactory classLoaderFactory, Set<Language> set) throws ClassHierarchyException {
        return new ClassHierarchy(analysisScope, classLoaderFactory, set, (IProgressMonitor)new NullProgressMonitor());
    }

    public static ClassHierarchy make(AnalysisScope analysisScope, ClassLoaderFactory classLoaderFactory, Language language) throws ClassHierarchyException {
        return new ClassHierarchy(analysisScope, classLoaderFactory, language, (IProgressMonitor)new NullProgressMonitor());
    }

    public static ClassHierarchy make(AnalysisScope analysisScope, ClassLoaderFactory classLoaderFactory, Language language, IProgressMonitor iProgressMonitor) throws ClassHierarchyException {
        if (classLoaderFactory == null) {
            throw new IllegalArgumentException("null factory");
        }
        return new ClassHierarchy(analysisScope, classLoaderFactory, language, iProgressMonitor);
    }

    @Override
    public IClass getRootClass() {
        return this.root.getJavaClass();
    }

    @Override
    public boolean isRootClass(IClass iClass) throws IllegalArgumentException {
        if (iClass == null) {
            throw new IllegalArgumentException("c == null");
        }
        return iClass.equals(this.root.getJavaClass());
    }

    @Override
    public int getNumber(IClass iClass) {
        return this.map.get(iClass.getReference()).left;
    }

    @Override
    public boolean isAssignableFrom(IClass iClass, IClass iClass2) {
        if (iClass2 == null) {
            throw new IllegalArgumentException("c2 is null");
        }
        if (iClass == null) {
            throw new IllegalArgumentException("c1 is null");
        }
        if (iClass.isInterface()) {
            return this.implementsInterface(iClass2, iClass);
        }
        if (iClass2.isInterface()) {
            return iClass.equals(this.getRootClass());
        }
        return this.isSubclassOf(iClass2, iClass);
    }

    private static class ClassExclusion
    extends Warning {
        final TypeReference klass;
        final String message;

        ClassExclusion(TypeReference typeReference, String string) {
            super((byte)1);
            this.klass = typeReference;
            this.message = string;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.klass + " " + this.message;
        }

        public static ClassExclusion create(TypeReference typeReference, String string) {
            return new ClassExclusion(typeReference, string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Node {
        private final IClass klass;
        private final Set<Node> children = HashSetFactory.make(3);
        private int left = -1;
        private int right = -1;

        Node(IClass iClass) {
            this.klass = iClass;
        }

        boolean isInterface() {
            return this.klass.isInterface();
        }

        IClass getJavaClass() {
            return this.klass;
        }

        void addChild(Node node) {
            this.children.add(node);
        }

        Iterator<Node> getChildren() {
            return this.children.iterator();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append(this.klass.toString()).append(":");
            Iterator<Node> iterator = this.children.iterator();
            while (iterator.hasNext()) {
                Node node = iterator.next();
                stringBuffer.append(node.klass.toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(",");
            }
            return stringBuffer.toString();
        }

        public int hashCode() {
            return this.klass.hashCode() * 929;
        }

        public boolean equals(Object object) {
            return this == object;
        }
    }
}

