/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.cfg;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.IndiscriminateFilter;
import com.ibm.wala.util.collections.MapIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.functions.Function;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInterproceduralCFG<T extends ISSABasicBlock>
implements NumberedGraph<BasicBlockInContext<T>> {
    private static final int DEBUG_LEVEL = 0;
    private static final boolean WARN_ON_EAGER_CONSTRUCTION = false;
    private static final boolean FAIL_ON_EAGER_CONSTRUCTION = false;
    private static final boolean CALL_TO_RETURN_EDGES = true;
    private final NumberedGraph<BasicBlockInContext<T>> g = new SlowSparseNumberedGraph<BasicBlockInContext<T>>(2);
    private final CallGraph cg;
    private final Filter<CGNode> relevant;
    private final BitVector hasCallVector = new BitVector();
    private MutableIntSet cgNodesVisited = new BitVectorIntSet();
    private MutableIntSet cgNodesWithCallerEdges = new BitVectorIntSet();
    private MutableIntSet handledCalls = new BitVectorIntSet();
    private MutableIntSet handledReturns = new BitVectorIntSet();
    private MutableIntSet addedSuccs = new BitVectorIntSet();
    private MutableIntSet addedPreds = new BitVectorIntSet();
    private boolean constructedFullGraph = false;
    private final Filter<BasicBlockInContext<T>> isCall = new Filter<BasicBlockInContext<T>>(){

        @Override
        public boolean accepts(BasicBlockInContext<T> basicBlockInContext) {
            return AbstractInterproceduralCFG.this.hasCall(basicBlockInContext);
        }
    };

    public void callGraphUpdated() {
        this.cgNodesVisited = new BitVectorIntSet();
        this.cgNodesWithCallerEdges = new BitVectorIntSet();
        this.handledCalls = new BitVectorIntSet();
        this.handledReturns = new BitVectorIntSet();
        this.addedSuccs = new BitVectorIntSet();
        this.addedPreds = new BitVectorIntSet();
    }

    public abstract ControlFlowGraph<SSAInstruction, T> getCFG(CGNode var1);

    public AbstractInterproceduralCFG(CallGraph callGraph) {
        this(callGraph, IndiscriminateFilter.singleton());
    }

    public AbstractInterproceduralCFG(CallGraph callGraph, Filter<CGNode> filter) {
        this.cg = callGraph;
        this.relevant = filter;
    }

    private void addIntraproceduralNodesAndEdgesForCGNodeIfNeeded(CGNode cGNode) {
        if (!this.cgNodesVisited.contains(this.cg.getNumber(cGNode)) && this.relevant.accepts(cGNode)) {
            this.cgNodesVisited.add(this.cg.getNumber(cGNode));
            ControlFlowGraph<SSAInstruction, T> controlFlowGraph = this.getCFG(cGNode);
            if (controlFlowGraph != null) {
                this.addNodeForEachBasicBlock(controlFlowGraph, cGNode);
                SSAInstruction[] sSAInstructionArray = controlFlowGraph.getInstructions();
                for (ISSABasicBlock iSSABasicBlock : controlFlowGraph) {
                    if (iSSABasicBlock == controlFlowGraph.entry()) continue;
                    this.addEdgesToNonEntryBlock(cGNode, controlFlowGraph, sSAInstructionArray, iSSABasicBlock);
                }
            }
        }
    }

    protected void addEdgesToNonEntryBlock(CGNode cGNode, ControlFlowGraph<?, T> controlFlowGraph, SSAInstruction[] sSAInstructionArray, T t) {
        Iterator<T> iterator = controlFlowGraph.getPredNodes(t);
        while (iterator.hasNext()) {
            BasicBlockInContext<T> basicBlockInContext;
            BasicBlockInContext<Object> basicBlockInContext2;
            Object object;
            ISSABasicBlock iSSABasicBlock = (ISSABasicBlock)iterator.next();
            if (iSSABasicBlock.equals(controlFlowGraph.entry())) {
                object = new BasicBlockInContext<ISSABasicBlock>(cGNode, iSSABasicBlock);
                basicBlockInContext2 = new BasicBlockInContext<T>(cGNode, t);
                this.g.addEdge((BasicBlockInContext<BasicBlockInContext<T>>)object, (BasicBlockInContext<BasicBlockInContext<T>>)basicBlockInContext2);
                continue;
            }
            object = this.getLastInstructionForBlock(iSSABasicBlock, sSAInstructionArray);
            if (object instanceof SSAAbstractInvokeInstruction) {
                basicBlockInContext2 = new BasicBlockInContext<ISSABasicBlock>(cGNode, iSSABasicBlock);
                basicBlockInContext = new BasicBlockInContext<T>(cGNode, t);
                this.g.addEdge(basicBlockInContext2, basicBlockInContext);
                continue;
            }
            basicBlockInContext2 = new BasicBlockInContext<ISSABasicBlock>(cGNode, iSSABasicBlock);
            basicBlockInContext = new BasicBlockInContext<T>(cGNode, t);
            if (!this.g.containsNode(basicBlockInContext2) || !this.g.containsNode(basicBlockInContext)) {
                assert (this.g.containsNode(basicBlockInContext2)) : "IPCFG does not contain " + basicBlockInContext2;
                assert (this.g.containsNode(basicBlockInContext)) : "IPCFG does not contain " + basicBlockInContext;
            }
            this.g.addEdge(basicBlockInContext2, basicBlockInContext);
        }
    }

    protected SSAInstruction getLastInstructionForBlock(T t, SSAInstruction[] sSAInstructionArray) {
        int n = t.getLastInstructionIndex();
        SSAInstruction sSAInstruction = sSAInstructionArray[n];
        return sSAInstruction;
    }

    private void addEdgesFromExitToReturn(CGNode cGNode, T t, CGNode cGNode2, ControlFlowGraph<SSAInstruction, ? extends T> controlFlowGraph) {
        ISSABasicBlock iSSABasicBlock = (ISSABasicBlock)controlFlowGraph.exit();
        BasicBlockInContext<ISSABasicBlock> basicBlockInContext = new BasicBlockInContext<ISSABasicBlock>(cGNode2, iSSABasicBlock);
        this.addNodeForBasicBlockIfNeeded(basicBlockInContext);
        BasicBlockInContext<T> basicBlockInContext2 = new BasicBlockInContext<T>(cGNode, t);
        if (!this.g.containsNode(basicBlockInContext) || !this.g.containsNode(basicBlockInContext2)) {
            assert (this.g.containsNode(basicBlockInContext)) : "IPCFG does not contain " + basicBlockInContext;
            assert (this.g.containsNode(basicBlockInContext2)) : "IPCFG does not contain " + basicBlockInContext2;
        }
        this.g.addEdge(basicBlockInContext, basicBlockInContext2);
    }

    private void addEdgesFromCallToEntry(CGNode cGNode, T t, CGNode cGNode2, ControlFlowGraph<SSAInstruction, ? extends T> controlFlowGraph) {
        ISSABasicBlock iSSABasicBlock = (ISSABasicBlock)controlFlowGraph.entry();
        BasicBlockInContext<ISSABasicBlock> basicBlockInContext = new BasicBlockInContext<ISSABasicBlock>(cGNode2, iSSABasicBlock);
        this.addNodeForBasicBlockIfNeeded(basicBlockInContext);
        BasicBlockInContext<T> basicBlockInContext2 = new BasicBlockInContext<T>(cGNode, t);
        if (!this.g.containsNode(basicBlockInContext) || !this.g.containsNode(basicBlockInContext2)) {
            assert (this.g.containsNode(basicBlockInContext)) : "IPCFG does not contain " + basicBlockInContext;
            assert (this.g.containsNode(basicBlockInContext2)) : "IPCFG does not contain " + basicBlockInContext2;
        }
        this.g.addEdge(basicBlockInContext2, basicBlockInContext);
    }

    private void addInterproceduralEdgesForEntryAndExitBlocks(CGNode cGNode, ControlFlowGraph<SSAInstruction, ? extends T> controlFlowGraph) {
        ISSABasicBlock iSSABasicBlock = (ISSABasicBlock)controlFlowGraph.entry();
        ISSABasicBlock iSSABasicBlock2 = (ISSABasicBlock)controlFlowGraph.exit();
        Iterator<CGNode> iterator = this.cg.getPredNodes(cGNode);
        while (iterator.hasNext()) {
            CGNode cGNode2 = iterator.next();
            if (!this.relevant.accepts(cGNode2)) continue;
            this.addEntryAndExitEdgesToCaller(cGNode, iSSABasicBlock, iSSABasicBlock2, cGNode2);
        }
    }

    private void addEntryAndExitEdgesToCaller(CGNode cGNode, T t, T t2, CGNode cGNode2) {
        ControlFlowGraph<SSAInstruction, ISSABasicBlock> controlFlowGraph = this.getCFG(cGNode2);
        if (controlFlowGraph != null) {
            SSAInstruction[] sSAInstructionArray = controlFlowGraph.getInstructions();
            int n = 0;
            while (n < sSAInstructionArray.length) {
                if (sSAInstructionArray[n] instanceof SSAAbstractInvokeInstruction) {
                    SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = (SSAAbstractInvokeInstruction)sSAInstructionArray[n];
                    CallSiteReference callSiteReference = sSAAbstractInvokeInstruction.getCallSite();
                    assert (callSiteReference.getProgramCounter() == controlFlowGraph.getProgramCounter(n));
                    if (this.cg.getPossibleTargets(cGNode2, callSiteReference).contains(cGNode)) {
                        ISSABasicBlock iSSABasicBlock = (ISSABasicBlock)controlFlowGraph.getBlockForInstruction(n);
                        BasicBlockInContext<ISSABasicBlock> basicBlockInContext = new BasicBlockInContext<ISSABasicBlock>(cGNode2, iSSABasicBlock);
                        this.addNodeForBasicBlockIfNeeded(basicBlockInContext);
                        BasicBlockInContext<T> basicBlockInContext2 = new BasicBlockInContext<T>(cGNode, t);
                        this.g.addEdge(basicBlockInContext, basicBlockInContext2);
                        Iterator<ISSABasicBlock> iterator = controlFlowGraph.getSuccNodes(iSSABasicBlock);
                        while (iterator.hasNext()) {
                            ISSABasicBlock iSSABasicBlock2 = iterator.next();
                            BasicBlockInContext<T> basicBlockInContext3 = new BasicBlockInContext<T>(cGNode, t2);
                            BasicBlockInContext<ISSABasicBlock> basicBlockInContext4 = new BasicBlockInContext<ISSABasicBlock>(cGNode2, iSSABasicBlock2);
                            this.addNodeForBasicBlockIfNeeded(basicBlockInContext4);
                            this.g.addEdge(basicBlockInContext3, basicBlockInContext4);
                        }
                    }
                }
                ++n;
            }
        }
    }

    private void addNodeForEachBasicBlock(ControlFlowGraph<? extends SSAInstruction, ? extends T> controlFlowGraph, CGNode cGNode) {
        for (ISSABasicBlock iSSABasicBlock : controlFlowGraph) {
            BasicBlockInContext<ISSABasicBlock> basicBlockInContext = new BasicBlockInContext<ISSABasicBlock>(cGNode, iSSABasicBlock);
            this.addNodeForBasicBlockIfNeeded(basicBlockInContext);
        }
    }

    private void addNodeForBasicBlockIfNeeded(BasicBlockInContext<T> basicBlockInContext) {
        if (!this.g.containsNode(basicBlockInContext)) {
            this.g.addNode(basicBlockInContext);
            ControlFlowGraph<SSAInstruction, T> controlFlowGraph = this.getCFG(basicBlockInContext);
            if (this.hasCall(basicBlockInContext, controlFlowGraph)) {
                this.hasCallVector.set(this.g.getNumber(basicBlockInContext));
            }
        }
    }

    public ControlFlowGraph<SSAInstruction, T> getCFG(BasicBlockInContext basicBlockInContext) throws IllegalArgumentException {
        if (basicBlockInContext == null) {
            throw new IllegalArgumentException("B == null");
        }
        return this.getCFG(this.getCGNode(basicBlockInContext));
    }

    public CGNode getCGNode(BasicBlockInContext basicBlockInContext) throws IllegalArgumentException {
        if (basicBlockInContext == null) {
            throw new IllegalArgumentException("B == null");
        }
        return basicBlockInContext.getNode();
    }

    @Override
    public void removeNodeAndEdges(BasicBlockInContext basicBlockInContext) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<BasicBlockInContext<T>> iterator() {
        this.constructFullGraph();
        return this.g.iterator();
    }

    @Override
    public int getNumberOfNodes() {
        this.constructFullGraph();
        return this.g.getNumberOfNodes();
    }

    private void constructFullGraph() {
        if (!this.constructedFullGraph) {
            for (CGNode cGNode : this.cg) {
                this.addIntraproceduralNodesAndEdgesForCGNodeIfNeeded(cGNode);
                this.addEdgesToCallees(cGNode);
            }
            int n = 0;
            while (n < this.g.getMaxNumber()) {
                this.addedSuccs.add(n);
                this.addedPreds.add(n);
                ++n;
            }
            this.constructedFullGraph = true;
        }
    }

    private void addEdgesToCallees(CGNode cGNode) {
        ControlFlowGraph<SSAInstruction, T> controlFlowGraph = this.getCFG(cGNode);
        if (controlFlowGraph != null) {
            for (ISSABasicBlock iSSABasicBlock : controlFlowGraph) {
                BasicBlockInContext<ISSABasicBlock> basicBlockInContext = new BasicBlockInContext<ISSABasicBlock>(cGNode, iSSABasicBlock);
                if (!this.hasCall(basicBlockInContext)) continue;
                this.addCalleeEdgesForCall(cGNode, basicBlockInContext);
            }
        }
    }

    private void addCalleeEdgesForReturn(CGNode cGNode, BasicBlockInContext<T> basicBlockInContext) {
        int n = this.g.getNumber(basicBlockInContext);
        if (!this.handledReturns.contains(n)) {
            this.handledReturns.add(n);
            ControlFlowGraph<SSAInstruction, T> controlFlowGraph = this.getCFG(basicBlockInContext);
            Iterator<T> iterator = controlFlowGraph.getPredNodes(basicBlockInContext.getDelegate());
            while (iterator.hasNext()) {
                ISSABasicBlock iSSABasicBlock = (ISSABasicBlock)iterator.next();
                BasicBlockInContext<ISSABasicBlock> basicBlockInContext2 = new BasicBlockInContext<ISSABasicBlock>(cGNode, iSSABasicBlock);
                if (!this.hasCall(basicBlockInContext2)) continue;
                this.addCalleeEdgesForCall(cGNode, basicBlockInContext2);
            }
        }
    }

    private void addCalleeEdgesForCall(CGNode cGNode, BasicBlockInContext<T> basicBlockInContext) {
        int n = this.g.getNumber(basicBlockInContext);
        if (!this.handledCalls.contains(n)) {
            this.handledCalls.add(n);
            ControlFlowGraph<SSAInstruction, T> controlFlowGraph = this.getCFG(cGNode);
            CallSiteReference callSiteReference = this.getCallSiteForCallBlock(basicBlockInContext, controlFlowGraph);
            boolean bl = false;
            for (CGNode cGNode2 : this.cg.getPossibleTargets(cGNode, callSiteReference)) {
                if (!this.relevant.accepts(cGNode2)) {
                    bl = true;
                    continue;
                }
                ControlFlowGraph<SSAInstruction, T> controlFlowGraph2 = this.getCFG(cGNode2);
                if (controlFlowGraph2 == null) continue;
                T t = basicBlockInContext.getDelegate();
                this.addEdgesFromCallToEntry(cGNode, t, cGNode2, controlFlowGraph2);
                Iterator<T> iterator = controlFlowGraph.getSuccNodes(t);
                while (iterator.hasNext()) {
                    ISSABasicBlock iSSABasicBlock = (ISSABasicBlock)iterator.next();
                    this.addEdgesFromExitToReturn(cGNode, iSSABasicBlock, cGNode2, controlFlowGraph2);
                    if (!bl) continue;
                    this.g.addEdge(basicBlockInContext, new BasicBlockInContext<ISSABasicBlock>(cGNode, iSSABasicBlock));
                }
            }
        }
    }

    private void addCallerEdges(CGNode cGNode) {
        int n = this.cg.getNumber(cGNode);
        if (!this.cgNodesWithCallerEdges.contains(n)) {
            this.cgNodesWithCallerEdges.add(n);
            ControlFlowGraph<SSAInstruction, T> controlFlowGraph = this.getCFG(cGNode);
            this.addInterproceduralEdgesForEntryAndExitBlocks(cGNode, controlFlowGraph);
        }
    }

    @Override
    public void addNode(BasicBlockInContext basicBlockInContext) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeNode(BasicBlockInContext basicBlockInContext) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<BasicBlockInContext<T>> getPredNodes(BasicBlockInContext<T> basicBlockInContext) {
        this.initForPred(basicBlockInContext);
        return this.g.getPredNodes(basicBlockInContext);
    }

    private void initForPred(BasicBlockInContext<T> basicBlockInContext) {
        CGNode cGNode = this.getCGNode(basicBlockInContext);
        this.addIntraproceduralNodesAndEdgesForCGNodeIfNeeded(cGNode);
        int n = this.g.getNumber(basicBlockInContext);
        if (!this.addedPreds.contains(n)) {
            this.addedPreds.add(n);
            if (basicBlockInContext.getDelegate().isEntryBlock()) {
                this.addCallerEdges(cGNode);
            }
            if (this.isReturn(basicBlockInContext)) {
                this.addCalleeEdgesForReturn(cGNode, basicBlockInContext);
            }
        }
    }

    private void initForSucc(BasicBlockInContext<T> basicBlockInContext) {
        CGNode cGNode = this.getCGNode(basicBlockInContext);
        this.addIntraproceduralNodesAndEdgesForCGNodeIfNeeded(cGNode);
        int n = this.g.getNumber(basicBlockInContext);
        if (!this.addedSuccs.contains(n)) {
            this.addedSuccs.add(n);
            if (basicBlockInContext.getDelegate().isExitBlock()) {
                this.addCallerEdges(cGNode);
            }
            if (this.hasCall(basicBlockInContext)) {
                this.addCalleeEdgesForCall(cGNode, basicBlockInContext);
            }
        }
    }

    @Override
    public int getPredNodeCount(BasicBlockInContext<T> basicBlockInContext) {
        this.initForPred(basicBlockInContext);
        return this.g.getPredNodeCount(basicBlockInContext);
    }

    @Override
    public Iterator<BasicBlockInContext<T>> getSuccNodes(BasicBlockInContext<T> basicBlockInContext) {
        this.initForSucc(basicBlockInContext);
        return this.g.getSuccNodes(basicBlockInContext);
    }

    @Override
    public int getSuccNodeCount(BasicBlockInContext<T> basicBlockInContext) {
        this.initForSucc(basicBlockInContext);
        return this.g.getSuccNodeCount(basicBlockInContext);
    }

    @Override
    public void addEdge(BasicBlockInContext basicBlockInContext, BasicBlockInContext basicBlockInContext2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeEdge(BasicBlockInContext basicBlockInContext, BasicBlockInContext basicBlockInContext2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAllIncidentEdges(BasicBlockInContext basicBlockInContext) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.g.toString();
    }

    @Override
    public boolean containsNode(BasicBlockInContext<T> basicBlockInContext) {
        return this.g.containsNode(basicBlockInContext);
    }

    public boolean hasCall(BasicBlockInContext<T> basicBlockInContext) {
        this.addNodeForBasicBlockIfNeeded(basicBlockInContext);
        return this.hasCallVector.get(this.getNumber(basicBlockInContext));
    }

    protected boolean hasCall(BasicBlockInContext<T> basicBlockInContext, ControlFlowGraph<SSAInstruction, T> controlFlowGraph) {
        SSAInstruction[] sSAInstructionArray = controlFlowGraph.getInstructions();
        int n = basicBlockInContext.getLastInstructionIndex();
        if (n >= 0) {
            if (sSAInstructionArray.length <= n) {
                System.err.println(sSAInstructionArray.length);
                System.err.println(controlFlowGraph);
                assert (n < sSAInstructionArray.length) : "bad BB " + basicBlockInContext + " and CFG for " + this.getCGNode(basicBlockInContext);
            }
            SSAInstruction sSAInstruction = sSAInstructionArray[n];
            return sSAInstruction instanceof SSAAbstractInvokeInstruction;
        }
        return false;
    }

    public Set<CGNode> getCallTargets(BasicBlockInContext<T> basicBlockInContext) {
        if (basicBlockInContext == null) {
            throw new IllegalArgumentException("B is null");
        }
        ControlFlowGraph<SSAInstruction, T> controlFlowGraph = this.getCFG(basicBlockInContext);
        return this.getCallTargets(basicBlockInContext, controlFlowGraph, this.getCGNode(basicBlockInContext));
    }

    private Set<CGNode> getCallTargets(IBasicBlock<SSAInstruction> iBasicBlock, ControlFlowGraph<SSAInstruction, T> controlFlowGraph, CGNode cGNode) {
        CallSiteReference callSiteReference = this.getCallSiteForCallBlock(iBasicBlock, controlFlowGraph);
        return this.cg.getPossibleTargets(cGNode, callSiteReference);
    }

    protected CallSiteReference getCallSiteForCallBlock(IBasicBlock<SSAInstruction> iBasicBlock, ControlFlowGraph<SSAInstruction, T> controlFlowGraph) {
        SSAInstruction[] sSAInstructionArray = controlFlowGraph.getInstructions();
        SSAAbstractInvokeInstruction sSAAbstractInvokeInstruction = (SSAAbstractInvokeInstruction)sSAInstructionArray[iBasicBlock.getLastInstructionIndex()];
        int n = controlFlowGraph.getProgramCounter(iBasicBlock.getLastInstructionIndex());
        CallSiteReference callSiteReference = sSAAbstractInvokeInstruction.getCallSite();
        assert (callSiteReference.getProgramCounter() == n);
        return callSiteReference;
    }

    @Override
    public void removeIncomingEdges(BasicBlockInContext basicBlockInContext) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeOutgoingEdges(BasicBlockInContext basicBlockInContext) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasEdge(BasicBlockInContext<T> basicBlockInContext, BasicBlockInContext<T> basicBlockInContext2) {
        if (!this.addedSuccs.contains(this.getNumber(basicBlockInContext))) {
            if (!basicBlockInContext.getNode().equals(basicBlockInContext2.getNode())) {
                CGNode cGNode;
                if (basicBlockInContext.getDelegate().isExitBlock()) {
                    CGNode cGNode2 = basicBlockInContext.getNode();
                    if (!this.cgNodesWithCallerEdges.contains(this.cg.getNumber(cGNode2))) {
                        CGNode cGNode3 = basicBlockInContext2.getNode();
                        T t = basicBlockInContext.getDelegate();
                        ISSABasicBlock iSSABasicBlock = (ISSABasicBlock)this.getCFG(cGNode2).entry();
                        this.addEntryAndExitEdgesToCaller(cGNode2, iSSABasicBlock, t, cGNode3);
                    }
                } else if (this.hasCall(basicBlockInContext) && basicBlockInContext2.getDelegate().isEntryBlock() && !this.cgNodesWithCallerEdges.contains(this.cg.getNumber(cGNode = basicBlockInContext2.getNode()))) {
                    CGNode cGNode4 = basicBlockInContext.getNode();
                    T t = basicBlockInContext2.getDelegate();
                    ISSABasicBlock iSSABasicBlock = (ISSABasicBlock)this.getCFG(cGNode).exit();
                    this.addEntryAndExitEdgesToCaller(cGNode, t, iSSABasicBlock, cGNode4);
                }
            } else {
                this.addIntraproceduralNodesAndEdgesForCGNodeIfNeeded(basicBlockInContext.getNode());
            }
        }
        return this.g.hasEdge(basicBlockInContext, basicBlockInContext2);
    }

    @Override
    public int getNumber(BasicBlockInContext<T> basicBlockInContext) {
        this.addNodeForBasicBlockIfNeeded(basicBlockInContext);
        return this.g.getNumber(basicBlockInContext);
    }

    @Override
    public BasicBlockInContext<T> getNode(int n) throws UnimplementedError {
        return (BasicBlockInContext)this.g.getNode(n);
    }

    @Override
    public int getMaxNumber() {
        this.constructFullGraph();
        return this.g.getMaxNumber();
    }

    @Override
    public Iterator<BasicBlockInContext<T>> iterateNodes(IntSet intSet) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getSuccNodeNumbers(BasicBlockInContext<T> basicBlockInContext) {
        this.initForSucc(basicBlockInContext);
        return this.g.getSuccNodeNumbers(basicBlockInContext);
    }

    @Override
    public IntSet getPredNodeNumbers(BasicBlockInContext<T> basicBlockInContext) {
        this.initForPred(basicBlockInContext);
        return this.g.getPredNodeNumbers(basicBlockInContext);
    }

    public BasicBlockInContext<T> getEntry(CGNode cGNode) {
        ControlFlowGraph<SSAInstruction, T> controlFlowGraph = this.getCFG(cGNode);
        if (controlFlowGraph != null) {
            ISSABasicBlock iSSABasicBlock = (ISSABasicBlock)controlFlowGraph.entry();
            return new BasicBlockInContext<ISSABasicBlock>(cGNode, iSSABasicBlock);
        }
        return null;
    }

    public BasicBlockInContext<T> getExit(CGNode cGNode) {
        ControlFlowGraph<SSAInstruction, T> controlFlowGraph = this.getCFG(cGNode);
        ISSABasicBlock iSSABasicBlock = (ISSABasicBlock)controlFlowGraph.exit();
        return new BasicBlockInContext<ISSABasicBlock>(cGNode, iSSABasicBlock);
    }

    public Iterator<BasicBlockInContext<T>> getReturnSites(BasicBlockInContext<T> basicBlockInContext) {
        if (basicBlockInContext == null) {
            throw new IllegalArgumentException("bb is null");
        }
        final CGNode cGNode = basicBlockInContext.getNode();
        Filter filter = new Filter(){

            public boolean accepts(Object object) {
                BasicBlockInContext basicBlockInContext = (BasicBlockInContext)object;
                return !basicBlockInContext.isEntryBlock() && cGNode.equals(basicBlockInContext.getNode());
            }
        };
        return new FilterIterator<BasicBlockInContext<T>>(this.getSuccNodes(basicBlockInContext), filter);
    }

    public Iterator<BasicBlockInContext<T>> getCallSites(BasicBlockInContext<T> basicBlockInContext, final CGNode cGNode) {
        if (basicBlockInContext == null) {
            throw new IllegalArgumentException("bb is null");
        }
        final ControlFlowGraph<SSAInstruction, T> controlFlowGraph = this.getCFG(basicBlockInContext);
        Iterator<T> iterator = controlFlowGraph.getPredNodes(basicBlockInContext.getDelegate());
        final CGNode cGNode2 = basicBlockInContext.getNode();
        Filter filter = new Filter<T>(){

            @Override
            public boolean accepts(T t) {
                BasicBlockInContext basicBlockInContext = new BasicBlockInContext(cGNode2, t);
                if (!AbstractInterproceduralCFG.this.hasCall(basicBlockInContext, controlFlowGraph)) {
                    return false;
                }
                if (cGNode != null) {
                    return AbstractInterproceduralCFG.this.getCallTargets(basicBlockInContext).contains(cGNode);
                }
                return AbstractInterproceduralCFG.this.getCallTargets(basicBlockInContext).isEmpty();
            }
        };
        iterator = new FilterIterator(iterator, filter);
        Function function = new Function<T, BasicBlockInContext<T>>(){

            @Override
            public BasicBlockInContext<T> apply(T t) {
                Object t2 = t;
                return new BasicBlockInContext(cGNode2, t2);
            }
        };
        MapIterator mapIterator = new MapIterator(iterator, function);
        return new FilterIterator<BasicBlockInContext<T>>(mapIterator, this.isCall);
    }

    public boolean isReturn(BasicBlockInContext<T> basicBlockInContext) throws IllegalArgumentException {
        if (basicBlockInContext == null) {
            throw new IllegalArgumentException("bb == null");
        }
        ControlFlowGraph<SSAInstruction, T> controlFlowGraph = this.getCFG(basicBlockInContext);
        Iterator<T> iterator = controlFlowGraph.getPredNodes(basicBlockInContext.getDelegate());
        while (iterator.hasNext()) {
            ISSABasicBlock iSSABasicBlock = (ISSABasicBlock)iterator.next();
            if (!this.hasCall(new BasicBlockInContext<ISSABasicBlock>(basicBlockInContext.getNode(), iSSABasicBlock))) continue;
            return true;
        }
        return false;
    }

    public CallGraph getCallGraph() {
        return this.cg;
    }
}

