/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.rta;

import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.ClassBasedInstanceKeys;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.DefaultPointerKeyFactory;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.cha.IClassHierarchyDweller;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeBasedHeapModel
implements HeapModel {
    private static final boolean DEBUG = false;
    final DefaultPointerKeyFactory pointerKeys = new DefaultPointerKeyFactory();
    private final ClassBasedInstanceKeys iKeyFactory;
    private final Collection<IClass> klasses;
    private final CallGraph cg;
    private final Collection<CGNode> nodesHandled = HashSetFactory.make();
    private Map<PointerKey, Object> pKeys;

    public TypeBasedHeapModel(AnalysisOptions analysisOptions, Collection<IClass> collection, CallGraph callGraph) {
        if (callGraph == null) {
            throw new IllegalArgumentException("cg is null");
        }
        this.iKeyFactory = new ClassBasedInstanceKeys(analysisOptions, callGraph.getClassHierarchy());
        this.klasses = collection;
        this.cg = callGraph;
    }

    private void initAllPKeys() {
        if (this.pKeys == null) {
            this.pKeys = HashMapFactory.make();
        }
        for (IClassHierarchyDweller iClassHierarchyDweller : this.klasses) {
            this.pKeys.putAll(this.computePointerKeys((IClass)iClassHierarchyDweller));
        }
        for (IClassHierarchyDweller iClassHierarchyDweller : this.cg) {
            this.initPKeysForNode((CGNode)iClassHierarchyDweller);
        }
    }

    private void initPKeysForNode(CGNode cGNode) {
        if (this.pKeys == null) {
            this.pKeys = HashMapFactory.make();
        }
        if (!this.nodesHandled.contains(cGNode)) {
            this.nodesHandled.add(cGNode);
            this.pKeys.putAll(this.computePointerKeys(cGNode));
        }
    }

    private Map<PointerKey, Object> computePointerKeys(CGNode cGNode) {
        IR iR = cGNode.getIR();
        if (iR == null) {
            return Collections.emptyMap();
        }
        HashMap<PointerKey, Object> hashMap = HashMapFactory.make();
        SymbolTable symbolTable = iR.getSymbolTable();
        if (symbolTable == null) {
            return Collections.emptyMap();
        }
        TypeInference typeInference = TypeInference.make(iR, false);
        int n = 1;
        while (n <= symbolTable.getMaxValueNumber()) {
            Object object;
            if (symbolTable.isConstant(n)) {
                if (symbolTable.isStringConstant(n)) {
                    object = cGNode.getMethod().getDeclaringClass().getClassLoader().getLanguage().getConstantType(symbolTable.getStringValue(n));
                    hashMap.put(this.pointerKeys.getPointerKeyForLocal(cGNode, n), this.getInstanceKeyForConstant((TypeReference)object, symbolTable.getConstantValue(n)));
                }
            } else {
                object = typeInference.getType(n);
                if (((TypeAbstraction)object).getType() != null && ((TypeAbstraction)object).getType().isReferenceType()) {
                    hashMap.put(this.pointerKeys.getPointerKeyForLocal(cGNode, n), this.pointerKeys.getFilteredPointerKeyForLocal(cGNode, n, new FilteredPointerKey.SingleClassFilter(((TypeAbstraction)object).getType())));
                }
            }
            ++n;
        }
        return hashMap;
    }

    private Map<PointerKey, Object> computePointerKeys(IClass iClass) {
        HashMap<PointerKey, Object> hashMap = HashMapFactory.make();
        if (iClass.isArrayClass()) {
            ArrayClass arrayClass = (ArrayClass)iClass;
            if (arrayClass.getElementClass() != null && arrayClass.getElementClass().isReferenceType()) {
                PointerKey pointerKey = this.pointerKeys.getPointerKeyForArrayContents(new ConcreteTypeKey(arrayClass));
                hashMap.put(pointerKey, pointerKey);
            }
        } else {
            for (IField iField : iClass.getAllFields()) {
                PointerKey pointerKey;
                if (iField.getFieldTypeReference().isPrimitiveType()) continue;
                if (iField.isStatic()) {
                    pointerKey = this.pointerKeys.getPointerKeyForStaticField(iField);
                    hashMap.put(pointerKey, pointerKey);
                    continue;
                }
                pointerKey = this.pointerKeys.getPointerKeyForInstanceField(new ConcreteTypeKey(iClass), iField);
                hashMap.put(pointerKey, pointerKey);
            }
        }
        return hashMap;
    }

    @Override
    public Iterator<PointerKey> iteratePointerKeys() {
        this.initAllPKeys();
        return Predicate.filter(this.pKeys.values().iterator(), new Predicate(){

            public boolean test(Object object) {
                return object instanceof PointerKey;
            }
        }).iterator();
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.iKeyFactory.getClassHierarchy();
    }

    @Override
    public InstanceKey getInstanceKeyForAllocation(CGNode cGNode, NewSiteReference newSiteReference) throws UnimplementedError {
        return this.iKeyFactory.getInstanceKeyForAllocation(cGNode, newSiteReference);
    }

    @Override
    public InstanceKey getInstanceKeyForMultiNewArray(CGNode cGNode, NewSiteReference newSiteReference, int n) throws UnimplementedError {
        return this.iKeyFactory.getInstanceKeyForMultiNewArray(cGNode, newSiteReference, n);
    }

    public InstanceKey getInstanceKeyForConstant(TypeReference typeReference, Object object) {
        return this.iKeyFactory.getInstanceKeyForConstant(typeReference, object);
    }

    public String getStringConstantForInstanceKey(InstanceKey instanceKey) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public InstanceKey getInstanceKeyForPEI(CGNode cGNode, ProgramCounter programCounter, TypeReference typeReference) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public InstanceKey getInstanceKeyForClassObject(TypeReference typeReference) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public FilteredPointerKey getPointerKeyForLocal(CGNode cGNode, int n) {
        this.initPKeysForNode(cGNode);
        PointerKey pointerKey = this.pointerKeys.getPointerKeyForLocal(cGNode, n);
        Object object = this.pKeys.get(pointerKey);
        if (object == null) {
            return null;
        }
        if (object instanceof FilteredPointerKey) {
            return (FilteredPointerKey)object;
        }
        if (object instanceof ConcreteTypeKey) {
            ConcreteTypeKey concreteTypeKey = (ConcreteTypeKey)object;
            if (concreteTypeKey.getConcreteType().getReference().equals(TypeReference.JavaLangString)) {
                return this.pointerKeys.getFilteredPointerKeyForLocal(cGNode, n, new FilteredPointerKey.SingleClassFilter(concreteTypeKey.getConcreteType()));
            }
            Assertions.UNREACHABLE("need to handle " + object.getClass());
            return null;
        }
        Assertions.UNREACHABLE("need to handle " + object.getClass());
        return null;
    }

    @Override
    public FilteredPointerKey getFilteredPointerKeyForLocal(CGNode cGNode, int n, FilteredPointerKey.TypeFilter typeFilter) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public PointerKey getPointerKeyForReturnValue(CGNode cGNode) {
        return this.pointerKeys.getPointerKeyForReturnValue(cGNode);
    }

    @Override
    public PointerKey getPointerKeyForExceptionalReturnValue(CGNode cGNode) {
        return this.pointerKeys.getPointerKeyForExceptionalReturnValue(cGNode);
    }

    @Override
    public PointerKey getPointerKeyForStaticField(IField iField) {
        return this.pointerKeys.getPointerKeyForStaticField(iField);
    }

    @Override
    public PointerKey getPointerKeyForInstanceField(InstanceKey instanceKey, IField iField) {
        return this.pointerKeys.getPointerKeyForInstanceField(instanceKey, iField);
    }

    @Override
    public PointerKey getPointerKeyForArrayContents(InstanceKey instanceKey) {
        return this.pointerKeys.getPointerKeyForArrayContents(instanceKey);
    }

    protected ClassBasedInstanceKeys getIKeyFactory() {
        return this.iKeyFactory;
    }
}

