/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.rta;

import com.ibm.wala.analysis.reflection.ReflectionContextInterpreter;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.fixedpoint.impl.UnaryOperator;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.impl.DefaultContextSelector;
import com.ibm.wala.ipa.callgraph.impl.DelegatingContextSelector;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.impl.ExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.impl.FakeRootMethod;
import com.ibm.wala.ipa.callgraph.impl.FakeWorldClinitMethod;
import com.ibm.wala.ipa.callgraph.propagation.ClassBasedInstanceKeys;
import com.ibm.wala.ipa.callgraph.propagation.IPointsToSolver;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointsToSetVariable;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.PropagationSystem;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.StandardSolver;
import com.ibm.wala.ipa.callgraph.propagation.cfa.DefaultPointerKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.cfa.DefaultSSAInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.cfa.DelegatingSSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.rta.DelegatingExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.propagation.rta.RTAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.rta.TypeBasedPointerAnalysis;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRTABuilder
extends PropagationCallGraphBuilder {
    protected static final int DEBUG_LEVEL = 0;
    protected static final boolean DEBUG = false;
    private static final int VERBOSE_INTERVAL = 10000;
    private static final int PERIODIC_MAINTAIN_INTERVAL = 10000;
    protected final boolean clone2Assign = true;
    protected final Set<IClass> clinitProcessed = HashSetFactory.make();
    protected final HashSet<IClass> allocatedClasses = HashSetFactory.make();
    private static final TypeReference[] PRE_ALLOC = new TypeReference[]{TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/Object"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/ArithmeticException"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/ArrayStoreException"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/ClassCastException"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/ClassNotFoundException"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/IndexOutOfBoundsException"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/NegativeArraySizeException"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/ExceptionInInitializerError"), TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Ljava/lang/NullPointerException")};

    protected AbstractRTABuilder(IClassHierarchy iClassHierarchy, AnalysisOptions analysisOptions, AnalysisCache analysisCache, ContextSelector contextSelector, SSAContextInterpreter sSAContextInterpreter) {
        super(iClassHierarchy, analysisOptions, analysisCache, new DefaultPointerKeyFactory());
        this.setInstanceKeys(new ClassBasedInstanceKeys(analysisOptions, iClassHierarchy));
        this.setContextSelector(this.makeContextSelector(contextSelector));
        this.setContextInterpreter(this.makeContextInterpreter(sSAContextInterpreter));
    }

    protected RTAContextInterpreter getRTAContextInterpreter() {
        return this.getContextInterpreter();
    }

    @Override
    protected boolean addConstraintsFromNode(CGNode cGNode) {
        if (this.haveAlreadyVisited(cGNode)) {
            return false;
        }
        this.markAlreadyVisited(cGNode);
        this.addNewConstraints(cGNode);
        this.addCallConstraints(cGNode);
        this.addFieldConstraints(cGNode);
        return true;
    }

    private void addNewConstraints(CGNode cGNode) {
        Iterator<NewSiteReference> iterator = this.getRTAContextInterpreter().iterateNewSites(cGNode);
        while (iterator.hasNext()) {
            NewSiteReference newSiteReference = iterator.next();
            this.visitNew(cGNode, newSiteReference);
        }
    }

    private void addCallConstraints(CGNode cGNode) {
        Iterator<CallSiteReference> iterator = this.getRTAContextInterpreter().iterateCallSites(cGNode);
        while (iterator.hasNext()) {
            CallSiteReference callSiteReference = iterator.next();
            this.visitInvoke(cGNode, callSiteReference);
        }
    }

    private void addFieldConstraints(CGNode cGNode) {
        FieldReference fieldReference;
        Iterator<FieldReference> iterator = this.getRTAContextInterpreter().iterateFieldsRead(cGNode);
        while (iterator.hasNext()) {
            fieldReference = iterator.next();
            this.processFieldAccess(cGNode, fieldReference);
        }
        iterator = this.getRTAContextInterpreter().iterateFieldsWritten(cGNode);
        while (iterator.hasNext()) {
            fieldReference = iterator.next();
            this.processFieldAccess(cGNode, fieldReference);
        }
    }

    private void processFieldAccess(CGNode cGNode, FieldReference fieldReference) {
        TypeReference typeReference = fieldReference.getDeclaringClass();
        IClass iClass = this.getClassHierarchy().lookupClass(typeReference);
        if (iClass != null) {
            this.processClassInitializer(iClass);
        }
    }

    protected void processClassInitializer(IClass iClass) {
        if (this.clinitProcessed.contains(iClass)) {
            return;
        }
        this.clinitProcessed.add(iClass);
        if (iClass.getClassInitializer() != null) {
            CGNode cGNode;
            FakeWorldClinitMethod fakeWorldClinitMethod = (FakeWorldClinitMethod)this.callGraph.getFakeWorldClinitNode().getMethod();
            MethodReference methodReference = iClass.getClassInitializer().getReference();
            CallSiteReference callSiteReference = CallSiteReference.make(1, methodReference, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.STATIC);
            IMethod iMethod = this.options.getMethodTargetSelector().getCalleeTarget(this.callGraph.getFakeRootNode(), callSiteReference, null);
            if (iMethod != null && (cGNode = this.callGraph.getNode(iMethod, Everywhere.EVERYWHERE)) == null) {
                SSAInvokeInstruction sSAInvokeInstruction = fakeWorldClinitMethod.addInvocation(null, callSiteReference);
                try {
                    cGNode = this.callGraph.findOrCreateNode(iMethod, Everywhere.EVERYWHERE);
                    this.processResolvedCall(this.callGraph.getFakeWorldClinitNode(), sSAInvokeInstruction.getCallSite(), cGNode);
                }
                catch (CancelException cancelException) {}
            }
        }
        if ((iClass = iClass.getSuperclass()) != null && !this.clinitProcessed.contains(iClass)) {
            this.processClassInitializer(iClass);
        }
    }

    public void visitInvoke(CGNode cGNode, CallSiteReference callSiteReference) {
        if (callSiteReference == null) {
            throw new IllegalArgumentException("site is null");
        }
        IInvokeInstruction.IDispatch iDispatch = callSiteReference.getInvocationCode();
        if (iDispatch == IInvokeInstruction.Dispatch.STATIC) {
            CGNode cGNode2 = this.getTargetForCall(cGNode, callSiteReference, null);
            if (cGNode2 != null) {
                this.processResolvedCall(cGNode, callSiteReference, cGNode2);
                this.processClassInitializer(this.cha.lookupClass(callSiteReference.getDeclaredTarget().getDeclaringClass()));
            }
        } else {
            PointerKey pointerKey = this.getKeyForSite(callSiteReference);
            if (pointerKey == null) {
                return;
            }
            UnaryOperator<PointsToSetVariable> unaryOperator = this.makeDispatchOperator(callSiteReference, cGNode);
            this.system.newSideEffect(unaryOperator, pointerKey);
        }
    }

    protected abstract UnaryOperator<PointsToSetVariable> makeDispatchOperator(CallSiteReference var1, CGNode var2);

    protected abstract PointerKey getKeyForSite(CallSiteReference var1);

    void processResolvedCall(CGNode cGNode, CallSiteReference callSiteReference, CGNode cGNode2) {
        cGNode.addTarget(callSiteReference, cGNode2);
        if (FakeRootMethod.isFakeRootMethod(cGNode.getMethod().getReference()) && this.entrypointCallSites.contains(callSiteReference)) {
            this.callGraph.registerEntrypoint(cGNode2);
        }
        if (!this.haveAlreadyVisited(cGNode2)) {
            this.markDiscovered(cGNode2);
        }
    }

    public void visitNew(CGNode cGNode, NewSiteReference newSiteReference) {
        if (newSiteReference == null) {
            throw new IllegalArgumentException("newSite is null");
        }
        InstanceKey instanceKey = this.getInstanceKeyForAllocation(cGNode, newSiteReference);
        if (instanceKey == null) {
            return;
        }
        IClass iClass = instanceKey.getConcreteType();
        if (iClass == null) {
            return;
        }
        if (this.allocatedClasses.contains(iClass)) {
            return;
        }
        this.allocatedClasses.add(iClass);
        this.updateSetsForNewClass(iClass, instanceKey, cGNode, newSiteReference);
        this.processClassInitializer(iClass);
    }

    protected abstract void updateSetsForNewClass(IClass var1, InstanceKey var2, CGNode var3, NewSiteReference var4);

    @Override
    protected void customInit() {
        super.customInit();
        FakeRootMethod fakeRootMethod = (FakeRootMethod)this.getCallGraph().getFakeRootNode().getMethod();
        int n = 0;
        while (n < PRE_ALLOC.length) {
            SSANewInstruction sSANewInstruction = fakeRootMethod.addAllocation(PRE_ALLOC[n]);
            this.visitNew(this.getCallGraph().getFakeRootNode(), sSANewInstruction.getNewSite());
            ++n;
        }
    }

    public Set<IClass> getAllocatedTypes() {
        return (Set)this.allocatedClasses.clone();
    }

    @Override
    protected IPointsToSolver makeSolver() {
        return new StandardSolver(this.system, this);
    }

    protected ContextSelector makeContextSelector(ContextSelector contextSelector) {
        DefaultContextSelector defaultContextSelector = new DefaultContextSelector(this.options);
        ContextSelector contextSelector2 = contextSelector == null ? defaultContextSelector : new DelegatingContextSelector(contextSelector, defaultContextSelector);
        return contextSelector2;
    }

    protected SSAContextInterpreter makeContextInterpreter(SSAContextInterpreter sSAContextInterpreter) {
        SSAContextInterpreter sSAContextInterpreter2 = new DefaultSSAInterpreter(this.getOptions(), this.getAnalysisCache());
        sSAContextInterpreter2 = new DelegatingSSAContextInterpreter(ReflectionContextInterpreter.createReflectionContextInterpreter(this.cha, this.getOptions(), this.getAnalysisCache()), sSAContextInterpreter2);
        SSAContextInterpreter sSAContextInterpreter3 = sSAContextInterpreter == null ? sSAContextInterpreter2 : new DelegatingSSAContextInterpreter(sSAContextInterpreter, sSAContextInterpreter2);
        return sSAContextInterpreter3;
    }

    @Override
    protected boolean unconditionallyAddConstraintsFromNode(CGNode cGNode) {
        this.addNewConstraints(cGNode);
        this.addCallConstraints(cGNode);
        this.addFieldConstraints(cGNode);
        this.markAlreadyVisited(cGNode);
        return true;
    }

    @Override
    protected ExplicitCallGraph createEmptyCallGraph(IClassHierarchy iClassHierarchy, AnalysisOptions analysisOptions) {
        return new DelegatingExplicitCallGraph(iClassHierarchy, analysisOptions, this.getAnalysisCache());
    }

    @Override
    protected PropagationSystem makeSystem(AnalysisOptions analysisOptions) {
        PropagationSystem propagationSystem = super.makeSystem(analysisOptions);
        propagationSystem.setVerboseInterval(10000);
        propagationSystem.setPeriodicMaintainInterval(10000);
        return propagationSystem;
    }

    @Override
    public PointerAnalysis getPointerAnalysis() {
        return TypeBasedPointerAnalysis.make(this.getOptions(), this.allocatedClasses, this.getCallGraph());
    }
}

