/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.cfa;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallString;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallStringContext;

public abstract class CallStringContextSelector
implements ContextSelector {
    public static final ContextKey CALL_STRING = new ContextKey(){

        public String toString() {
            return "CALL_STRING_KEY";
        }
    };
    private final ContextSelector base;

    public CallStringContextSelector(ContextSelector contextSelector) {
        this.base = contextSelector;
    }

    protected abstract int getLength(CGNode var1, CallSiteReference var2, IMethod var3);

    private CallString getCallString(CGNode cGNode, CallSiteReference callSiteReference, IMethod iMethod) {
        int n = this.getLength(cGNode, callSiteReference, iMethod);
        if (n > 0) {
            if (cGNode.getContext().get(CALL_STRING) != null) {
                return new CallString(callSiteReference, cGNode.getMethod(), n, (CallString)cGNode.getContext().get(CALL_STRING));
            }
            return new CallString(callSiteReference, cGNode.getMethod());
        }
        return null;
    }

    public Context getCalleeTarget(CGNode cGNode, CallSiteReference callSiteReference, IMethod iMethod, InstanceKey instanceKey) {
        Context context = this.base.getCalleeTarget(cGNode, callSiteReference, iMethod, instanceKey);
        CallString callString = this.getCallString(cGNode, callSiteReference, iMethod);
        if (callString == null) {
            return context;
        }
        if (context == Everywhere.EVERYWHERE) {
            return new CallStringContext(callString);
        }
        return new CallStringContextPair(callString, context);
    }

    private static class CallStringContextPair
    implements Context {
        private final CallString cs;
        private final Context base;

        private CallStringContextPair(CallString callString, Context context) {
            this.cs = callString;
            this.base = context;
        }

        public boolean equals(Object object) {
            return object instanceof CallStringContextPair && ((CallStringContextPair)object).cs.equals(this.cs) && ((CallStringContextPair)object).base.equals(this.base);
        }

        public String toString() {
            return "CallStringContextPair: " + this.cs.toString() + ":" + this.base.toString();
        }

        public int hashCode() {
            return this.cs.hashCode() * this.base.hashCode();
        }

        public ContextItem get(ContextKey contextKey) {
            if (CALL_STRING.equals(contextKey)) {
                return this.cs;
            }
            return this.base.get(contextKey);
        }
    }
}

