/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.ipa.callgraph.propagation.ArrayContentsKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ExceptionReturnValueKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Comparator;

public class PointerKeyComparator
implements Comparator {
    private final IClassHierarchy cha;

    public PointerKeyComparator(IClassHierarchy iClassHierarchy) {
        if (iClassHierarchy == null) {
            throw new IllegalArgumentException("null cha");
        }
        this.cha = iClassHierarchy;
    }

    protected int comparePrimitives(TypeReference typeReference, TypeReference typeReference2) {
        int n;
        int n2 = typeReference.hashCode();
        if (n2 != (n = typeReference2.hashCode())) {
            return n2 - n;
        }
        assert (typeReference == typeReference2);
        return 0;
    }

    protected int compareConcreteTypes(IClass iClass, IClass iClass2) {
        int n;
        int n2 = this.cha.getNumber(iClass);
        if (n2 != (n = this.cha.getNumber(iClass2))) {
            return n2 - n;
        }
        int n3 = iClass.hashCode();
        int n4 = iClass2.hashCode();
        assert (iClass == iClass2 || n3 != n4);
        return n3 - n4;
    }

    protected int compareInstanceKeys(InstanceKey instanceKey, InstanceKey instanceKey2) {
        return this.compareConcreteTypes(instanceKey.getConcreteType(), instanceKey2.getConcreteType());
    }

    protected int compareFields(IField iField, IField iField2) {
        int n;
        int n2 = iField.hashCode();
        if (n2 != (n = iField2.hashCode())) {
            return n2 - n;
        }
        assert (iField == iField2);
        return 0;
    }

    private int compareLocalKey(LocalPointerKey localPointerKey, Object object) {
        if (object instanceof LocalPointerKey) {
            int n;
            int n2;
            int n3 = localPointerKey.getValueNumber();
            if (n3 != (n2 = ((LocalPointerKey)object).getValueNumber())) {
                return n3 - n2;
            }
            int n4 = localPointerKey.getNode().getGraphNodeId();
            if (n4 != (n = ((LocalPointerKey)object).getNode().getGraphNodeId())) {
                return n4 - n;
            }
            assert (localPointerKey.equals(object));
            return 0;
        }
        return -1;
    }

    private int compareReturnValueKey(ReturnValueKey returnValueKey, Object object) {
        if (object instanceof ReturnValueKey) {
            int n;
            int n2 = returnValueKey.getNode().getGraphNodeId();
            if (n2 != (n = ((ReturnValueKey)object).getNode().getGraphNodeId())) {
                return n2 - n;
            }
            assert (returnValueKey.equals(object));
            return 0;
        }
        return -1;
    }

    private int compareExceptionKey(ExceptionReturnValueKey exceptionReturnValueKey, Object object) {
        if (object instanceof ExceptionReturnValueKey) {
            int n;
            int n2 = exceptionReturnValueKey.getNode().getGraphNodeId();
            if (n2 != (n = ((ExceptionReturnValueKey)object).getNode().getGraphNodeId())) {
                return n2 - n;
            }
            assert (exceptionReturnValueKey.equals(object));
            return 0;
        }
        return -1;
    }

    private int compareFieldKey(InstanceFieldKey instanceFieldKey, Object object) {
        if (object instanceof InstanceFieldKey) {
            int n = this.compareInstanceKeys(instanceFieldKey.getInstanceKey(), ((InstanceFieldKey)object).getInstanceKey());
            if (n != 0) {
                return n;
            }
            return this.compareFields(instanceFieldKey.getField(), ((InstanceFieldKey)object).getField());
        }
        return -1;
    }

    private int compareStaticKey(StaticFieldKey staticFieldKey, Object object) {
        if (object instanceof StaticFieldKey) {
            int n;
            int n2 = this.cha.getNumber(staticFieldKey.getField().getDeclaringClass());
            if (n2 != (n = this.cha.getNumber(((StaticFieldKey)object).getField().getDeclaringClass()))) {
                return n2 - n;
            }
            return this.compareFields(staticFieldKey.getField(), ((StaticFieldKey)object).getField());
        }
        return -1;
    }

    private int compareArrayKey(ArrayContentsKey arrayContentsKey, Object object) {
        if (object instanceof ArrayContentsKey) {
            int n;
            ArrayClass arrayClass = (ArrayClass)arrayContentsKey.getInstanceKey().getConcreteType();
            ArrayClass arrayClass2 = (ArrayClass)((ArrayContentsKey)object).getInstanceKey().getConcreteType();
            int n2 = arrayClass.getDimensionality();
            if (n2 != (n = arrayClass2.getDimensionality())) {
                return n2 - n;
            }
            if (arrayClass.getInnermostElementClass() == null) {
                if (arrayClass2.getInnermostElementClass() == null) {
                    return this.comparePrimitives(arrayClass.getReference().getInnermostElementType(), arrayClass2.getReference().getInnermostElementType());
                }
                return -1;
            }
            if (arrayClass2.getInnermostElementClass() == null) {
                return 1;
            }
            return this.compareConcreteTypes(arrayClass.getInnermostElementClass(), arrayClass2.getInnermostElementClass());
        }
        return -1;
    }

    public int compare(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object instanceof LocalPointerKey) {
            return this.compareLocalKey((LocalPointerKey)object, object2);
        }
        if (object2 instanceof LocalPointerKey) {
            return -1 * this.compareLocalKey((LocalPointerKey)object2, object);
        }
        if (object instanceof ReturnValueKey) {
            return this.compareReturnValueKey((ReturnValueKey)object, object2);
        }
        if (object2 instanceof ReturnValueKey) {
            return -1 * this.compareReturnValueKey((ReturnValueKey)object2, object);
        }
        if (object instanceof ExceptionReturnValueKey) {
            return this.compareExceptionKey((ExceptionReturnValueKey)object, object2);
        }
        if (object2 instanceof ExceptionReturnValueKey) {
            return -1 * this.compareExceptionKey((ExceptionReturnValueKey)object2, object);
        }
        if (object instanceof InstanceFieldKey) {
            return this.compareFieldKey((InstanceFieldKey)object, object2);
        }
        if (object2 instanceof InstanceFieldKey) {
            return -1 * this.compareFieldKey((InstanceFieldKey)object2, object);
        }
        if (object instanceof StaticFieldKey) {
            return this.compareStaticKey((StaticFieldKey)object, object2);
        }
        if (object2 instanceof StaticFieldKey) {
            return -1 * this.compareStaticKey((StaticFieldKey)object2, object);
        }
        if (object instanceof ArrayContentsKey) {
            return this.compareArrayKey((ArrayContentsKey)object, object2);
        }
        if (object2 instanceof ArrayContentsKey) {
            return -1 * this.compareArrayKey((ArrayContentsKey)object2, object);
        }
        return this.compareOtherKeys(object, object2);
    }

    protected int compareOtherKeys(Object object, Object object2) {
        System.err.println("Cannot compare " + object + " and " + object2);
        Assertions.UNREACHABLE();
        return 0;
    }

    public boolean equals(Object object) {
        return object instanceof PointerKeyComparator && ((PointerKeyComparator)object).cha.equals(this.cha);
    }

    public int hashCode() {
        return this.cha.hashCode();
    }
}

