/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.fixpoint.IntSetVariable;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AbstractFieldPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.AbstractPointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.PointsToMap;
import com.ibm.wala.ipa.callgraph.propagation.PointsToSetVariable;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.StringConstantCharArray;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointerAnalysisImpl
extends AbstractPointerAnalysis {
    private final PointsToMap pointsToMap;
    private final HeapModel H;
    private final PointerKeyFactory pointerKeys;
    private final InstanceKeyFactory iKeyFactory;
    private final PropagationCallGraphBuilder builder;

    public PointerAnalysisImpl(PropagationCallGraphBuilder propagationCallGraphBuilder, CallGraph callGraph, PointsToMap pointsToMap, MutableMapping<InstanceKey> mutableMapping, PointerKeyFactory pointerKeyFactory, InstanceKeyFactory instanceKeyFactory) {
        super(callGraph, mutableMapping);
        this.builder = propagationCallGraphBuilder;
        this.pointerKeys = pointerKeyFactory;
        this.iKeyFactory = instanceKeyFactory;
        this.pointsToMap = pointsToMap;
        if (instanceKeyFactory == null) {
            throw new IllegalArgumentException("null iKeyFactory");
        }
        this.H = this.makeHeapModel();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("PointerAnalysis:\n");
        Iterator<PointerKey> iterator = this.pointsToMap.iterateKeys();
        while (iterator.hasNext()) {
            PointerKey pointerKey = iterator.next();
            OrdinalSet<InstanceKey> ordinalSet = this.getPointsToSet(pointerKey);
            stringBuffer.append("  ").append(pointerKey).append(" ->\n");
            Iterator<InstanceKey> iterator2 = ordinalSet.iterator();
            while (iterator2.hasNext()) {
                stringBuffer.append("     ").append(iterator2.next()).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    private HeapModel makeHeapModel() {
        return new HModel();
    }

    @Override
    public OrdinalSet<InstanceKey> getPointsToSet(PointerKey pointerKey) {
        Object object;
        Object object2;
        if (this.pointsToMap.isImplicit(pointerKey)) {
            return this.computeImplicitPointsToSet(pointerKey);
        }
        if (pointerKey instanceof InstanceFieldKey && ((AbstractFieldPointerKey)(object2 = (InstanceFieldKey)pointerKey)).getInstanceKey() instanceof ConstantKey && ((ConstantKey)(object = (ConstantKey)((AbstractFieldPointerKey)object2).getInstanceKey())).getValue() instanceof String) {
            StringConstantCharArray stringConstantCharArray = StringConstantCharArray.make((ConstantKey<String>)object);
            this.instanceKeys.add(stringConstantCharArray);
            HashSet hashSet = HashSetFactory.make();
            hashSet.add(stringConstantCharArray);
            return OrdinalSet.toOrdinalSet(hashSet, this.instanceKeys);
        }
        object2 = this.pointsToMap.getPointsToSet(pointerKey);
        if (object2 == null) {
            return OrdinalSet.empty();
        }
        object = ((IntSetVariable)object2).getValue();
        return new OrdinalSet<InstanceKey>((IntSet)object, this.instanceKeys);
    }

    @Override
    public boolean isFiltered(PointerKey pointerKey) {
        if (this.pointsToMap.isImplicit(pointerKey)) {
            return false;
        }
        PointsToSetVariable pointsToSetVariable = this.pointsToMap.getPointsToSet(pointerKey);
        if (pointsToSetVariable == null) {
            return false;
        }
        return pointsToSetVariable.getPointerKey() instanceof FilteredPointerKey;
    }

    protected ImplicitPointsToSetVisitor makeImplicitPointsToVisitor(LocalPointerKey localPointerKey) {
        return new ImplicitPointsToSetVisitor(this, localPointerKey);
    }

    private OrdinalSet<InstanceKey> computeImplicitPointsToSet(PointerKey pointerKey) {
        if (pointerKey instanceof LocalPointerKey) {
            LocalPointerKey localPointerKey = (LocalPointerKey)pointerKey;
            CGNode cGNode = localPointerKey.getNode();
            IR iR = cGNode.getIR();
            DefUse defUse = cGNode.getDU();
            if (((SSAPropagationCallGraphBuilder)this.builder).contentsAreInvariant(iR.getSymbolTable(), defUse, localPointerKey.getValueNumber())) {
                InstanceKey[] instanceKeyArray = ((SSAPropagationCallGraphBuilder)this.builder).getInvariantContents(iR.getSymbolTable(), defUse, cGNode, localPointerKey.getValueNumber(), this.H, true);
                return this.toOrdinalSet(instanceKeyArray);
            }
            SSAInstruction sSAInstruction = defUse.getDef(localPointerKey.getValueNumber());
            if (sSAInstruction != null) {
                ImplicitPointsToSetVisitor implicitPointsToSetVisitor = this.makeImplicitPointsToVisitor(localPointerKey);
                sSAInstruction.visit(implicitPointsToSetVisitor);
                if (implicitPointsToSetVisitor.pointsToSet != null) {
                    return implicitPointsToSetVisitor.pointsToSet;
                }
                Assertions.UNREACHABLE("saw " + pointerKey + ": time to implement for " + sSAInstruction.getClass());
                return null;
            }
            Assertions.UNREACHABLE("unexpected null def for " + pointerKey);
            return null;
        }
        Assertions.UNREACHABLE("unexpected implicit key " + pointerKey + " that's not a local pointer key");
        return null;
    }

    private OrdinalSet<InstanceKey> computeImplicitPointsToSetAtPi(CGNode cGNode, SSAPiInstruction sSAPiInstruction) {
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
        int n = 0;
        while (n < sSAPiInstruction.getNumberOfUses()) {
            PointerKey pointerKey;
            OrdinalSet<InstanceKey> ordinalSet;
            IntSet intSet;
            int n2 = sSAPiInstruction.getUse(n);
            if (n2 != -1 && (intSet = (ordinalSet = this.getPointsToSet(pointerKey = this.pointerKeys.getPointerKeyForLocal(cGNode, n2))).getBackingSet()) != null) {
                mutableSparseIntSet.addAll(intSet);
            }
            ++n;
        }
        return new OrdinalSet<InstanceKey>(mutableSparseIntSet, this.instanceKeys);
    }

    private OrdinalSet<InstanceKey> computeImplicitPointsToSetAtPhi(CGNode cGNode, SSAPhiInstruction sSAPhiInstruction) {
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
        int n = 0;
        while (n < sSAPhiInstruction.getNumberOfUses()) {
            PointerKey pointerKey;
            OrdinalSet<InstanceKey> ordinalSet;
            IntSet intSet;
            int n2 = sSAPhiInstruction.getUse(n);
            if (n2 != -1 && (intSet = (ordinalSet = this.getPointsToSet(pointerKey = this.pointerKeys.getPointerKeyForLocal(cGNode, n2))).getBackingSet()) != null) {
                mutableSparseIntSet.addAll(intSet);
            }
            ++n;
        }
        return new OrdinalSet<InstanceKey>(mutableSparseIntSet, this.instanceKeys);
    }

    private OrdinalSet<InstanceKey> computeImplicitPointsToSetAtALoad(CGNode cGNode, SSAArrayLoadInstruction sSAArrayLoadInstruction) {
        PointerKey pointerKey = this.pointerKeys.getPointerKeyForLocal(cGNode, sSAArrayLoadInstruction.getArrayRef());
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
        OrdinalSet<InstanceKey> ordinalSet = this.getPointsToSet(pointerKey);
        for (InstanceKey instanceKey : ordinalSet) {
            PointerKey pointerKey2 = this.pointerKeys.getPointerKeyForArrayContents(instanceKey);
            OrdinalSet<InstanceKey> ordinalSet2 = this.getPointsToSet(pointerKey2);
            IntSet intSet = ordinalSet2.getBackingSet();
            if (intSet == null) continue;
            mutableSparseIntSet.addAll(intSet);
        }
        return new OrdinalSet<InstanceKey>(mutableSparseIntSet, this.instanceKeys);
    }

    private OrdinalSet<InstanceKey> computeImplicitPointsToSetAtGet(CGNode cGNode, SSAGetInstruction sSAGetInstruction) {
        return this.computeImplicitPointsToSetAtGet(cGNode, sSAGetInstruction.getDeclaredField(), sSAGetInstruction.getRef(), sSAGetInstruction.isStatic());
    }

    public OrdinalSet<InstanceKey> computeImplicitPointsToSetAtGet(CGNode cGNode, FieldReference fieldReference, int n, boolean bl) {
        IField iField = this.getCallGraph().getClassHierarchy().resolveField(fieldReference);
        if (iField == null) {
            return OrdinalSet.empty();
        }
        if (bl) {
            PointerKey pointerKey = this.pointerKeys.getPointerKeyForStaticField(iField);
            return this.getPointsToSet(pointerKey);
        }
        PointerKey pointerKey = this.pointerKeys.getPointerKeyForLocal(cGNode, n);
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
        OrdinalSet<InstanceKey> ordinalSet = this.getPointsToSet(pointerKey);
        for (InstanceKey instanceKey : ordinalSet) {
            OrdinalSet<InstanceKey> ordinalSet2;
            IntSet intSet;
            PointerKey pointerKey2 = this.pointerKeys.getPointerKeyForInstanceField(instanceKey, iField);
            if (pointerKey2 == null || (intSet = (ordinalSet2 = this.getPointsToSet(pointerKey2)).getBackingSet()) == null) continue;
            mutableSparseIntSet.addAll(intSet);
        }
        return new OrdinalSet<InstanceKey>(mutableSparseIntSet, this.instanceKeys);
    }

    private OrdinalSet<InstanceKey> computeImplicitPointsToSetAtCatch(CGNode cGNode, SSAGetCaughtExceptionInstruction sSAGetCaughtExceptionInstruction) {
        IR iR = cGNode.getIR();
        List<ProgramCounter> list = SSAPropagationCallGraphBuilder.getIncomingPEIs(iR, iR.getBasicBlockForCatch(sSAGetCaughtExceptionInstruction));
        Set<IClass> set = SSAPropagationCallGraphBuilder.getCaughtExceptionTypes(sSAGetCaughtExceptionInstruction, iR);
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
        for (ProgramCounter programCounter : list) {
            OrdinalSet<InstanceKey> ordinalSet;
            SSAInstruction sSAInstruction = iR.getPEI(programCounter);
            PointerKey pointerKey = null;
            if (sSAInstruction instanceof SSAAbstractInvokeInstruction) {
                ordinalSet = (SSAAbstractInvokeInstruction)sSAInstruction;
                pointerKey = this.pointerKeys.getPointerKeyForLocal(cGNode, ((SSAAbstractInvokeInstruction)((Object)ordinalSet)).getException());
            } else if (sSAInstruction instanceof SSAThrowInstruction) {
                ordinalSet = (SSAThrowInstruction)sSAInstruction;
                pointerKey = this.pointerKeys.getPointerKeyForLocal(cGNode, ((SSAAbstractThrowInstruction)((Object)ordinalSet)).getException());
            }
            if (pointerKey != null) {
                ordinalSet = this.getPointsToSet(pointerKey);
                for (InstanceKey instanceKey : ordinalSet) {
                    if (!PropagationCallGraphBuilder.catches(set, instanceKey.getConcreteType(), this.getCallGraph().getClassHierarchy())) continue;
                    mutableSparseIntSet.add(this.instanceKeys.getMappedIndex(instanceKey));
                }
            }
            if ((ordinalSet = sSAInstruction.getExceptionTypes()) == null) continue;
            for (TypeReference typeReference : ordinalSet) {
                InstanceKey instanceKey;
                ConcreteTypeKey concreteTypeKey;
                IClass iClass;
                if (typeReference == null || !PropagationCallGraphBuilder.catches(set, iClass = (concreteTypeKey = (ConcreteTypeKey)(instanceKey = SSAPropagationCallGraphBuilder.getInstanceKeyForPEI(cGNode, programCounter, typeReference, this.iKeyFactory))).getType(), this.getCallGraph().getClassHierarchy())) continue;
                mutableSparseIntSet.add(this.instanceKeys.getMappedIndex(SSAPropagationCallGraphBuilder.getInstanceKeyForPEI(cGNode, programCounter, typeReference, this.iKeyFactory)));
            }
        }
        return new OrdinalSet<InstanceKey>(mutableSparseIntSet, this.instanceKeys);
    }

    private OrdinalSet<InstanceKey> computeImplicitPointsToSetAtCheckCast(CGNode cGNode, SSACheckCastInstruction sSACheckCastInstruction) {
        PointerKey pointerKey = this.pointerKeys.getPointerKeyForLocal(cGNode, sSACheckCastInstruction.getVal());
        OrdinalSet<InstanceKey> ordinalSet = this.getPointsToSet(pointerKey);
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
        TypeReference[] typeReferenceArray = sSACheckCastInstruction.getDeclaredResultTypes();
        int n = typeReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeReference typeReference = typeReferenceArray[n2];
            IClass iClass = this.getCallGraph().getClassHierarchy().lookupClass(typeReference);
            if (iClass == null) {
                return ordinalSet;
            }
            if (iClass.isInterface()) {
                for (InstanceKey instanceKey : ordinalSet) {
                    if (!this.getCallGraph().getClassHierarchy().implementsInterface(instanceKey.getConcreteType(), iClass)) continue;
                    mutableSparseIntSet.add(this.getInstanceKeyMapping().getMappedIndex(instanceKey));
                }
            } else {
                for (InstanceKey instanceKey : ordinalSet) {
                    if (!this.getCallGraph().getClassHierarchy().isSubclassOf(instanceKey.getConcreteType(), iClass)) continue;
                    mutableSparseIntSet.add(this.getInstanceKeyMapping().getMappedIndex(instanceKey));
                }
            }
            ++n2;
        }
        return new OrdinalSet<InstanceKey>(mutableSparseIntSet, this.instanceKeys);
    }

    private OrdinalSet<InstanceKey> computeImplicitPointsToSetAtCall(LocalPointerKey localPointerKey, CGNode cGNode, SSAInvokeInstruction sSAInvokeInstruction) {
        int n = sSAInvokeInstruction.getException();
        if (localPointerKey.getValueNumber() == n) {
            return this.computeImplicitExceptionsForCall(cGNode, sSAInvokeInstruction);
        }
        Assertions.UNREACHABLE("time to implement me.");
        return null;
    }

    private OrdinalSet<InstanceKey> toOrdinalSet(InstanceKey[] instanceKeyArray) {
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
        int n = 0;
        while (n < instanceKeyArray.length) {
            int n2 = this.instanceKeys.getMappedIndex(instanceKeyArray[n]);
            if (n2 != -1) {
                mutableSparseIntSet.add(n2);
            } else assert (n2 != -1) : "instance " + instanceKeyArray[n] + " not mapped!";
            ++n;
        }
        return new OrdinalSet<InstanceKey>(mutableSparseIntSet, this.instanceKeys);
    }

    private OrdinalSet<InstanceKey> computeImplicitExceptionsForCall(CGNode cGNode, SSAInvokeInstruction sSAInvokeInstruction) {
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
        for (CGNode cGNode2 : this.getCallGraph().getPossibleTargets(cGNode, sSAInvokeInstruction.getCallSite())) {
            PointerKey pointerKey = this.pointerKeys.getPointerKeyForExceptionalReturnValue(cGNode2);
            IntSet intSet = this.getPointsToSet(pointerKey).getBackingSet();
            if (intSet == null) continue;
            mutableSparseIntSet.addAll(intSet);
        }
        return new OrdinalSet<InstanceKey>(mutableSparseIntSet, this.instanceKeys);
    }

    @Override
    public HeapModel getHeapModel() {
        return this.H;
    }

    @Override
    public Collection<PointerKey> getPointerKeys() {
        return Iterator2Collection.toSet(this.pointsToMap.iterateKeys());
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.builder.getClassHierarchy();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HModel
    implements HeapModel {
        private HModel() {
        }

        @Override
        public Iterator<PointerKey> iteratePointerKeys() {
            return PointerAnalysisImpl.this.pointsToMap.iterateKeys();
        }

        @Override
        public InstanceKey getInstanceKeyForAllocation(CGNode cGNode, NewSiteReference newSiteReference) {
            return PointerAnalysisImpl.this.iKeyFactory.getInstanceKeyForAllocation(cGNode, newSiteReference);
        }

        @Override
        public InstanceKey getInstanceKeyForMultiNewArray(CGNode cGNode, NewSiteReference newSiteReference, int n) {
            return PointerAnalysisImpl.this.iKeyFactory.getInstanceKeyForMultiNewArray(cGNode, newSiteReference, n);
        }

        @Override
        public <T> InstanceKey getInstanceKeyForConstant(TypeReference typeReference, T t) {
            return PointerAnalysisImpl.this.iKeyFactory.getInstanceKeyForConstant(typeReference, t);
        }

        @Override
        public InstanceKey getInstanceKeyForPEI(CGNode cGNode, ProgramCounter programCounter, TypeReference typeReference) {
            return PointerAnalysisImpl.this.iKeyFactory.getInstanceKeyForPEI(cGNode, programCounter, typeReference);
        }

        @Override
        public InstanceKey getInstanceKeyForClassObject(TypeReference typeReference) {
            return PointerAnalysisImpl.this.iKeyFactory.getInstanceKeyForClassObject(typeReference);
        }

        @Override
        public PointerKey getPointerKeyForLocal(CGNode cGNode, int n) {
            return PointerAnalysisImpl.this.pointerKeys.getPointerKeyForLocal(cGNode, n);
        }

        @Override
        public FilteredPointerKey getFilteredPointerKeyForLocal(CGNode cGNode, int n, FilteredPointerKey.TypeFilter typeFilter) {
            return PointerAnalysisImpl.this.pointerKeys.getFilteredPointerKeyForLocal(cGNode, n, typeFilter);
        }

        @Override
        public PointerKey getPointerKeyForReturnValue(CGNode cGNode) {
            return PointerAnalysisImpl.this.pointerKeys.getPointerKeyForReturnValue(cGNode);
        }

        @Override
        public PointerKey getPointerKeyForExceptionalReturnValue(CGNode cGNode) {
            return PointerAnalysisImpl.this.pointerKeys.getPointerKeyForExceptionalReturnValue(cGNode);
        }

        @Override
        public PointerKey getPointerKeyForStaticField(IField iField) {
            return PointerAnalysisImpl.this.pointerKeys.getPointerKeyForStaticField(iField);
        }

        @Override
        public PointerKey getPointerKeyForInstanceField(InstanceKey instanceKey, IField iField) {
            assert (iField != null);
            return PointerAnalysisImpl.this.pointerKeys.getPointerKeyForInstanceField(instanceKey, iField);
        }

        @Override
        public PointerKey getPointerKeyForArrayContents(InstanceKey instanceKey) {
            return PointerAnalysisImpl.this.pointerKeys.getPointerKeyForArrayContents(instanceKey);
        }

        @Override
        public IClassHierarchy getClassHierarchy() {
            return PointerAnalysisImpl.this.getCallGraph().getClassHierarchy();
        }
    }

    protected static class ImplicitPointsToSetVisitor
    extends SSAInstruction.Visitor {
        protected final PointerAnalysisImpl analysis;
        protected final CGNode node;
        protected final LocalPointerKey lpk;
        protected OrdinalSet<InstanceKey> pointsToSet = null;

        protected ImplicitPointsToSetVisitor(PointerAnalysisImpl pointerAnalysisImpl, LocalPointerKey localPointerKey) {
            this.lpk = localPointerKey;
            this.node = localPointerKey.getNode();
            this.analysis = pointerAnalysisImpl;
        }

        public void visitNew(SSANewInstruction sSANewInstruction) {
            this.pointsToSet = OrdinalSet.empty();
        }

        public void visitInvoke(SSAInvokeInstruction sSAInvokeInstruction) {
            this.pointsToSet = this.analysis.computeImplicitPointsToSetAtCall(this.lpk, this.node, sSAInvokeInstruction);
        }

        public void visitCheckCast(SSACheckCastInstruction sSACheckCastInstruction) {
            this.pointsToSet = this.analysis.computeImplicitPointsToSetAtCheckCast(this.node, sSACheckCastInstruction);
        }

        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction sSAGetCaughtExceptionInstruction) {
            this.pointsToSet = this.analysis.computeImplicitPointsToSetAtCatch(this.node, sSAGetCaughtExceptionInstruction);
        }

        public void visitGet(SSAGetInstruction sSAGetInstruction) {
            this.pointsToSet = this.analysis.computeImplicitPointsToSetAtGet(this.node, sSAGetInstruction);
        }

        public void visitPhi(SSAPhiInstruction sSAPhiInstruction) {
            this.pointsToSet = this.analysis.computeImplicitPointsToSetAtPhi(this.node, sSAPhiInstruction);
        }

        public void visitPi(SSAPiInstruction sSAPiInstruction) {
            this.pointsToSet = this.analysis.computeImplicitPointsToSetAtPi(this.node, sSAPiInstruction);
        }

        public void visitArrayLoad(SSAArrayLoadInstruction sSAArrayLoadInstruction) {
            this.pointsToSet = this.analysis.computeImplicitPointsToSetAtALoad(this.node, sSAArrayLoadInstruction);
        }
    }
}

