/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKeyFactory;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassBasedInstanceKeys
implements InstanceKeyFactory {
    private static final boolean DEBUG = false;
    private final AnalysisOptions options;
    private final IClassHierarchy cha;

    public ClassBasedInstanceKeys(AnalysisOptions analysisOptions, IClassHierarchy iClassHierarchy) {
        if (iClassHierarchy == null) {
            throw new IllegalArgumentException("null cha");
        }
        this.cha = iClassHierarchy;
        this.options = analysisOptions;
    }

    @Override
    public InstanceKey getInstanceKeyForAllocation(CGNode cGNode, NewSiteReference newSiteReference) {
        if (newSiteReference == null) {
            throw new IllegalArgumentException("allocation is null");
        }
        if (this.options.getClassTargetSelector() == null) {
            throw new IllegalStateException("options did not specify class target selector");
        }
        IClass iClass = this.options.getClassTargetSelector().getAllocatedTarget(cGNode, newSiteReference);
        if (iClass == null) {
            return null;
        }
        ConcreteTypeKey concreteTypeKey = new ConcreteTypeKey(iClass);
        return concreteTypeKey;
    }

    @Override
    public InstanceKey getInstanceKeyForMultiNewArray(CGNode cGNode, NewSiteReference newSiteReference, int n) {
        ArrayClass arrayClass = (ArrayClass)this.options.getClassTargetSelector().getAllocatedTarget(cGNode, newSiteReference);
        assert (arrayClass != null);
        if (arrayClass == null) assert (arrayClass != null) : "null type for " + newSiteReference;
        int n2 = 0;
        while (n2 <= n) {
            ++n2;
            if (arrayClass == null) {
                Assertions.UNREACHABLE();
            }
            arrayClass = (ArrayClass)arrayClass.getElementClass();
        }
        if (arrayClass == null) {
            return null;
        }
        ConcreteTypeKey concreteTypeKey = new ConcreteTypeKey(arrayClass);
        return concreteTypeKey;
    }

    @Override
    public <T> InstanceKey getInstanceKeyForConstant(TypeReference typeReference, T t) {
        if (typeReference == null || this.cha.lookupClass(typeReference) == null) {
            return null;
        }
        if (this.options.getUseConstantSpecificKeys()) {
            return new ConstantKey<T>(t, this.cha.lookupClass(typeReference));
        }
        return new ConcreteTypeKey(this.cha.lookupClass(typeReference));
    }

    @Override
    public InstanceKey getInstanceKeyForPEI(CGNode cGNode, ProgramCounter programCounter, TypeReference typeReference) {
        IClass iClass = this.cha.lookupClass(typeReference);
        if (iClass == null) {
            return null;
        }
        return new ConcreteTypeKey(this.cha.lookupClass(typeReference));
    }

    @Override
    public InstanceKey getInstanceKeyForClassObject(TypeReference typeReference) {
        IClass iClass = this.cha.lookupClass(typeReference);
        if (iClass == null) {
            return new ConcreteTypeKey(this.cha.lookupClass(TypeReference.JavaLangClass));
        }
        return new ConstantKey<IClass>(iClass, this.cha.lookupClass(TypeReference.JavaLangClass));
    }

    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }
}

