/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.propagation.ClassBasedInstanceKeys;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.MultiNewArrayInNode;
import com.ibm.wala.ipa.callgraph.propagation.NormalAllocationInNode;
import com.ibm.wala.ipa.callgraph.propagation.ReceiverInstanceContext;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerContext;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ContainerContextSelector;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllocationSiteInNodeFactory
implements InstanceKeyFactory {
    private final AnalysisOptions options;
    private final IClassHierarchy cha;
    private final ClassBasedInstanceKeys classBased;

    public AllocationSiteInNodeFactory(AnalysisOptions analysisOptions, IClassHierarchy iClassHierarchy) {
        this.options = analysisOptions;
        this.cha = iClassHierarchy;
        this.classBased = new ClassBasedInstanceKeys(analysisOptions, iClassHierarchy);
    }

    @Override
    public InstanceKey getInstanceKeyForAllocation(CGNode cGNode, NewSiteReference newSiteReference) {
        ContextItem contextItem;
        CGNode cGNode2;
        IClass iClass = this.options.getClassTargetSelector().getAllocatedTarget(cGNode, newSiteReference);
        if (iClass == null) {
            return null;
        }
        if ((cGNode.getContext() instanceof ReceiverInstanceContext || cGNode.getContext() instanceof CallerContext) && (cGNode2 = ContainerContextSelector.findNodeRecursiveMatchingContext(contextItem = cGNode.getMethod(), cGNode.getContext())) != null) {
            return new NormalAllocationInNode(cGNode2, newSiteReference, iClass);
        }
        contextItem = new NormalAllocationInNode(cGNode, newSiteReference, iClass);
        return contextItem;
    }

    @Override
    public InstanceKey getInstanceKeyForMultiNewArray(CGNode cGNode, NewSiteReference newSiteReference, int n) {
        ArrayClass arrayClass = (ArrayClass)this.options.getClassTargetSelector().getAllocatedTarget(cGNode, newSiteReference);
        if (arrayClass == null) {
            return null;
        }
        MultiNewArrayInNode multiNewArrayInNode = new MultiNewArrayInNode(cGNode, newSiteReference, arrayClass, n);
        return multiNewArrayInNode;
    }

    @Override
    public <T> InstanceKey getInstanceKeyForConstant(TypeReference typeReference, T t) {
        if (this.options.getUseConstantSpecificKeys()) {
            return new ConstantKey<T>(t, this.cha.lookupClass(typeReference));
        }
        return new ConcreteTypeKey(this.cha.lookupClass(typeReference));
    }

    @Override
    public InstanceKey getInstanceKeyForPEI(CGNode cGNode, ProgramCounter programCounter, TypeReference typeReference) {
        return this.classBased.getInstanceKeyForPEI(cGNode, programCounter, typeReference);
    }

    @Override
    public InstanceKey getInstanceKeyForClassObject(TypeReference typeReference) {
        return this.classBased.getInstanceKeyForClassObject(typeReference);
    }
}

